/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.SQLException;
import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.os.OperationCanceledException;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.Collator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DatabaseUtils {
    private static final String TAG = "DatabaseUtils";
    private static final boolean DEBUG = false;
    public static final int STATEMENT_SELECT = 1;
    public static final int STATEMENT_UPDATE = 2;
    public static final int STATEMENT_ATTACH = 3;
    public static final int STATEMENT_BEGIN = 4;
    public static final int STATEMENT_COMMIT = 5;
    public static final int STATEMENT_ABORT = 6;
    public static final int STATEMENT_PRAGMA = 7;
    public static final int STATEMENT_DDL = 8;
    public static final int STATEMENT_UNPREPARED = 9;
    public static final int STATEMENT_OTHER = 99;
    public static final int STATEMENT_WITH = 100;
    public static final int STATEMENT_CREATE = 101;
    public static final int STATEMENT_COMMENT = 102;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Collator mColl = null;

    public static void writeExceptionToParcel(Parcel reply, Exception e) {
        int code = 0;
        boolean logException = true;
        if (e instanceof FileNotFoundException) {
            code = 1;
            logException = false;
        } else if (e instanceof IllegalArgumentException) {
            code = 2;
        } else if (e instanceof UnsupportedOperationException) {
            code = 3;
        } else if (e instanceof SQLiteAbortException) {
            code = 4;
        } else if (e instanceof SQLiteConstraintException) {
            code = 5;
        } else if (e instanceof SQLiteDatabaseCorruptException) {
            code = 6;
        } else if (e instanceof SQLiteFullException) {
            code = 7;
        } else if (e instanceof SQLiteDiskIOException) {
            code = 8;
        } else if (e instanceof SQLiteException) {
            code = 9;
        } else if (e instanceof OperationApplicationException) {
            code = 10;
        } else if (e instanceof OperationCanceledException) {
            code = 11;
            logException = false;
        } else {
            reply.writeException(e);
            Log.e(TAG, "Writing exception to parcel", e);
            return;
        }
        reply.writeInt(code);
        reply.writeString(e.getMessage());
        if (logException) {
            Log.e(TAG, "Writing exception to parcel", e);
        }
    }

    public static void readExceptionFromParcel(Parcel reply) {
        int code = reply.readExceptionCode();
        if (code == 0) {
            return;
        }
        String msg = reply.readString();
        DatabaseUtils.readExceptionFromParcel(reply, msg, code);
    }

    public static void readExceptionWithFileNotFoundExceptionFromParcel(Parcel reply) throws FileNotFoundException {
        int code = reply.readExceptionCode();
        if (code == 0) {
            return;
        }
        String msg = reply.readString();
        if (code == 1) {
            throw new FileNotFoundException(msg);
        }
        DatabaseUtils.readExceptionFromParcel(reply, msg, code);
    }

    public static void readExceptionWithOperationApplicationExceptionFromParcel(Parcel reply) throws OperationApplicationException {
        int code = reply.readExceptionCode();
        if (code == 0) {
            return;
        }
        String msg = reply.readString();
        if (code == 10) {
            throw new OperationApplicationException(msg);
        }
        DatabaseUtils.readExceptionFromParcel(reply, msg, code);
    }

    private static void readExceptionFromParcel(Parcel reply, String msg, int code) {
        switch (code) {
            case 2: {
                throw new IllegalArgumentException(msg);
            }
            case 3: {
                throw new UnsupportedOperationException(msg);
            }
            case 4: {
                throw new SQLiteAbortException(msg);
            }
            case 5: {
                throw new SQLiteConstraintException(msg);
            }
            case 6: {
                throw new SQLiteDatabaseCorruptException(msg);
            }
            case 7: {
                throw new SQLiteFullException(msg);
            }
            case 8: {
                throw new SQLiteDiskIOException(msg);
            }
            case 9: {
                throw new SQLiteException(msg);
            }
            case 11: {
                throw new OperationCanceledException(msg);
            }
        }
        reply.readException(code, msg);
    }

    public static long executeInsert(@NonNull SQLiteDatabase db, @NonNull String sql, @Nullable Object[] bindArgs) throws SQLException {
        try (SQLiteStatement st = db.compileStatement(sql);){
            DatabaseUtils.bindArgs(st, bindArgs);
            long l = st.executeInsert();
            return l;
        }
    }

    public static int executeUpdateDelete(@NonNull SQLiteDatabase db, @NonNull String sql, @Nullable Object[] bindArgs) throws SQLException {
        try (SQLiteStatement st = db.compileStatement(sql);){
            DatabaseUtils.bindArgs(st, bindArgs);
            int n = st.executeUpdateDelete();
            return n;
        }
    }

    private static void bindArgs(@NonNull SQLiteStatement st, @Nullable Object[] bindArgs) {
        if (bindArgs == null) {
            return;
        }
        block6: for (int i = 0; i < bindArgs.length; ++i) {
            Object bindArg = bindArgs[i];
            switch (DatabaseUtils.getTypeOfObject(bindArg)) {
                case 0: {
                    st.bindNull(i + 1);
                    continue block6;
                }
                case 1: {
                    st.bindLong(i + 1, ((Number)bindArg).longValue());
                    continue block6;
                }
                case 2: {
                    st.bindDouble(i + 1, ((Number)bindArg).doubleValue());
                    continue block6;
                }
                case 4: {
                    st.bindBlob(i + 1, (byte[])bindArg);
                    continue block6;
                }
                default: {
                    if (bindArg instanceof Boolean) {
                        st.bindLong(i + 1, (Boolean)bindArg != false ? 1L : 0L);
                        continue block6;
                    }
                    st.bindString(i + 1, bindArg.toString());
                }
            }
        }
    }

    public static void bindObjectToProgram(SQLiteProgram prog, int index, Object value) {
        if (value == null) {
            prog.bindNull(index);
        } else if (value instanceof Double || value instanceof Float) {
            prog.bindDouble(index, ((Number)value).doubleValue());
        } else if (value instanceof Number) {
            prog.bindLong(index, ((Number)value).longValue());
        } else if (value instanceof Boolean) {
            Boolean bool2 = (Boolean)value;
            if (bool2.booleanValue()) {
                prog.bindLong(index, 1L);
            } else {
                prog.bindLong(index, 0L);
            }
        } else if (value instanceof byte[]) {
            prog.bindBlob(index, (byte[])value);
        } else {
            prog.bindString(index, value.toString());
        }
    }

    @Nullable
    public static String bindSelection(@Nullable String selection, Object ... selectionArgs) {
        if (selection == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(selectionArgs)) {
            return selection;
        }
        if (selection.indexOf(63) == -1) {
            return selection;
        }
        int before = 32;
        int after = 32;
        int argIndex = 0;
        int len = selection.length();
        StringBuilder res = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = selection.charAt(i++)) == '?') {
                after = 32;
                int start = i;
                while (i < len) {
                    c = selection.charAt(i);
                    if (c < '0' || c > '9') {
                        after = c;
                        break;
                    }
                    ++i;
                }
                if (start != i) {
                    argIndex = Integer.parseInt(selection.substring(start, i)) - 1;
                }
                Object arg = selectionArgs[argIndex++];
                if (before != 32 && before != 61) {
                    res.append(' ');
                }
                switch (DatabaseUtils.getTypeOfObject(arg)) {
                    case 0: {
                        res.append("NULL");
                        break;
                    }
                    case 1: {
                        res.append(((Number)arg).longValue());
                        break;
                    }
                    case 2: {
                        res.append(((Number)arg).doubleValue());
                        break;
                    }
                    case 4: {
                        throw new IllegalArgumentException("Blobs not supported");
                    }
                    default: {
                        if (arg instanceof Boolean) {
                            res.append((Boolean)arg != false ? 1 : 0);
                            break;
                        }
                        res.append('\'');
                        res.append(arg.toString());
                        res.append('\'');
                    }
                }
                if (after == 32) continue;
                res.append(' ');
                continue;
            }
            res.append(c);
            before = c;
        }
        return res.toString();
    }

    @Nullable
    public static Object[] deepCopyOf(@Nullable Object[] args) {
        if (args == null) {
            return null;
        }
        Object[] res = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null || arg instanceof Number || arg instanceof String) {
                res[i] = arg;
                continue;
            }
            if (arg instanceof byte[]) {
                byte[] castArg = (byte[])arg;
                res[i] = Arrays.copyOf(castArg, castArg.length);
                continue;
            }
            res[i] = String.valueOf(arg);
        }
        return res;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static int getTypeOfObject(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof byte[]) {
            return 4;
        }
        if (obj instanceof Float || obj instanceof Double) {
            return 2;
        }
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return 1;
        }
        return 3;
    }

    public static void cursorFillWindow(Cursor cursor, int position, CursorWindow window) {
        if (position < 0 || position >= cursor.getCount()) {
            return;
        }
        int oldPos = cursor.getPosition();
        int numColumns = cursor.getColumnCount();
        window.clear();
        window.setStartPosition(position);
        window.setNumColumns(numColumns);
        if (cursor.moveToPosition(position)) {
            block6: while (window.allocRow()) {
                for (int i = 0; i < numColumns; ++i) {
                    boolean success;
                    int type = cursor.getType(i);
                    switch (type) {
                        case 0: {
                            success = window.putNull(position, i);
                            break;
                        }
                        case 1: {
                            success = window.putLong(cursor.getLong(i), position, i);
                            break;
                        }
                        case 2: {
                            success = window.putDouble(cursor.getDouble(i), position, i);
                            break;
                        }
                        case 4: {
                            Object value = cursor.getBlob(i);
                            success = value != null ? window.putBlob((byte[])value, position, i) : window.putNull(position, i);
                            break;
                        }
                        default: {
                            Object value = cursor.getString(i);
                            success = value != null ? window.putString((String)value, position, i) : window.putNull(position, i);
                            break;
                        }
                    }
                    if (success) continue;
                    window.freeLastRow();
                    break block6;
                }
                ++position;
                if (cursor.moveToNext()) continue;
            }
        }
        cursor.moveToPosition(oldPos);
    }

    public static void appendEscapedSQLString(StringBuilder sb, String sqlString) {
        sb.append('\'');
        int length = sqlString.length();
        for (int i = 0; i < length; ++i) {
            char c = sqlString.charAt(i);
            if (Character.isHighSurrogate(c)) {
                if (i == length - 1 || !Character.isLowSurrogate(sqlString.charAt(i + 1))) continue;
                sb.append(c);
                sb.append(sqlString.charAt(i + 1));
                continue;
            }
            if (Character.isLowSurrogate(c)) continue;
            if (c == '\'') {
                sb.append('\'');
            }
            sb.append(c);
        }
        sb.append('\'');
    }

    public static String sqlEscapeString(String value) {
        StringBuilder escaper = new StringBuilder();
        DatabaseUtils.appendEscapedSQLString(escaper, value);
        return escaper.toString();
    }

    public static void appendValueToSql(StringBuilder sql, Object value) {
        if (value == null) {
            sql.append("NULL");
        } else if (value instanceof Boolean) {
            Boolean bool2 = (Boolean)value;
            if (bool2.booleanValue()) {
                sql.append('1');
            } else {
                sql.append('0');
            }
        } else {
            DatabaseUtils.appendEscapedSQLString(sql, value.toString());
        }
    }

    public static String concatenateWhere(String a, String b) {
        if (TextUtils.isEmpty(a)) {
            return b;
        }
        if (TextUtils.isEmpty(b)) {
            return a;
        }
        return "(" + a + ") AND (" + b + ")";
    }

    public static String getCollationKey(String name) {
        byte[] arr = DatabaseUtils.getCollationKeyInBytes(name);
        try {
            return new String(arr, 0, DatabaseUtils.getKeyLen(arr), "ISO8859_1");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getHexCollationKey(String name) {
        byte[] arr = DatabaseUtils.getCollationKeyInBytes(name);
        char[] keys = DatabaseUtils.encodeHex(arr);
        return new String(keys, 0, DatabaseUtils.getKeyLen(arr) * 2);
    }

    private static char[] encodeHex(byte[] input) {
        int l = input.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & input[i]) >>> 4];
            out[j++] = DIGITS[0xF & input[i]];
        }
        return out;
    }

    private static int getKeyLen(byte[] arr) {
        if (arr[arr.length - 1] != 0) {
            return arr.length;
        }
        return arr.length - 1;
    }

    private static byte[] getCollationKeyInBytes(String name) {
        if (mColl == null) {
            mColl = Collator.getInstance();
            mColl.setStrength(0);
        }
        return mColl.getCollationKey(name).toByteArray();
    }

    public static void dumpCursor(Cursor cursor) {
        DatabaseUtils.dumpCursor(cursor, System.out);
    }

    public static void dumpCursor(Cursor cursor, PrintStream stream) {
        stream.println(">>>>> Dumping cursor " + cursor);
        if (cursor != null) {
            int startPos = cursor.getPosition();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                DatabaseUtils.dumpCurrentRow(cursor, stream);
            }
            cursor.moveToPosition(startPos);
        }
        stream.println("<<<<<");
    }

    public static void dumpCursor(Cursor cursor, StringBuilder sb) {
        sb.append(">>>>> Dumping cursor ").append(cursor).append('\n');
        if (cursor != null) {
            int startPos = cursor.getPosition();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                DatabaseUtils.dumpCurrentRow(cursor, sb);
            }
            cursor.moveToPosition(startPos);
        }
        sb.append("<<<<<\n");
    }

    public static String dumpCursorToString(Cursor cursor) {
        StringBuilder sb = new StringBuilder();
        DatabaseUtils.dumpCursor(cursor, sb);
        return sb.toString();
    }

    public static void dumpCurrentRow(Cursor cursor) {
        DatabaseUtils.dumpCurrentRow(cursor, System.out);
    }

    public static void dumpCurrentRow(Cursor cursor, PrintStream stream) {
        String[] cols = cursor.getColumnNames();
        stream.println("" + cursor.getPosition() + " {");
        int length = cols.length;
        for (int i = 0; i < length; ++i) {
            String value;
            try {
                value = cursor.getString(i);
            }
            catch (SQLiteException e) {
                value = "<unprintable>";
            }
            stream.println("   " + cols[i] + '=' + value);
        }
        stream.println("}");
    }

    public static void dumpCurrentRow(Cursor cursor, StringBuilder sb) {
        String[] cols = cursor.getColumnNames();
        sb.append(cursor.getPosition()).append(" {\n");
        int length = cols.length;
        for (int i = 0; i < length; ++i) {
            String value;
            try {
                value = cursor.getString(i);
            }
            catch (SQLiteException e) {
                value = "<unprintable>";
            }
            sb.append("   ").append(cols[i]).append('=').append(value).append('\n');
        }
        sb.append("}\n");
    }

    public static String dumpCurrentRowToString(Cursor cursor) {
        StringBuilder sb = new StringBuilder();
        DatabaseUtils.dumpCurrentRow(cursor, sb);
        return sb.toString();
    }

    public static void cursorStringToContentValues(Cursor cursor, String field, ContentValues values) {
        DatabaseUtils.cursorStringToContentValues(cursor, field, values, field);
    }

    public static void cursorStringToInsertHelper(Cursor cursor, String field, InsertHelper inserter, int index) {
        inserter.bind(index, cursor.getString(cursor.getColumnIndexOrThrow(field)));
    }

    public static void cursorStringToContentValues(Cursor cursor, String field, ContentValues values, String key) {
        values.put(key, cursor.getString(cursor.getColumnIndexOrThrow(field)));
    }

    public static void cursorIntToContentValues(Cursor cursor, String field, ContentValues values) {
        DatabaseUtils.cursorIntToContentValues(cursor, field, values, field);
    }

    public static void cursorIntToContentValues(Cursor cursor, String field, ContentValues values, String key) {
        int colIndex = cursor.getColumnIndex(field);
        if (!cursor.isNull(colIndex)) {
            values.put(key, cursor.getInt(colIndex));
        } else {
            values.put(key, (Integer)null);
        }
    }

    public static void cursorLongToContentValues(Cursor cursor, String field, ContentValues values) {
        DatabaseUtils.cursorLongToContentValues(cursor, field, values, field);
    }

    public static void cursorLongToContentValues(Cursor cursor, String field, ContentValues values, String key) {
        int colIndex = cursor.getColumnIndex(field);
        if (!cursor.isNull(colIndex)) {
            Long value = cursor.getLong(colIndex);
            values.put(key, value);
        } else {
            values.put(key, (Long)null);
        }
    }

    public static void cursorDoubleToCursorValues(Cursor cursor, String field, ContentValues values) {
        DatabaseUtils.cursorDoubleToContentValues(cursor, field, values, field);
    }

    public static void cursorDoubleToContentValues(Cursor cursor, String field, ContentValues values, String key) {
        int colIndex = cursor.getColumnIndex(field);
        if (!cursor.isNull(colIndex)) {
            values.put(key, cursor.getDouble(colIndex));
        } else {
            values.put(key, (Double)null);
        }
    }

    public static void cursorRowToContentValues(Cursor cursor, ContentValues values) {
        String[] columns = cursor.getColumnNames();
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            if (cursor.getType(i) == 4) {
                values.put(columns[i], cursor.getBlob(i));
                continue;
            }
            values.put(columns[i], cursor.getString(i));
        }
    }

    @UnsupportedAppUsage
    public static int cursorPickFillWindowStartPosition(int cursorPosition, int cursorWindowCapacity) {
        return Math.max(cursorPosition - cursorWindowCapacity / 3, 0);
    }

    public static long queryNumEntries(SQLiteDatabase db, String table) {
        return DatabaseUtils.queryNumEntries(db, table, null, null);
    }

    public static long queryNumEntries(SQLiteDatabase db, String table, String selection) {
        return DatabaseUtils.queryNumEntries(db, table, selection, null);
    }

    public static long queryNumEntries(SQLiteDatabase db, String table, String selection, String[] selectionArgs) {
        String s = !TextUtils.isEmpty(selection) ? " where " + selection : "";
        return DatabaseUtils.longForQuery(db, "select count(*) from " + table + s, selectionArgs);
    }

    public static boolean queryIsEmpty(SQLiteDatabase db, String table) {
        long isEmpty = DatabaseUtils.longForQuery(db, "select exists(select 1 from " + table + ")", null);
        return isEmpty == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long longForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        try (SQLiteStatement prog = db.compileStatement(query);){
            long l = DatabaseUtils.longForQuery(prog, selectionArgs);
            return l;
        }
    }

    public static long longForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        try (SQLiteStatement prog = db.compileStatement(query);){
            String string2 = DatabaseUtils.stringForQuery(prog, selectionArgs);
            return string2;
        }
    }

    public static String stringForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParcelFileDescriptor blobFileDescriptorForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        try (SQLiteStatement prog = db.compileStatement(query);){
            ParcelFileDescriptor parcelFileDescriptor = DatabaseUtils.blobFileDescriptorForQuery(prog, selectionArgs);
            return parcelFileDescriptor;
        }
    }

    public static ParcelFileDescriptor blobFileDescriptorForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForBlobFileDescriptor();
    }

    public static void cursorStringToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getString(index));
        }
    }

    public static void cursorLongToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getLong(index));
        }
    }

    public static void cursorShortToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getShort(index));
        }
    }

    public static void cursorIntToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getInt(index));
        }
    }

    public static void cursorFloatToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, Float.valueOf(cursor.getFloat(index)));
        }
    }

    public static void cursorDoubleToContentValuesIfPresent(Cursor cursor, ContentValues values, String column) {
        int index = cursor.getColumnIndex(column);
        if (index != -1 && !cursor.isNull(index)) {
            values.put(column, cursor.getDouble(index));
        }
    }

    public static void createDbFromSqlStatements(Context context, String dbName, int dbVersion, String sqlStatements) {
        String[] statements;
        SQLiteDatabase db = context.openOrCreateDatabase(dbName, 0, null);
        for (String statement : statements = TextUtils.split(sqlStatements, ";\n")) {
            if (TextUtils.isEmpty(statement)) continue;
            db.execSQL(statement);
        }
        db.setVersion(dbVersion);
        db.close();
    }

    private static int getSqlStatementPrefixOffset(String s) {
        int limit = s.length() - 2;
        if (limit < 0) {
            return -1;
        }
        int i = 0;
        while (i < limit) {
            char c = s.charAt(i);
            if (c <= ' ') {
                ++i;
                continue;
            }
            if (c == '-') {
                if (s.charAt(i + 1) != '-') {
                    return i;
                }
                if ((i = s.indexOf(10, i + 2)) < 0) {
                    return -1;
                }
                ++i;
                continue;
            }
            if (c == '/') {
                if (s.charAt(i + 1) != '*') {
                    return i;
                }
                ++i;
                do {
                    if ((i = s.indexOf(42, i + 1)) >= 0) continue;
                    return -1;
                } while (s.charAt(++i) != '/');
                ++i;
                continue;
            }
            return i;
        }
        return -1;
    }

    private static String getSqlStatementPrefixExtendedNoRegex(String sql) {
        int n = DatabaseUtils.getSqlStatementPrefixOffset(sql);
        if (n < 0) {
            return null;
        }
        int end = sql.length();
        if (n > end) {
            return null;
        }
        int eos = Math.min(n + 3, end);
        return sql.substring(n, eos).toUpperCase(Locale.ROOT);
    }

    private static int categorizeStatement(@NonNull String prefix, @NonNull String sql) {
        if (prefix == null) {
            return 99;
        }
        switch (prefix) {
            case "SEL": {
                return 1;
            }
            case "INS": 
            case "UPD": 
            case "REP": 
            case "DEL": {
                return 2;
            }
            case "ATT": {
                return 3;
            }
            case "COM": 
            case "END": {
                return 5;
            }
            case "ROL": {
                if (sql.toUpperCase(Locale.ROOT).contains(" TO ")) {
                    return 99;
                }
                return 6;
            }
            case "BEG": {
                return 4;
            }
            case "PRA": {
                return 7;
            }
            case "CRE": {
                return 101;
            }
            case "DRO": 
            case "ALT": {
                return 8;
            }
            case "ANA": 
            case "DET": {
                return 9;
            }
            case "WIT": {
                return 100;
            }
        }
        if (prefix.startsWith("--") || prefix.startsWith("/*")) {
            return 102;
        }
        return 99;
    }

    public static int getSqlStatementTypeExtended(@NonNull String sql) {
        return DatabaseUtils.categorizeStatement(DatabaseUtils.getSqlStatementPrefixExtendedNoRegex(sql), sql);
    }

    public static int getSqlStatementType(int extended) {
        switch (extended) {
            case 101: {
                return 8;
            }
            case 100: {
                return 99;
            }
            case 102: {
                return 99;
            }
        }
        return extended;
    }

    public static int getSqlStatementType(String sql) {
        return DatabaseUtils.getSqlStatementType(DatabaseUtils.getSqlStatementTypeExtended(sql));
    }

    public static String[] appendSelectionArgs(String[] originalValues, String[] newValues) {
        if (originalValues == null || originalValues.length == 0) {
            return newValues;
        }
        String[] result = new String[originalValues.length + newValues.length];
        System.arraycopy(originalValues, 0, result, 0, originalValues.length);
        System.arraycopy(newValues, 0, result, originalValues.length, newValues.length);
        return result;
    }

    public static int findRowIdColumnIndex(String[] columnNames) {
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equals("_id")) continue;
            return i;
        }
        return -1;
    }

    public static String escapeForLike(@NonNull String arg) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '%': {
                    sb.append('\\');
                    break;
                }
                case '_': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Deprecated
    public static class InsertHelper {
        private final SQLiteDatabase mDb;
        private final String mTableName;
        private HashMap<String, Integer> mColumns;
        private String mInsertSQL = null;
        private SQLiteStatement mInsertStatement = null;
        private SQLiteStatement mReplaceStatement = null;
        private SQLiteStatement mPreparedStatement = null;
        public static final int TABLE_INFO_PRAGMA_COLUMNNAME_INDEX = 1;
        public static final int TABLE_INFO_PRAGMA_DEFAULT_INDEX = 4;

        public InsertHelper(SQLiteDatabase db, String tableName) {
            this.mDb = db;
            this.mTableName = tableName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildSQL() throws SQLException {
            StringBuilder sb = new StringBuilder(128);
            sb.append("INSERT INTO ");
            sb.append(this.mTableName);
            sb.append(" (");
            StringBuilder sbv = new StringBuilder(128);
            sbv.append("VALUES (");
            int i = 1;
            try (Cursor cur = null;){
                cur = this.mDb.rawQuery("PRAGMA table_info(" + this.mTableName + ")", null);
                this.mColumns = new HashMap(cur.getCount());
                while (cur.moveToNext()) {
                    String columnName = cur.getString(1);
                    String defaultValue = cur.getString(4);
                    this.mColumns.put(columnName, i);
                    sb.append("'");
                    sb.append(columnName);
                    sb.append("'");
                    if (defaultValue == null) {
                        sbv.append("?");
                    } else {
                        sbv.append("COALESCE(?, ");
                        sbv.append(defaultValue);
                        sbv.append(")");
                    }
                    sb.append(i == cur.getCount() ? ") " : ", ");
                    sbv.append(i == cur.getCount() ? ");" : ", ");
                    ++i;
                }
            }
            sb.append((CharSequence)sbv);
            this.mInsertSQL = sb.toString();
        }

        private SQLiteStatement getStatement(boolean allowReplace) throws SQLException {
            if (allowReplace) {
                if (this.mReplaceStatement == null) {
                    if (this.mInsertSQL == null) {
                        this.buildSQL();
                    }
                    String replaceSQL = "INSERT OR REPLACE" + this.mInsertSQL.substring(6);
                    this.mReplaceStatement = this.mDb.compileStatement(replaceSQL);
                }
                return this.mReplaceStatement;
            }
            if (this.mInsertStatement == null) {
                if (this.mInsertSQL == null) {
                    this.buildSQL();
                }
                this.mInsertStatement = this.mDb.compileStatement(this.mInsertSQL);
            }
            return this.mInsertStatement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long insertInternal(ContentValues values, boolean allowReplace) {
            this.mDb.beginTransactionNonExclusive();
            try {
                SQLiteStatement stmt = this.getStatement(allowReplace);
                stmt.clearBindings();
                for (Map.Entry<String, Object> e : values.valueSet()) {
                    String key = e.getKey();
                    int i = this.getColumnIndex(key);
                    DatabaseUtils.bindObjectToProgram(stmt, i, e.getValue());
                }
                long result = stmt.executeInsert();
                this.mDb.setTransactionSuccessful();
                long l = result;
                return l;
            }
            catch (SQLException e) {
                Log.e(DatabaseUtils.TAG, "Error inserting " + values + " into table  " + this.mTableName, e);
                long l = -1L;
                return l;
            }
            finally {
                this.mDb.endTransaction();
            }
        }

        public int getColumnIndex(String key) {
            this.getStatement(false);
            Integer index = this.mColumns.get(key);
            if (index == null) {
                throw new IllegalArgumentException("column '" + key + "' is invalid");
            }
            return index;
        }

        public void bind(int index, double value) {
            this.mPreparedStatement.bindDouble(index, value);
        }

        public void bind(int index, float value) {
            this.mPreparedStatement.bindDouble(index, value);
        }

        public void bind(int index, long value) {
            this.mPreparedStatement.bindLong(index, value);
        }

        public void bind(int index, int value) {
            this.mPreparedStatement.bindLong(index, value);
        }

        public void bind(int index, boolean value) {
            this.mPreparedStatement.bindLong(index, value ? 1L : 0L);
        }

        public void bindNull(int index) {
            this.mPreparedStatement.bindNull(index);
        }

        public void bind(int index, byte[] value) {
            if (value == null) {
                this.mPreparedStatement.bindNull(index);
            } else {
                this.mPreparedStatement.bindBlob(index, value);
            }
        }

        public void bind(int index, String value) {
            if (value == null) {
                this.mPreparedStatement.bindNull(index);
            } else {
                this.mPreparedStatement.bindString(index, value);
            }
        }

        public long insert(ContentValues values) {
            return this.insertInternal(values, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long execute() {
            if (this.mPreparedStatement == null) {
                throw new IllegalStateException("you must prepare this inserter before calling execute");
            }
            try {
                long l = this.mPreparedStatement.executeInsert();
                return l;
            }
            catch (SQLException e) {
                Log.e(DatabaseUtils.TAG, "Error executing InsertHelper with table " + this.mTableName, e);
                long l = -1L;
                return l;
            }
            finally {
                this.mPreparedStatement = null;
            }
        }

        public void prepareForInsert() {
            this.mPreparedStatement = this.getStatement(false);
            this.mPreparedStatement.clearBindings();
        }

        public void prepareForReplace() {
            this.mPreparedStatement = this.getStatement(true);
            this.mPreparedStatement.clearBindings();
        }

        public long replace(ContentValues values) {
            return this.insertInternal(values, true);
        }

        public void close() {
            if (this.mInsertStatement != null) {
                this.mInsertStatement.close();
                this.mInsertStatement = null;
            }
            if (this.mReplaceStatement != null) {
                this.mReplaceStatement.close();
                this.mReplaceStatement = null;
            }
            this.mInsertSQL = null;
            this.mColumns = null;
        }
    }
}

