/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import android.util.LongSparseArray;
import java.lang.ref.WeakReference;

@RavenwoodKeepWholeClass
abstract class ThemedResourceCache<T> {
    public static final int UNDEFINED_GENERATION = -1;
    @UnsupportedAppUsage
    private ArrayMap<Resources.ThemeKey, LongSparseArray<WeakReference<T>>> mThemedEntries;
    private LongSparseArray<WeakReference<T>> mUnthemedEntries;
    private LongSparseArray<WeakReference<T>> mNullThemedEntries;
    private int mGeneration;

    ThemedResourceCache() {
    }

    public void put(long key, @Nullable Resources.Theme theme, @NonNull T entry, int generation) {
        this.put(key, theme, entry, generation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long key, @Nullable Resources.Theme theme, @NonNull T entry, int generation, boolean usesTheme) {
        if (entry == null) {
            return;
        }
        ThemedResourceCache themedResourceCache = this;
        synchronized (themedResourceCache) {
            LongSparseArray<WeakReference<T>> entries = !usesTheme ? this.getUnthemedLocked(true) : this.getThemedLocked(theme, true);
            if (entries != null && (generation == this.mGeneration || generation == -1)) {
                entries.put(key, new WeakReference<T>(entry));
            }
        }
    }

    public int getGeneration() {
        return this.mGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T get(long key, @Nullable Resources.Theme theme) {
        ThemedResourceCache themedResourceCache = this;
        synchronized (themedResourceCache) {
            WeakReference<T> unthemedEntry;
            WeakReference<T> themedEntry;
            LongSparseArray<WeakReference<T>> themedEntries = this.getThemedLocked(theme, false);
            if (themedEntries != null && (themedEntry = themedEntries.get(key)) != null) {
                return themedEntry.get();
            }
            LongSparseArray<WeakReference<T>> unthemedEntries = this.getUnthemedLocked(false);
            if (unthemedEntries != null && (unthemedEntry = unthemedEntries.get(key)) != null) {
                return unthemedEntry.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void onConfigurationChange(int configChanges) {
        ThemedResourceCache themedResourceCache = this;
        synchronized (themedResourceCache) {
            this.pruneLocked(configChanges);
            ++this.mGeneration;
        }
    }

    protected abstract boolean shouldInvalidateEntry(@NonNull T var1, int var2);

    @Nullable
    private LongSparseArray<WeakReference<T>> getThemedLocked(@Nullable Resources.Theme t, boolean create) {
        Resources.ThemeKey key;
        LongSparseArray<WeakReference<Object>> cache;
        if (t == null) {
            if (this.mNullThemedEntries == null && create) {
                this.mNullThemedEntries = new LongSparseArray(1);
            }
            return this.mNullThemedEntries;
        }
        if (this.mThemedEntries == null) {
            if (create) {
                this.mThemedEntries = new ArrayMap(1);
            } else {
                return null;
            }
        }
        if ((cache = this.mThemedEntries.get(key = t.getKey())) == null && create) {
            cache = new LongSparseArray(1);
            Resources.ThemeKey keyClone = key.clone();
            this.mThemedEntries.put(keyClone, cache);
        }
        return cache;
    }

    @Nullable
    private LongSparseArray<WeakReference<T>> getUnthemedLocked(boolean create) {
        if (this.mUnthemedEntries == null && create) {
            this.mUnthemedEntries = new LongSparseArray(1);
        }
        return this.mUnthemedEntries;
    }

    private boolean pruneLocked(int configChanges) {
        if (this.mThemedEntries != null) {
            for (int i = this.mThemedEntries.size() - 1; i >= 0; --i) {
                if (!this.pruneEntriesLocked(this.mThemedEntries.valueAt(i), configChanges)) continue;
                this.mThemedEntries.removeAt(i);
            }
        }
        this.pruneEntriesLocked(this.mNullThemedEntries, configChanges);
        this.pruneEntriesLocked(this.mUnthemedEntries, configChanges);
        return this.mThemedEntries == null && this.mNullThemedEntries == null && this.mUnthemedEntries == null;
    }

    private boolean pruneEntriesLocked(@Nullable LongSparseArray<WeakReference<T>> entries, int configChanges) {
        if (entries == null) {
            return true;
        }
        for (int i = entries.size() - 1; i >= 0; --i) {
            WeakReference<T> ref = entries.valueAt(i);
            if (ref != null && !this.pruneEntryLocked(ref.get(), configChanges)) continue;
            entries.removeAt(i);
        }
        return entries.size() == 0;
    }

    private boolean pruneEntryLocked(@Nullable T entry, int configChanges) {
        return entry == null || configChanges != 0 && this.shouldInvalidateEntry(entry, configChanges);
    }

    public synchronized void clear() {
        if (this.mThemedEntries != null) {
            this.mThemedEntries.clear();
        }
        if (this.mUnthemedEntries != null) {
            this.mUnthemedEntries.clear();
        }
        if (this.mNullThemedEntries != null) {
            this.mNullThemedEntries.clear();
        }
    }
}

