/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.dex;

import android.content.pm.parsing.ApkLiteParseUtils;
import android.content.pm.parsing.PackageLite;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.JsonReader;
import android.util.Log;
import android.util.jar.StrictJarFile;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.security.VerityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;

public class DexMetadataHelper {
    public static final String TAG = "DexMetadataHelper";
    public static final boolean DEBUG = Log.isLoggable("DexMetadataHelper", 3);
    private static final String PROPERTY_DM_JSON_MANIFEST_REQUIRED = "pm.dexopt.dm.require_manifest";
    private static final String PROPERTY_DM_FSVERITY_REQUIRED = "pm.dexopt.dm.require_fsverity";
    private static final String DEX_METADATA_FILE_EXTENSION = ".dm";

    private DexMetadataHelper() {
    }

    public static boolean isDexMetadataFile(File file) {
        return DexMetadataHelper.isDexMetadataPath(file.getName());
    }

    private static boolean isDexMetadataPath(String path) {
        return path.endsWith(DEX_METADATA_FILE_EXTENSION);
    }

    public static boolean isFsVerityRequired() {
        return VerityUtils.isFsVeritySupported() && SystemProperties.getBoolean(PROPERTY_DM_FSVERITY_REQUIRED, false);
    }

    public static long getPackageDexMetadataSize(PackageLite pkg) {
        long sizeBytes = 0L;
        Collection<String> dexMetadataList = DexMetadataHelper.getPackageDexMetadata(pkg).values();
        for (String dexMetadata : dexMetadataList) {
            sizeBytes += new File(dexMetadata).length();
        }
        return sizeBytes;
    }

    public static File findDexMetadataForFile(File targetFile) {
        String dexMetadataPath = DexMetadataHelper.buildDexMetadataPathForFile(targetFile);
        File dexMetadataFile = new File(dexMetadataPath);
        return dexMetadataFile.exists() ? dexMetadataFile : null;
    }

    private static Map<String, String> getPackageDexMetadata(PackageLite pkg) {
        return DexMetadataHelper.buildPackageApkToDexMetadataMap(pkg.getAllApkPaths());
    }

    public static Map<String, String> buildPackageApkToDexMetadataMap(List<String> codePaths) {
        ArrayMap<String, String> result = new ArrayMap<String, String>();
        for (int i = codePaths.size() - 1; i >= 0; --i) {
            String codePath = codePaths.get(i);
            String dexMetadataPath = DexMetadataHelper.buildDexMetadataPathForFile(new File(codePath));
            if (!Files.exists(Paths.get(dexMetadataPath, new String[0]), new LinkOption[0])) continue;
            result.put(codePath, dexMetadataPath);
        }
        return result;
    }

    public static String buildDexMetadataPathForApk(String codePath) {
        if (!ApkLiteParseUtils.isApkPath(codePath)) {
            throw new IllegalStateException("Corrupted package. Code path is not an apk " + codePath);
        }
        return codePath.substring(0, codePath.length() - ".apk".length()) + DEX_METADATA_FILE_EXTENSION;
    }

    private static String buildDexMetadataPathForFile(File targetFile) {
        return ApkLiteParseUtils.isApkFile(targetFile) ? DexMetadataHelper.buildDexMetadataPathForApk(targetFile.getPath()) : targetFile.getPath() + DEX_METADATA_FILE_EXTENSION;
    }

    public static ParseResult validateDexMetadataFile(ParseInput input, String dmaPath, String packageName, long versionCode) {
        return DexMetadataHelper.validateDexMetadataFile(input, dmaPath, packageName, versionCode, SystemProperties.getBoolean(PROPERTY_DM_JSON_MANIFEST_REQUIRED, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static ParseResult validateDexMetadataFile(ParseInput input, String dmaPath, String packageName, long versionCode, boolean requireManifest) {
        StrictJarFile jarFile = null;
        if (DEBUG) {
            Log.v(TAG, "validateDexMetadataFile: " + dmaPath + ", " + packageName + ", " + versionCode);
        }
        try {
            jarFile = new StrictJarFile(dmaPath, false, false);
            ParseResult parseResult = DexMetadataHelper.validateDexMetadataManifest(input, dmaPath, jarFile, packageName, versionCode, requireManifest);
            return parseResult;
        }
        catch (IOException e) {
            ParseResult parseResult = input.error(-117, "Error opening " + dmaPath, e);
            return parseResult;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static ParseResult validateDexMetadataManifest(ParseInput input, String dmaPath, StrictJarFile jarFile, String packageName, long versionCode, boolean requireManifest) throws IOException {
        JsonReader reader;
        if (!requireManifest) {
            if (DEBUG) {
                Log.v(TAG, "validateDexMetadataManifest: " + dmaPath + " manifest.json check skipped");
            }
            return input.success(null);
        }
        ZipEntry zipEntry = jarFile.findEntry("manifest.json");
        if (zipEntry == null) {
            return input.error(-117, "Missing manifest.json in " + dmaPath);
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        try {
            reader = new JsonReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return input.error(-117, "Error opening manifest.json in " + dmaPath, e);
        }
        String jsonPackageName = null;
        long jsonVersionCode = -1L;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("packageName")) {
                jsonPackageName = reader.nextString();
                continue;
            }
            if (name.equals("versionCode")) {
                jsonVersionCode = reader.nextLong();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (jsonPackageName == null || jsonVersionCode == -1L) {
            return input.error(-117, "manifest.json in " + dmaPath + " is missing 'packageName' and/or 'versionCode'");
        }
        if (!jsonPackageName.equals(packageName)) {
            return input.error(-117, "manifest.json in " + dmaPath + " has invalid packageName: " + jsonPackageName + ", expected: " + packageName);
        }
        if (versionCode != jsonVersionCode) {
            return input.error(-117, "manifest.json in " + dmaPath + " has invalid versionCode: " + jsonVersionCode + ", expected: " + versionCode);
        }
        if (DEBUG) {
            Log.v(TAG, "validateDexMetadataManifest: " + dmaPath + ", " + packageName + ", " + versionCode + ": successful");
        }
        return input.success(null);
    }

    public static void validateDexPaths(String[] paths) {
        ArrayList<String> apks = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            if (!ApkLiteParseUtils.isApkPath(paths[i])) continue;
            apks.add(paths[i]);
        }
        ArrayList<String> unmatchedDmFiles = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            String dmPath = paths[i];
            if (!DexMetadataHelper.isDexMetadataPath(dmPath)) continue;
            boolean valid = false;
            for (int j = apks.size() - 1; j >= 0; --j) {
                if (!dmPath.equals(DexMetadataHelper.buildDexMetadataPathForFile(new File((String)apks.get(j))))) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            unmatchedDmFiles.add(dmPath);
        }
        if (!unmatchedDmFiles.isEmpty()) {
            throw new IllegalStateException("Unmatched .dm files: " + unmatchedDmFiles);
        }
    }
}

