/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.Parcelling;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Set;

public class PermissionInfo
extends PackageItemInfo
implements Parcelable {
    public static final int PROTECTION_NORMAL = 0;
    public static final int PROTECTION_DANGEROUS = 1;
    public static final int PROTECTION_SIGNATURE = 2;
    @Deprecated
    public static final int PROTECTION_SIGNATURE_OR_SYSTEM = 3;
    public static final int PROTECTION_INTERNAL = 4;
    public static final int PROTECTION_FLAG_PRIVILEGED = 16;
    @Deprecated
    public static final int PROTECTION_FLAG_SYSTEM = 16;
    public static final int PROTECTION_FLAG_DEVELOPMENT = 32;
    public static final int PROTECTION_FLAG_APPOP = 64;
    public static final int PROTECTION_FLAG_PRE23 = 128;
    public static final int PROTECTION_FLAG_INSTALLER = 256;
    public static final int PROTECTION_FLAG_VERIFIER = 512;
    public static final int PROTECTION_FLAG_PREINSTALLED = 1024;
    public static final int PROTECTION_FLAG_SETUP = 2048;
    public static final int PROTECTION_FLAG_INSTANT = 4096;
    public static final int PROTECTION_FLAG_RUNTIME_ONLY = 8192;
    @SystemApi
    public static final int PROTECTION_FLAG_OEM = 16384;
    @SystemApi
    public static final int PROTECTION_FLAG_VENDOR_PRIVILEGED = 32768;
    @SystemApi
    public static final int PROTECTION_FLAG_SYSTEM_TEXT_CLASSIFIER = 65536;
    @SystemApi
    public static final int PROTECTION_FLAG_WELLBEING = 131072;
    @SystemApi
    public static final int PROTECTION_FLAG_DOCUMENTER = 262144;
    @SystemApi
    public static final int PROTECTION_FLAG_CONFIGURATOR = 524288;
    @SystemApi
    public static final int PROTECTION_FLAG_INCIDENT_REPORT_APPROVER = 0x100000;
    @SystemApi
    public static final int PROTECTION_FLAG_APP_PREDICTOR = 0x200000;
    @SystemApi
    public static final int PROTECTION_FLAG_MODULE = 0x400000;
    @SystemApi
    public static final int PROTECTION_FLAG_COMPANION = 0x800000;
    @SystemApi
    public static final int PROTECTION_FLAG_RETAIL_DEMO = 0x1000000;
    @SystemApi
    public static final int PROTECTION_FLAG_RECENTS = 0x2000000;
    @SystemApi
    public static final int PROTECTION_FLAG_ROLE = 0x4000000;
    @SystemApi
    public static final int PROTECTION_FLAG_KNOWN_SIGNER = 0x8000000;
    @Deprecated
    public static final int PROTECTION_MASK_BASE = 15;
    @Deprecated
    public static final int PROTECTION_MASK_FLAGS = 65520;
    @Deprecated
    public int protectionLevel;
    @Nullable
    public String group;
    public static final int FLAG_COSTS_MONEY = 1;
    @SystemApi
    public static final int FLAG_REMOVED = 2;
    public static final int FLAG_HARD_RESTRICTED = 4;
    public static final int FLAG_SOFT_RESTRICTED = 8;
    public static final int FLAG_IMMUTABLY_RESTRICTED = 16;
    public static final int FLAG_INSTALLED = 0x40000000;
    public int flags;
    public int descriptionRes;
    @SystemApi
    public int requestRes;
    @SystemApi
    @Nullable
    public final String backgroundPermission;
    @Nullable
    public CharSequence nonLocalizedDescription;
    private static final Parcelling.BuiltIn.ForStringSet sForStringSet = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForStringSet.class);
    @SystemApi
    @SuppressLint(value={"MutableBareField"})
    @NonNull
    public Set<String> knownCerts = Collections.emptySet();
    public boolean requiresPurpose;
    @NonNull
    public Set<String> validPurposes = Collections.emptySet();
    @NonNull
    public static final Parcelable.Creator<PermissionInfo> CREATOR = new Parcelable.Creator<PermissionInfo>(){

        @Override
        public PermissionInfo createFromParcel(Parcel source) {
            return new PermissionInfo(source);
        }

        public PermissionInfo[] newArray(int size) {
            return new PermissionInfo[size];
        }
    };

    public static int fixProtectionLevel(int level) {
        if (level == 3) {
            level = 18;
        }
        if ((level & 0x8000) != 0 && (level & 0x10) == 0) {
            level &= 0xFFFF7FFF;
        }
        return level;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public static String protectionToString(int level) {
        StringBuilder protLevel = new StringBuilder();
        switch (level & 0xF) {
            case 1: {
                protLevel.append("dangerous");
                break;
            }
            case 0: {
                protLevel.append("normal");
                break;
            }
            case 2: {
                protLevel.append("signature");
                break;
            }
            case 3: {
                protLevel.append("signatureOrSystem");
                break;
            }
            case 4: {
                protLevel.append("internal");
                break;
            }
            default: {
                protLevel.append("????");
            }
        }
        if ((level & 0x10) != 0) {
            protLevel.append("|privileged");
        }
        if ((level & 0x20) != 0) {
            protLevel.append("|development");
        }
        if ((level & 0x40) != 0) {
            protLevel.append("|appop");
        }
        if ((level & 0x80) != 0) {
            protLevel.append("|pre23");
        }
        if ((level & 0x100) != 0) {
            protLevel.append("|installer");
        }
        if ((level & 0x200) != 0) {
            protLevel.append("|verifier");
        }
        if ((level & 0x400) != 0) {
            protLevel.append("|preinstalled");
        }
        if ((level & 0x800) != 0) {
            protLevel.append("|setup");
        }
        if ((level & 0x1000) != 0) {
            protLevel.append("|instant");
        }
        if ((level & 0x2000) != 0) {
            protLevel.append("|runtime");
        }
        if ((level & 0x4000) != 0) {
            protLevel.append("|oem");
        }
        if ((level & 0x8000) != 0) {
            protLevel.append("|vendorPrivileged");
        }
        if ((level & 0x10000) != 0) {
            protLevel.append("|textClassifier");
        }
        if ((level & 0x80000) != 0) {
            protLevel.append("|configurator");
        }
        if ((level & 0x100000) != 0) {
            protLevel.append("|incidentReportApprover");
        }
        if ((level & 0x200000) != 0) {
            protLevel.append("|appPredictor");
        }
        if ((level & 0x800000) != 0) {
            protLevel.append("|companion");
        }
        if ((level & 0x1000000) != 0) {
            protLevel.append("|retailDemo");
        }
        if ((level & 0x2000000) != 0) {
            protLevel.append("|recents");
        }
        if ((level & 0x4000000) != 0) {
            protLevel.append("|role");
        }
        if ((level & 0x8000000) != 0) {
            protLevel.append("|knownSigner");
        }
        if ((level & 0x400000) != 0) {
            protLevel.append("|module");
        }
        return protLevel.toString();
    }

    @NonNull
    public static String flagsToString(int flags) {
        StringBuilder sb = new StringBuilder("[");
        while (flags != 0) {
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            switch (flag) {
                case 1: {
                    sb.append("costsMoney");
                    break;
                }
                case 2: {
                    sb.append("removed");
                    break;
                }
                case 4: {
                    sb.append("hardRestricted");
                    break;
                }
                case 8: {
                    sb.append("softRestricted");
                    break;
                }
                case 16: {
                    sb.append("immutablyRestricted");
                    break;
                }
                case 0x40000000: {
                    sb.append("installed");
                    break;
                }
                default: {
                    sb.append(flag);
                }
            }
            if (flags == 0) continue;
            sb.append("|");
        }
        return sb.append("]").toString();
    }

    public PermissionInfo(@Nullable String backgroundPermission) {
        this.backgroundPermission = backgroundPermission;
    }

    @Deprecated
    public PermissionInfo() {
        this((String)null);
    }

    @Deprecated
    public PermissionInfo(@NonNull PermissionInfo orig) {
        super(orig);
        this.protectionLevel = orig.protectionLevel;
        this.flags = orig.flags;
        this.group = orig.group;
        this.backgroundPermission = orig.backgroundPermission;
        this.descriptionRes = orig.descriptionRes;
        this.requestRes = orig.requestRes;
        this.nonLocalizedDescription = orig.nonLocalizedDescription;
        this.knownCerts = orig.knownCerts;
        this.requiresPurpose = orig.requiresPurpose;
        this.validPurposes = orig.validPurposes;
    }

    @Nullable
    public CharSequence loadDescription(@NonNull PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedDescription != null) {
            return this.nonLocalizedDescription;
        }
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, null)) != null) {
            return label;
        }
        return null;
    }

    public int getProtection() {
        return this.protectionLevel & 0xF;
    }

    public int getProtectionFlags() {
        return this.protectionLevel & 0xFFFFFFF0;
    }

    public String toString() {
        return "PermissionInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeInt(this.protectionLevel);
        dest.writeInt(this.flags);
        dest.writeString8(this.group);
        dest.writeString8(this.backgroundPermission);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.requestRes);
        TextUtils.writeToParcel(this.nonLocalizedDescription, dest, parcelableFlags);
        sForStringSet.parcel(this.knownCerts, dest, parcelableFlags);
        dest.writeBoolean(this.requiresPurpose);
        sForStringSet.parcel(this.validPurposes, dest, parcelableFlags);
    }

    public int calculateFootprint() {
        int size = this.name.length();
        if (this.nonLocalizedLabel != null) {
            size += this.nonLocalizedLabel.length();
        }
        if (this.nonLocalizedDescription != null) {
            size += this.nonLocalizedDescription.length();
        }
        return size;
    }

    public boolean isHardRestricted() {
        return (this.flags & 4) != 0;
    }

    public boolean isSoftRestricted() {
        return (this.flags & 8) != 0;
    }

    public boolean isRestricted() {
        return this.isHardRestricted() || this.isSoftRestricted();
    }

    public boolean isAppOp() {
        return (this.protectionLevel & 0x40) != 0;
    }

    public boolean isRuntime() {
        return this.getProtection() == 1;
    }

    private PermissionInfo(Parcel source) {
        super(source);
        this.protectionLevel = source.readInt();
        this.flags = source.readInt();
        this.group = source.readString8();
        this.backgroundPermission = source.readString8();
        this.descriptionRes = source.readInt();
        this.requestRes = source.readInt();
        this.nonLocalizedDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
        this.knownCerts = sForStringSet.unparcel(source);
        this.requiresPurpose = source.readBoolean();
        this.validPurposes = sForStringSet.unparcel(source);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtectionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Protection {
    }
}

