/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Environment;
import android.os.FileUtils;
import android.os.SystemProperties;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;

public class PackagePartitions {
    public static final int PARTITION_SYSTEM = 0;
    public static final int PARTITION_VENDOR = 1;
    public static final int PARTITION_ODM = 2;
    public static final int PARTITION_OEM = 3;
    public static final int PARTITION_PRODUCT = 4;
    public static final int PARTITION_SYSTEM_EXT = 5;
    private static final ArrayList<SystemPartition> SYSTEM_PARTITIONS = new ArrayList<SystemPartition>(Arrays.asList(new SystemPartition(Environment.getRootDirectory(), 0, "system", true, false), new SystemPartition(Environment.getVendorDirectory(), 1, "vendor", true, true), new SystemPartition(Environment.getOdmDirectory(), 2, "odm", true, true), new SystemPartition(Environment.getOemDirectory(), 3, "oem", false, true), new SystemPartition(Environment.getProductDirectory(), 4, "product", true, true), new SystemPartition(Environment.getSystemExtDirectory(), 5, "system_ext", true, true)));
    public static final String FINGERPRINT = PackagePartitions.getFingerprint();

    public static <T> ArrayList<T> getOrderedPartitions(@NonNull Function<SystemPartition, T> producer) {
        ArrayList<T> out = new ArrayList<T>();
        int n = SYSTEM_PARTITIONS.size();
        for (int i = 0; i < n; ++i) {
            T v = producer.apply(SYSTEM_PARTITIONS.get(i));
            if (v == null) continue;
            out.add(v);
        }
        return out;
    }

    private static File canonicalize(File path) {
        try {
            return path.getCanonicalFile();
        }
        catch (IOException e) {
            return path;
        }
    }

    @NonNull
    private static String getFingerprint() {
        String[] digestProperties = new String[SYSTEM_PARTITIONS.size() + 1];
        for (int i = 0; i < SYSTEM_PARTITIONS.size(); ++i) {
            String partitionName = SYSTEM_PARTITIONS.get(i).getName();
            digestProperties[i] = "ro." + partitionName + ".build.fingerprint";
        }
        digestProperties[PackagePartitions.SYSTEM_PARTITIONS.size()] = "ro.build.fingerprint";
        return SystemProperties.digestOf(digestProperties);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static class SystemPartition {
        public final int type;
        @NonNull
        private final String mName;
        @NonNull
        private final DeferredCanonicalFile mFolder;
        @Nullable
        private final DeferredCanonicalFile mAppFolder;
        @Nullable
        private final DeferredCanonicalFile mPrivAppFolder;
        @Nullable
        private final DeferredCanonicalFile mOverlayFolder;
        @NonNull
        private final File mNonConicalFolder;

        private SystemPartition(@NonNull File folder, int type, String name, boolean containsPrivApp, boolean containsOverlay) {
            this.type = type;
            this.mName = name;
            this.mFolder = new DeferredCanonicalFile(folder);
            this.mAppFolder = new DeferredCanonicalFile(folder, "app");
            this.mPrivAppFolder = containsPrivApp ? new DeferredCanonicalFile(folder, "priv-app") : null;
            this.mOverlayFolder = containsOverlay ? new DeferredCanonicalFile(folder, "overlay") : null;
            this.mNonConicalFolder = folder;
        }

        public SystemPartition(@NonNull SystemPartition original) {
            this.type = original.type;
            this.mName = original.mName;
            this.mFolder = new DeferredCanonicalFile(original.mFolder.getFile());
            this.mAppFolder = original.mAppFolder;
            this.mPrivAppFolder = original.mPrivAppFolder;
            this.mOverlayFolder = original.mOverlayFolder;
            this.mNonConicalFolder = original.mNonConicalFolder;
        }

        public SystemPartition(@NonNull File rootFolder, @NonNull SystemPartition partition) {
            this(rootFolder, partition.type, partition.mName, partition.mPrivAppFolder != null, partition.mOverlayFolder != null);
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        @NonNull
        public File getFolder() {
            return this.mFolder.getFile();
        }

        @NonNull
        public File getNonConicalFolder() {
            return this.mNonConicalFolder;
        }

        @Nullable
        public File getAppFolder() {
            return this.mAppFolder == null ? null : this.mAppFolder.getFile();
        }

        @Nullable
        public File getPrivAppFolder() {
            return this.mPrivAppFolder == null ? null : this.mPrivAppFolder.getFile();
        }

        @Nullable
        public File getOverlayFolder() {
            return this.mOverlayFolder == null ? null : this.mOverlayFolder.getFile();
        }

        public boolean containsPath(@NonNull String path) {
            return this.containsFile(new File(path));
        }

        public boolean containsFile(@NonNull File file) {
            return FileUtils.contains(this.mFolder.getFile(), PackagePartitions.canonicalize(file));
        }

        public boolean containsPrivApp(@NonNull File scanFile) {
            return this.mPrivAppFolder != null && FileUtils.contains(this.mPrivAppFolder.getFile(), PackagePartitions.canonicalize(scanFile));
        }

        public boolean containsApp(@NonNull File scanFile) {
            return this.mAppFolder != null && FileUtils.contains(this.mAppFolder.getFile(), PackagePartitions.canonicalize(scanFile));
        }

        public boolean containsOverlay(@NonNull File scanFile) {
            return this.mOverlayFolder != null && FileUtils.contains(this.mOverlayFolder.getFile(), PackagePartitions.canonicalize(scanFile));
        }
    }

    private static class DeferredCanonicalFile {
        private boolean mIsCanonical = false;
        @NonNull
        private File mFile;

        private DeferredCanonicalFile(@NonNull File dir) {
            this.mFile = dir;
        }

        private DeferredCanonicalFile(@NonNull File dir, @NonNull String fileName) {
            this.mFile = new File(dir, fileName);
        }

        @NonNull
        private File getFile() {
            if (!this.mIsCanonical) {
                this.mFile = PackagePartitions.canonicalize(this.mFile);
                this.mIsCanonical = true;
            }
            return this.mFile;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PartitionType {
    }
}

