/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.DataLoaderParamsParcel;
import android.content.pm.FileSystemControlParcel;
import android.content.pm.IDataLoaderStatusListener;
import android.content.pm.InstallationFileParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDataLoader
extends IInterface {
    public static final String DESCRIPTOR = "android.content.pm.IDataLoader";

    public void create(int var1, DataLoaderParamsParcel var2, FileSystemControlParcel var3, IDataLoaderStatusListener var4) throws RemoteException;

    public void start(int var1) throws RemoteException;

    public void stop(int var1) throws RemoteException;

    public void destroy(int var1) throws RemoteException;

    public void prepareImage(int var1, InstallationFileParcel[] var2, String[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDataLoader {
        static final int TRANSACTION_create = 1;
        static final int TRANSACTION_start = 2;
        static final int TRANSACTION_stop = 3;
        static final int TRANSACTION_destroy = 4;
        static final int TRANSACTION_prepareImage = 5;

        public Stub() {
            this.attachInterface(this, IDataLoader.DESCRIPTOR);
        }

        public static IDataLoader asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDataLoader.DESCRIPTOR);
            if (iin != null && iin instanceof IDataLoader) {
                return (IDataLoader)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "create";
                }
                case 2: {
                    return "start";
                }
                case 3: {
                    return "stop";
                }
                case 4: {
                    return "destroy";
                }
                case 5: {
                    return "prepareImage";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDataLoader.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    DataLoaderParamsParcel _arg1 = data.readTypedObject(DataLoaderParamsParcel.CREATOR);
                    FileSystemControlParcel _arg2 = data.readTypedObject(FileSystemControlParcel.CREATOR);
                    IDataLoaderStatusListener _arg3 = IDataLoaderStatusListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.create(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.start(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stop(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroy(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    InstallationFileParcel[] _arg1 = data.createTypedArray(InstallationFileParcel.CREATOR);
                    String[] _arg2 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.prepareImage(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IDataLoader {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDataLoader.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void create(int id2, DataLoaderParamsParcel params, FileSystemControlParcel control, IDataLoaderStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataLoader.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeTypedObject(params, 0);
                    _data.writeTypedObject(control, 0);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataLoader.DESCRIPTOR);
                    _data.writeInt(id2);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop(int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataLoader.DESCRIPTOR);
                    _data.writeInt(id2);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroy(int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataLoader.DESCRIPTOR);
                    _data.writeInt(id2);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareImage(int id2, InstallationFileParcel[] addedFiles, String[] removedFiles) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataLoader.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeTypedArray(addedFiles, 0);
                    _data.writeStringArray(removedFiles);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDataLoader {
        @Override
        public void create(int id2, DataLoaderParamsParcel params, FileSystemControlParcel control, IDataLoaderStatusListener listener) throws RemoteException {
        }

        @Override
        public void start(int id2) throws RemoteException {
        }

        @Override
        public void stop(int id2) throws RemoteException {
        }

        @Override
        public void destroy(int id2) throws RemoteException {
        }

        @Override
        public void prepareImage(int id2, InstallationFileParcel[] addedFiles, String[] removedFiles) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

