/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class Capability
implements Parcelable {
    @NonNull
    private final String mName;
    @NonNull
    public static final Parcelable.Creator<Capability> CREATOR = new Parcelable.Creator<Capability>(){

        public Capability[] newArray(int size) {
            return new Capability[size];
        }

        @Override
        public Capability createFromParcel(@NonNull Parcel in) {
            return new Capability(in);
        }
    };

    Capability(@NonNull String name) {
        Objects.requireNonNull(name);
        if (name.contains("/")) {
            throw new IllegalArgumentException("'/' is not permitted in the capability name");
        }
        this.mName = name;
    }

    Capability(@NonNull Capability orig) {
        this(orig.mName);
    }

    private Capability(@NonNull Builder builder) {
        this(builder.mName);
    }

    private Capability(@NonNull Parcel in) {
        this.mName = in.readString();
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Capability)) {
            return false;
        }
        return this.mName.equals(((Capability)obj).mName);
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        @NonNull
        private final String mName;

        public Builder(@NonNull String name) {
            Objects.requireNonNull(name);
            if (name.contains("/")) {
                throw new IllegalArgumentException("'/' is not permitted in the capability name");
            }
            this.mName = name;
        }

        @NonNull
        public Capability build() {
            return new Capability(this);
        }
    }
}

