/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.om.CriticalOverlayInfo;
import android.content.om.OverlayConstraint;
import android.content.om.OverlayIdentifier;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class OverlayInfo
implements CriticalOverlayInfo,
Parcelable {
    public static final int STATE_UNKNOWN = -1;
    public static final int STATE_MISSING_TARGET = 0;
    public static final int STATE_NO_IDMAP = 1;
    public static final int STATE_DISABLED = 2;
    public static final int STATE_ENABLED = 3;
    @Deprecated
    public static final int STATE_TARGET_IS_BEING_REPLACED = 4;
    public static final int STATE_OVERLAY_IS_BEING_REPLACED = 5;
    @Deprecated
    public static final int STATE_ENABLED_IMMUTABLE = 6;
    public static final int STATE_SYSTEM_UPDATE_UNINSTALL = 7;
    public static final String CATEGORY_THEME = "android.theme";
    @NonNull
    public final String packageName;
    @Nullable
    public final String overlayName;
    @NonNull
    public final String targetPackageName;
    @Nullable
    public final String targetOverlayableName;
    @Nullable
    public final String category;
    @NonNull
    public final String baseCodePath;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final int state;
    public final int userId;
    public final int priority;
    public final boolean isMutable;
    private OverlayIdentifier mIdentifierCached;
    public final boolean isFabricated;
    @NonNull
    public final List<OverlayConstraint> constraints;
    @NonNull
    public static final Parcelable.Creator<OverlayInfo> CREATOR = new Parcelable.Creator<OverlayInfo>(){

        @Override
        public OverlayInfo createFromParcel(Parcel source) {
            return new OverlayInfo(source);
        }

        public OverlayInfo[] newArray(int size) {
            return new OverlayInfo[size];
        }
    };

    public OverlayInfo(@NonNull OverlayInfo source, int state) {
        this(source.packageName, source.overlayName, source.targetPackageName, source.targetOverlayableName, source.category, source.baseCodePath, state, source.userId, source.priority, source.isMutable, source.isFabricated, source.constraints);
    }

    @VisibleForTesting
    public OverlayInfo(@NonNull String packageName, @NonNull String targetPackageName, @Nullable String targetOverlayableName, @Nullable String category, @NonNull String baseCodePath, int state, int userId, int priority, boolean isMutable) {
        this(packageName, null, targetPackageName, targetOverlayableName, category, baseCodePath, state, userId, priority, isMutable, false);
    }

    public OverlayInfo(@NonNull String packageName, @Nullable String overlayName, @NonNull String targetPackageName, @Nullable String targetOverlayableName, @Nullable String category, @NonNull String baseCodePath, int state, int userId, int priority, boolean isMutable, boolean isFabricated) {
        this(packageName, overlayName, targetPackageName, targetOverlayableName, category, baseCodePath, state, userId, priority, isMutable, isFabricated, Collections.emptyList());
    }

    public OverlayInfo(@NonNull String packageName, @Nullable String overlayName, @NonNull String targetPackageName, @Nullable String targetOverlayableName, @Nullable String category, @NonNull String baseCodePath, int state, int userId, int priority, boolean isMutable, boolean isFabricated, @NonNull List<OverlayConstraint> constraints) {
        this.packageName = packageName;
        this.overlayName = overlayName;
        this.targetPackageName = targetPackageName;
        this.targetOverlayableName = targetOverlayableName;
        this.category = category;
        this.baseCodePath = baseCodePath;
        this.state = state;
        this.userId = userId;
        this.priority = priority;
        this.isMutable = isMutable;
        this.isFabricated = isFabricated;
        this.constraints = constraints;
        this.ensureValidState();
    }

    public OverlayInfo(@NonNull Parcel source) {
        this.packageName = source.readString();
        this.overlayName = source.readString();
        this.targetPackageName = source.readString();
        this.targetOverlayableName = source.readString();
        this.category = source.readString();
        this.baseCodePath = source.readString();
        this.state = source.readInt();
        this.userId = source.readInt();
        this.priority = source.readInt();
        this.isMutable = source.readBoolean();
        this.isFabricated = source.readBoolean();
        this.constraints = Arrays.asList(source.createTypedArray(OverlayConstraint.CREATOR));
        this.ensureValidState();
    }

    @Override
    @SystemApi
    @NonNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @Nullable
    public String getOverlayName() {
        return this.overlayName;
    }

    @Override
    @NonNull
    public String getTargetPackageName() {
        return this.targetPackageName;
    }

    @SystemApi
    @Nullable
    public String getCategory() {
        return this.category;
    }

    @SystemApi
    public int getUserId() {
        return this.userId;
    }

    @Override
    @Nullable
    public String getTargetOverlayableName() {
        return this.targetOverlayableName;
    }

    @Override
    public boolean isFabricated() {
        return this.isFabricated;
    }

    @NonNull
    public String getBaseCodePath() {
        return this.baseCodePath;
    }

    @Override
    @NonNull
    public OverlayIdentifier getOverlayIdentifier() {
        if (this.mIdentifierCached == null) {
            this.mIdentifierCached = new OverlayIdentifier(this.packageName, this.overlayName);
        }
        return this.mIdentifierCached;
    }

    @NonNull
    public List<OverlayConstraint> getConstraints() {
        return this.constraints;
    }

    private void ensureValidState() {
        if (this.packageName == null) {
            throw new IllegalArgumentException("packageName must not be null");
        }
        if (this.targetPackageName == null) {
            throw new IllegalArgumentException("targetPackageName must not be null");
        }
        if (this.baseCodePath == null) {
            throw new IllegalArgumentException("baseCodePath must not be null");
        }
        if (this.constraints == null) {
            throw new IllegalArgumentException("constraints must not be null");
        }
        switch (this.state) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("State " + this.state + " is not a valid state");
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.packageName);
        dest.writeString(this.overlayName);
        dest.writeString(this.targetPackageName);
        dest.writeString(this.targetOverlayableName);
        dest.writeString(this.category);
        dest.writeString(this.baseCodePath);
        dest.writeInt(this.state);
        dest.writeInt(this.userId);
        dest.writeInt(this.priority);
        dest.writeBoolean(this.isMutable);
        dest.writeBoolean(this.isFabricated);
        dest.writeTypedArray(this.constraints.toArray(new OverlayConstraint[0]), flags);
    }

    @SystemApi
    public boolean isEnabled() {
        switch (this.state) {
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static String stateToString(int state) {
        switch (state) {
            case -1: {
                return "STATE_UNKNOWN";
            }
            case 0: {
                return "STATE_MISSING_TARGET";
            }
            case 1: {
                return "STATE_NO_IDMAP";
            }
            case 2: {
                return "STATE_DISABLED";
            }
            case 3: {
                return "STATE_ENABLED";
            }
            case 6: {
                return "STATE_ENABLED_IMMUTABLE";
            }
            case 4: {
                return "STATE_TARGET_IS_BEING_REPLACED";
            }
            case 5: {
                return "STATE_OVERLAY_IS_BEING_REPLACED";
            }
        }
        return "<unknown state>";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.userId;
        result = 31 * result + this.state;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.overlayName == null ? 0 : this.overlayName.hashCode());
        result = 31 * result + (this.targetPackageName == null ? 0 : this.targetPackageName.hashCode());
        result = 31 * result + (this.targetOverlayableName == null ? 0 : this.targetOverlayableName.hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.baseCodePath == null ? 0 : this.baseCodePath.hashCode());
        result = 31 * result + (this.constraints.isEmpty() ? 0 : this.constraints.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OverlayInfo other = (OverlayInfo)obj;
        if (this.userId != other.userId) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (!this.packageName.equals(other.packageName)) {
            return false;
        }
        if (!Objects.equals(this.overlayName, other.overlayName)) {
            return false;
        }
        if (!this.targetPackageName.equals(other.targetPackageName)) {
            return false;
        }
        if (!Objects.equals(this.targetOverlayableName, other.targetOverlayableName)) {
            return false;
        }
        if (!Objects.equals(this.category, other.category)) {
            return false;
        }
        if (!this.baseCodePath.equals(other.baseCodePath)) {
            return false;
        }
        return Objects.equals(this.constraints, other.constraints);
    }

    @NonNull
    public String toString() {
        return "OverlayInfo {packageName=" + this.packageName + ", overlayName=" + this.overlayName + ", targetPackage=" + this.targetPackageName + ", targetOverlayable=" + this.targetOverlayableName + ", state=" + this.state + " (" + OverlayInfo.stateToString(this.state) + "),, userId=" + this.userId + ", constraints=" + OverlayConstraint.constraintsToString(this.constraints) + " }";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

