/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class OverlayIdentifier
implements Parcelable {
    @Nullable
    private final String mPackageName;
    @Nullable
    private final String mOverlayName;
    @NonNull
    public static final Parcelable.Creator<OverlayIdentifier> CREATOR = new Parcelable.Creator<OverlayIdentifier>(){

        public OverlayIdentifier[] newArray(int size) {
            return new OverlayIdentifier[size];
        }

        @Override
        public OverlayIdentifier createFromParcel(@NonNull Parcel in) {
            return new OverlayIdentifier(in);
        }
    };

    public OverlayIdentifier(@NonNull String packageName, @Nullable String overlayName) {
        this.mPackageName = packageName;
        this.mOverlayName = overlayName;
    }

    public OverlayIdentifier(@NonNull String packageName) {
        this.mPackageName = packageName;
        this.mOverlayName = null;
    }

    public String toString() {
        return this.mOverlayName == null ? this.mPackageName : this.mPackageName + ":" + this.mOverlayName;
    }

    @NonNull
    public static OverlayIdentifier fromString(@NonNull String text) {
        String[] parts = text.split(":", 2);
        if (parts.length == 2) {
            return new OverlayIdentifier(parts[0], parts[1]);
        }
        return new OverlayIdentifier(parts[0]);
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    @Nullable
    public String getOverlayName() {
        return this.mOverlayName;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverlayIdentifier that = (OverlayIdentifier)o;
        return Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mOverlayName, that.mOverlayName);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mOverlayName);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mPackageName != null) {
            flg = (byte)(flg | 1);
        }
        if (this.mOverlayName != null) {
            flg = (byte)(flg | 2);
        }
        dest.writeByte(flg);
        if (this.mPackageName != null) {
            dest.writeString(this.mPackageName);
        }
        if (this.mOverlayName != null) {
            dest.writeString(this.mOverlayName);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    OverlayIdentifier(@NonNull Parcel in) {
        byte flg = in.readByte();
        String packageName = (flg & 1) == 0 ? null : in.readString();
        String overlayName = (flg & 2) == 0 ? null : in.readString();
        this.mPackageName = packageName;
        this.mOverlayName = overlayName;
    }

    @Deprecated
    private void __metadata() {
    }
}

