/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;

public class OverlayConstraint
implements Parcelable {
    public static final int TYPE_DISPLAY_ID = 0;
    public static final int TYPE_DEVICE_ID = 1;
    private final int mType;
    private final int mValue;
    public static final Parcelable.Creator<OverlayConstraint> CREATOR = new Parcelable.Creator<OverlayConstraint>(){

        @Override
        public OverlayConstraint createFromParcel(Parcel in) {
            return new OverlayConstraint(in);
        }

        public OverlayConstraint[] newArray(int size) {
            return new OverlayConstraint[size];
        }
    };

    public OverlayConstraint(int type, int value) {
        if (type != 1 && type != 0) {
            throw new IllegalArgumentException("Type must be either TYPE_DISPLAY_ID or TYPE_DEVICE_ID");
        }
        if (value < 0) {
            throw new IllegalArgumentException("Value must be greater than 0");
        }
        this.mType = type;
        this.mValue = value;
    }

    private OverlayConstraint(Parcel in) {
        this(in.readInt(), in.readInt());
    }

    public int getType() {
        return this.mType;
    }

    public int getValue() {
        return this.mValue;
    }

    public String toString() {
        return "{type: " + OverlayConstraint.typeToString(this.mType) + ", value: " + this.mValue + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverlayConstraint)) {
            return false;
        }
        OverlayConstraint that = (OverlayConstraint)o;
        return this.mType == that.mType && this.mValue == that.mValue;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mValue);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mValue);
    }

    public static String constraintsToString(List<OverlayConstraint> overlayConstraints) {
        if (overlayConstraints == null || overlayConstraints.isEmpty()) {
            return "None";
        }
        return "[" + TextUtils.join((CharSequence)",", overlayConstraints) + "]";
    }

    private static String typeToString(int type) {
        return type == 1 ? "DEVICE_ID" : "DISPLAY_ID";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ConstraintType {
    }
}

