/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.content.AttributionSourceState;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.UserHandle;
import android.os._Original_Build;
import android.permission.PermissionManager;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.Immutable;
import com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@Immutable
public class AttributionSource
implements Parcelable {
    private static final String TAG = "AttributionSource";
    private static final String DESCRIPTOR = "android.content.AttributionSource";
    private static final Binder sDefaultToken = new Binder("android.content.AttributionSource");
    @NonNull
    private final AttributionSourceState mAttributionSourceState;
    @Nullable
    private AttributionSource mNextCached;
    @Nullable
    private Set<String> mRenouncedPermissionsCached;
    @NonNull
    public static final Parcelable.Creator<AttributionSource> CREATOR = new Parcelable.Creator<AttributionSource>(){

        public AttributionSource[] newArray(int size) {
            return new AttributionSource[size];
        }

        @Override
        public AttributionSource createFromParcel(@NonNull Parcel in) {
            return new AttributionSource(in);
        }
    };

    public AttributionSource(int uid, @Nullable String packageName, @Nullable String attributionTag) {
        this(uid, -1, packageName, attributionTag, sDefaultToken);
    }

    public AttributionSource(int uid, @Nullable String packageName, @Nullable String attributionTag, int virtualDeviceId) {
        this(uid, -1, packageName, attributionTag, sDefaultToken, null, virtualDeviceId, null);
    }

    public AttributionSource(int uid, int pid, @Nullable String packageName, @Nullable String attributionTag) {
        this(uid, pid, packageName, attributionTag, sDefaultToken);
    }

    public AttributionSource(int uid, @Nullable String packageName, @Nullable String attributionTag, @NonNull IBinder token) {
        this(uid, -1, packageName, attributionTag, token, null, 0, null);
    }

    public AttributionSource(int uid, int pid, @Nullable String packageName, @Nullable String attributionTag, @NonNull IBinder token) {
        this(uid, pid, packageName, attributionTag, token, null, 0, null);
    }

    public AttributionSource(int uid, @Nullable String packageName, @Nullable String attributionTag, @Nullable Set<String> renouncedPermissions, @Nullable AttributionSource next) {
        this(uid, -1, packageName, attributionTag, sDefaultToken, renouncedPermissions != null ? renouncedPermissions.toArray(new String[0]) : null, 0, next);
    }

    public AttributionSource(@NonNull AttributionSource current, @Nullable AttributionSource next) {
        this(current.getUid(), current.getPid(), current.getPackageName(), current.getAttributionTag(), current.getToken(), current.mAttributionSourceState.renouncedPermissions, current.getDeviceId(), next);
    }

    public AttributionSource(int uid, int pid, @Nullable String packageName, @Nullable String attributionTag, @Nullable String[] renouncedPermissions, int deviceId, @Nullable AttributionSource next) {
        this(uid, pid, packageName, attributionTag, sDefaultToken, renouncedPermissions, deviceId, next);
    }

    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public AttributionSource(int uid, int pid, @Nullable String packageName, @Nullable String attributionTag, @NonNull IBinder token, @Nullable String[] renouncedPermissions, int deviceId, @Nullable AttributionSource next) {
        AttributionSourceState[] attributionSourceStateArray;
        this.mAttributionSourceState = new AttributionSourceState();
        this.mAttributionSourceState.uid = uid;
        this.mAttributionSourceState.pid = pid;
        this.mAttributionSourceState.token = token;
        this.mAttributionSourceState.packageName = packageName;
        this.mAttributionSourceState.attributionTag = attributionTag;
        this.mAttributionSourceState.renouncedPermissions = renouncedPermissions;
        this.mAttributionSourceState.deviceId = deviceId;
        if (next != null) {
            AttributionSourceState[] attributionSourceStateArray2 = new AttributionSourceState[1];
            attributionSourceStateArray = attributionSourceStateArray2;
            attributionSourceStateArray2[0] = next.mAttributionSourceState;
        } else {
            attributionSourceStateArray = new AttributionSourceState[]{};
        }
        this.mAttributionSourceState.next = attributionSourceStateArray;
    }

    AttributionSource(@NonNull Parcel in) {
        this(AttributionSourceState.CREATOR.createFromParcel(in));
        if (!Binder.isDirectlyHandlingTransaction()) {
            throw new SecurityException("AttributionSource should be unparceled during a binder transaction for proper verification.");
        }
        this.enforceCallingUid();
        int callingPid = Binder.getCallingPid();
        if (callingPid == 0) {
            this.mAttributionSourceState.pid = -1;
        }
        this.enforceCallingPid();
    }

    public AttributionSource(@NonNull AttributionSourceState attributionSourceState) {
        this.mAttributionSourceState = attributionSourceState;
    }

    public AttributionSource withNextAttributionSource(@Nullable AttributionSource next) {
        return new AttributionSource(this.getUid(), this.getPid(), this.getPackageName(), this.getAttributionTag(), this.getToken(), this.mAttributionSourceState.renouncedPermissions, this.getDeviceId(), next);
    }

    public AttributionSource withPackageName(@Nullable String packageName) {
        return new AttributionSource(this.getUid(), this.getPid(), packageName, this.getAttributionTag(), this.getToken(), this.mAttributionSourceState.renouncedPermissions, this.getDeviceId(), this.getNext());
    }

    public AttributionSource withToken(@NonNull IBinder token) {
        return new AttributionSource(this.getUid(), this.getPid(), this.getPackageName(), this.getAttributionTag(), token, this.mAttributionSourceState.renouncedPermissions, this.getDeviceId(), this.getNext());
    }

    public AttributionSource withDefaultToken() {
        return this.withToken(sDefaultToken);
    }

    public AttributionSource withPid(int pid) {
        return new AttributionSource(this.getUid(), pid, this.getPackageName(), this.getAttributionTag(), this.getToken(), this.mAttributionSourceState.renouncedPermissions, this.getDeviceId(), this.getNext());
    }

    public AttributionSource withDeviceId(int deviceId) {
        return new AttributionSource(this.getUid(), this.getPid(), this.getPackageName(), this.getAttributionTag(), this.getToken(), this.mAttributionSourceState.renouncedPermissions, deviceId, this.getNext());
    }

    @NonNull
    public AttributionSourceState asState() {
        return this.mAttributionSourceState;
    }

    @NonNull
    public ScopedParcelState asScopedParcelState() {
        return new ScopedParcelState(this);
    }

    @NonNull
    public static AttributionSource myAttributionSource() {
        AttributionSource globalSource = ActivityThread.currentAttributionSource();
        if (globalSource != null) {
            if (Flags.enforceDefaultDeviceIdInMyAttributionSource() && globalSource.getDeviceId() != 0) {
                Log.w(TAG, "Avoid using myAttributionSource() to fetch an attributionSource with a non-default device Id");
                return globalSource.withDeviceId(0);
            }
            return globalSource;
        }
        int uid = Process.myUid();
        if (uid == 0) {
            uid = 1000;
        }
        try {
            return new Builder(uid).setPid(Process.myPid()).setDeviceId(0).setPackageName(AppGlobals.getPackageManager().getPackagesForUid(uid)[0]).build();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to resolve AttributionSource");
        }
    }

    public void enforceCallingUid() {
        if (!this.checkCallingUid()) {
            throw new SecurityException("Calling uid: " + Binder.getCallingUid() + " doesn't match source uid: " + this.mAttributionSourceState.uid);
        }
    }

    public boolean checkCallingUid() {
        int callingUid = Binder.getCallingUid();
        return callingUid == 0 || UserHandle.getAppId(callingUid) == 1000 || callingUid == this.mAttributionSourceState.uid;
    }

    public void enforceCallingPid() {
        if (!this.checkCallingPid()) {
            if (Binder.getCallingPid() == 0) {
                throw new SecurityException("Calling pid unavailable due to oneway Binder call.");
            }
            throw new SecurityException("Calling pid: " + Binder.getCallingPid() + " doesn't match source pid: " + this.mAttributionSourceState.pid);
        }
    }

    private boolean checkCallingPid() {
        int callingPid = Binder.getCallingPid();
        return this.mAttributionSourceState.pid == -1 || callingPid == this.mAttributionSourceState.pid;
    }

    public String toString() {
        if (_Original_Build.IS_DEBUGGABLE) {
            return "AttributionSource { uid = " + this.mAttributionSourceState.uid + ", packageName = " + this.mAttributionSourceState.packageName + ", attributionTag = " + this.mAttributionSourceState.attributionTag + ", token = " + this.mAttributionSourceState.token + ", deviceId = " + this.mAttributionSourceState.deviceId + ", next = " + (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0 ? new AttributionSource(this.mAttributionSourceState.next[0]).toString() : null) + " }";
        }
        return super.toString();
    }

    public int getNextUid() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].uid;
        }
        return -1;
    }

    @Nullable
    public String getNextPackageName() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].packageName;
        }
        return null;
    }

    @Nullable
    public String getNextAttributionTag() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].attributionTag;
        }
        return null;
    }

    @Nullable
    public IBinder getNextToken() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].token;
        }
        return null;
    }

    public int getNextDeviceId() {
        if (this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            return this.mAttributionSourceState.next[0].deviceId;
        }
        return 0;
    }

    public boolean isTrusted(@NonNull Context context) {
        return this.mAttributionSourceState.token != null && context.getSystemService(PermissionManager.class).isRegisteredAttributionSource(this);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RENOUNCE_PERMISSIONS")
    @NonNull
    public Set<String> getRenouncedPermissions() {
        if (this.mRenouncedPermissionsCached == null) {
            this.mRenouncedPermissionsCached = this.mAttributionSourceState.renouncedPermissions != null ? new ArraySet<String>(this.mAttributionSourceState.renouncedPermissions) : Collections.emptySet();
        }
        return this.mRenouncedPermissionsCached;
    }

    public int getUid() {
        return this.mAttributionSourceState.uid;
    }

    public int getPid() {
        return this.mAttributionSourceState.pid;
    }

    @Nullable
    public String getPackageName() {
        return this.mAttributionSourceState.packageName;
    }

    @Nullable
    public String getAttributionTag() {
        return this.mAttributionSourceState.attributionTag;
    }

    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public int getDeviceId() {
        return this.mAttributionSourceState.deviceId;
    }

    @NonNull
    public IBinder getToken() {
        return this.mAttributionSourceState.token;
    }

    @Nullable
    public AttributionSource getNext() {
        if (this.mNextCached == null && this.mAttributionSourceState.next != null && this.mAttributionSourceState.next.length > 0) {
            this.mNextCached = new AttributionSource(this.mAttributionSourceState.next[0]);
        }
        return this.mNextCached;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributionSource that = (AttributionSource)o;
        return this.equalsExceptToken(that) && Objects.equals(this.mAttributionSourceState.token, that.mAttributionSourceState.token);
    }

    public boolean equalsExceptToken(@Nullable AttributionSource o) {
        if (o == null) {
            return false;
        }
        return this.mAttributionSourceState.uid == o.mAttributionSourceState.uid && Objects.equals(this.mAttributionSourceState.packageName, o.mAttributionSourceState.packageName) && Objects.equals(this.mAttributionSourceState.attributionTag, o.mAttributionSourceState.attributionTag) && Arrays.equals(this.mAttributionSourceState.renouncedPermissions, o.mAttributionSourceState.renouncedPermissions) && Objects.equals(this.getNext(), o.getNext());
    }

    public int hashCode() {
        return Objects.hash(this.mAttributionSourceState.uid, this.mAttributionSourceState.packageName, this.mAttributionSourceState.attributionTag, this.mAttributionSourceState.token, Arrays.hashCode(this.mAttributionSourceState.renouncedPermissions), this.getNext());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mAttributionSourceState.writeToParcel(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class ScopedParcelState
    implements AutoCloseable {
        private final Parcel mParcel = Parcel.obtain();

        @NonNull
        public Parcel getParcel() {
            return this.mParcel;
        }

        public ScopedParcelState(AttributionSource attributionSource) {
            attributionSource.writeToParcel(this.mParcel, 0);
            this.mParcel.setDataPosition(0);
        }

        @Override
        public void close() {
            this.mParcel.recycle();
        }
    }

    public static class Builder {
        private boolean mHasBeenUsed;
        @NonNull
        private final AttributionSourceState mAttributionSourceState = new AttributionSourceState();

        public Builder(int uid) {
            this.mAttributionSourceState.uid = uid;
            this.mAttributionSourceState.pid = -1;
            this.mAttributionSourceState.deviceId = 0;
            this.mAttributionSourceState.token = sDefaultToken;
        }

        public Builder(@NonNull AttributionSource current) {
            if (current == null) {
                throw new IllegalArgumentException("current AttributionSource can not be null");
            }
            this.mAttributionSourceState.uid = current.getUid();
            this.mAttributionSourceState.pid = current.getPid();
            this.mAttributionSourceState.packageName = current.getPackageName();
            this.mAttributionSourceState.attributionTag = current.getAttributionTag();
            this.mAttributionSourceState.renouncedPermissions = current.mAttributionSourceState.renouncedPermissions;
            this.mAttributionSourceState.deviceId = current.getDeviceId();
            this.mAttributionSourceState.next = current.mAttributionSourceState.next;
            this.mAttributionSourceState.token = current.getToken();
        }

        @NonNull
        public Builder setPid(int value) {
            this.checkNotUsed();
            this.mAttributionSourceState.pid = value;
            return this;
        }

        @NonNull
        public Builder setPackageName(@Nullable String value) {
            this.checkNotUsed();
            this.mAttributionSourceState.packageName = value;
            return this;
        }

        @NonNull
        public Builder setAttributionTag(@Nullable String value) {
            this.checkNotUsed();
            this.mAttributionSourceState.attributionTag = value;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.RENOUNCE_PERMISSIONS")
        @NonNull
        public Builder setRenouncedPermissions(@Nullable Set<String> renouncedPermissions) {
            this.checkNotUsed();
            this.mAttributionSourceState.renouncedPermissions = renouncedPermissions != null ? renouncedPermissions.toArray(new String[0]) : null;
            return this;
        }

        @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
        @NonNull
        public Builder setDeviceId(int deviceId) {
            this.checkNotUsed();
            this.mAttributionSourceState.deviceId = deviceId;
            return this;
        }

        @NonNull
        public Builder setNext(@Nullable AttributionSource value) {
            AttributionSourceState[] attributionSourceStateArray;
            this.checkNotUsed();
            if (value != null) {
                AttributionSourceState[] attributionSourceStateArray2 = new AttributionSourceState[1];
                attributionSourceStateArray = attributionSourceStateArray2;
                attributionSourceStateArray2[0] = value.mAttributionSourceState;
            } else {
                attributionSourceStateArray = this.mAttributionSourceState.next;
            }
            this.mAttributionSourceState.next = attributionSourceStateArray;
            return this;
        }

        @FlaggedApi(value="android.permission.flags.set_next_attribution_source")
        @NonNull
        public Builder setNextAttributionSource(@NonNull AttributionSource value) {
            this.checkNotUsed();
            if (value == null) {
                throw new IllegalArgumentException("Null AttributionSource not permitted.");
            }
            this.mAttributionSourceState.next = new AttributionSourceState[]{value.mAttributionSourceState};
            return this;
        }

        @NonNull
        public AttributionSource build() {
            this.checkNotUsed();
            this.mHasBeenUsed = true;
            if (this.mAttributionSourceState.next == null) {
                this.mAttributionSourceState.next = new AttributionSourceState[0];
            }
            return new AttributionSource(this.mAttributionSourceState);
        }

        private void checkNotUsed() {
            if (this.mHasBeenUsed) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

