/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Environment;
import android.os.UserHandle;
import java.io.File;
import java.util.Objects;

@SystemApi
public class ApexEnvironment {
    private static final String APEX_DATA = "apexdata";
    private final String mApexModuleName;

    @NonNull
    public static ApexEnvironment getApexEnvironment(@NonNull String apexModuleName) {
        Objects.requireNonNull(apexModuleName, "apexModuleName cannot be null");
        return new ApexEnvironment(apexModuleName);
    }

    private ApexEnvironment(String apexModuleName) {
        this.mApexModuleName = apexModuleName;
    }

    @NonNull
    public File getDeviceProtectedDataDir() {
        return Environment.buildPath(Environment.getDataMiscDirectory(), APEX_DATA, this.mApexModuleName);
    }

    @NonNull
    public File getDeviceProtectedDataDirForUser(@NonNull UserHandle user) {
        return Environment.buildPath(Environment.getDataMiscDeDirectory(user.getIdentifier()), APEX_DATA, this.mApexModuleName);
    }

    @NonNull
    public File getCredentialProtectedDataDirForUser(@NonNull UserHandle user) {
        return Environment.buildPath(Environment.getDataMiscCeDirectory(user.getIdentifier()), APEX_DATA, this.mApexModuleName);
    }
}

