/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.app.PendingIntent;
import android.companion.virtual.ActivityPolicyExemption;
import android.companion.virtual.IVirtualDeviceActivityListener;
import android.companion.virtual.IVirtualDeviceIntentInterceptor;
import android.companion.virtual.IVirtualDeviceSoundEffectListener;
import android.companion.virtual.audio.IAudioConfigChangedCallback;
import android.companion.virtual.audio.IAudioRoutingCallback;
import android.companion.virtual.camera.VirtualCameraConfig;
import android.companion.virtual.sensor.VirtualSensor;
import android.companion.virtual.sensor.VirtualSensorAdditionalInfo;
import android.companion.virtual.sensor.VirtualSensorEvent;
import android.content.IntentFilter;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.input.IVirtualInputDevice;
import android.hardware.input.VirtualDpadConfig;
import android.hardware.input.VirtualKeyboardConfig;
import android.hardware.input.VirtualMouseConfig;
import android.hardware.input.VirtualNavigationTouchpadConfig;
import android.hardware.input.VirtualRotaryEncoderConfig;
import android.hardware.input.VirtualStylusConfig;
import android.hardware.input.VirtualTouchscreenConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import java.util.ArrayList;
import java.util.List;

public interface IVirtualDevice
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.IVirtualDevice";

    public int getAssociationId() throws RemoteException;

    public int getDeviceId() throws RemoteException;

    public String getPersistentDeviceId() throws RemoteException;

    public int[] getDisplayIds() throws RemoteException;

    public int getDevicePolicy(int var1) throws RemoteException;

    public boolean hasCustomAudioInputSupport() throws RemoteException;

    public boolean canCreateMirrorDisplays() throws RemoteException;

    public void goToSleep() throws RemoteException;

    public void wakeUp() throws RemoteException;

    public void close() throws RemoteException;

    public void setDevicePolicy(int var1, int var2) throws RemoteException;

    public void addActivityPolicyExemption(ActivityPolicyExemption var1) throws RemoteException;

    public void removeActivityPolicyExemption(ActivityPolicyExemption var1) throws RemoteException;

    public void setDevicePolicyForDisplay(int var1, int var2, int var3) throws RemoteException;

    public void onAudioSessionStarting(int var1, IAudioRoutingCallback var2, IAudioConfigChangedCallback var3) throws RemoteException;

    public void onAudioSessionEnded() throws RemoteException;

    public int createVirtualDisplay(VirtualDisplayConfig var1, IVirtualDisplayCallback var2) throws RemoteException;

    public IVirtualInputDevice createVirtualDpad(VirtualDpadConfig var1, IBinder var2) throws RemoteException;

    public IVirtualInputDevice createVirtualKeyboard(VirtualKeyboardConfig var1, IBinder var2) throws RemoteException;

    public IVirtualInputDevice createVirtualMouse(VirtualMouseConfig var1, IBinder var2) throws RemoteException;

    public IVirtualInputDevice createVirtualTouchscreen(VirtualTouchscreenConfig var1, IBinder var2) throws RemoteException;

    public IVirtualInputDevice createVirtualNavigationTouchpad(VirtualNavigationTouchpadConfig var1, IBinder var2) throws RemoteException;

    public IVirtualInputDevice createVirtualStylus(VirtualStylusConfig var1, IBinder var2) throws RemoteException;

    public IVirtualInputDevice createVirtualRotaryEncoder(VirtualRotaryEncoderConfig var1, IBinder var2) throws RemoteException;

    public List<VirtualSensor> getVirtualSensorList() throws RemoteException;

    public boolean sendSensorEvent(IBinder var1, VirtualSensorEvent var2) throws RemoteException;

    public boolean sendSensorAdditionalInfo(IBinder var1, VirtualSensorAdditionalInfo var2) throws RemoteException;

    public void launchPendingIntent(int var1, PendingIntent var2, ResultReceiver var3) throws RemoteException;

    public void setShowPointerIcon(boolean var1) throws RemoteException;

    public void setDisplayImePolicy(int var1, int var2) throws RemoteException;

    public void registerIntentInterceptor(IVirtualDeviceIntentInterceptor var1, IntentFilter var2) throws RemoteException;

    public void unregisterIntentInterceptor(IVirtualDeviceIntentInterceptor var1) throws RemoteException;

    public void registerVirtualCamera(VirtualCameraConfig var1) throws RemoteException;

    public void unregisterVirtualCamera(VirtualCameraConfig var1) throws RemoteException;

    public String getVirtualCameraId(VirtualCameraConfig var1) throws RemoteException;

    public void setListeners(IVirtualDeviceActivityListener var1, IVirtualDeviceSoundEffectListener var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualDevice {
        static final int TRANSACTION_getAssociationId = 1;
        static final int TRANSACTION_getDeviceId = 2;
        static final int TRANSACTION_getPersistentDeviceId = 3;
        static final int TRANSACTION_getDisplayIds = 4;
        static final int TRANSACTION_getDevicePolicy = 5;
        static final int TRANSACTION_hasCustomAudioInputSupport = 6;
        static final int TRANSACTION_canCreateMirrorDisplays = 7;
        static final int TRANSACTION_goToSleep = 8;
        static final int TRANSACTION_wakeUp = 9;
        static final int TRANSACTION_close = 10;
        static final int TRANSACTION_setDevicePolicy = 11;
        static final int TRANSACTION_addActivityPolicyExemption = 12;
        static final int TRANSACTION_removeActivityPolicyExemption = 13;
        static final int TRANSACTION_setDevicePolicyForDisplay = 14;
        static final int TRANSACTION_onAudioSessionStarting = 15;
        static final int TRANSACTION_onAudioSessionEnded = 16;
        static final int TRANSACTION_createVirtualDisplay = 17;
        static final int TRANSACTION_createVirtualDpad = 18;
        static final int TRANSACTION_createVirtualKeyboard = 19;
        static final int TRANSACTION_createVirtualMouse = 20;
        static final int TRANSACTION_createVirtualTouchscreen = 21;
        static final int TRANSACTION_createVirtualNavigationTouchpad = 22;
        static final int TRANSACTION_createVirtualStylus = 23;
        static final int TRANSACTION_createVirtualRotaryEncoder = 24;
        static final int TRANSACTION_getVirtualSensorList = 25;
        static final int TRANSACTION_sendSensorEvent = 26;
        static final int TRANSACTION_sendSensorAdditionalInfo = 27;
        static final int TRANSACTION_launchPendingIntent = 28;
        static final int TRANSACTION_setShowPointerIcon = 29;
        static final int TRANSACTION_setDisplayImePolicy = 30;
        static final int TRANSACTION_registerIntentInterceptor = 31;
        static final int TRANSACTION_unregisterIntentInterceptor = 32;
        static final int TRANSACTION_registerVirtualCamera = 33;
        static final int TRANSACTION_unregisterVirtualCamera = 34;
        static final int TRANSACTION_getVirtualCameraId = 35;
        static final int TRANSACTION_setListeners = 36;

        public Stub() {
            this.attachInterface(this, IVirtualDevice.DESCRIPTOR);
        }

        public static IVirtualDevice asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualDevice.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualDevice) {
                return (IVirtualDevice)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAssociationId";
                }
                case 2: {
                    return "getDeviceId";
                }
                case 3: {
                    return "getPersistentDeviceId";
                }
                case 4: {
                    return "getDisplayIds";
                }
                case 5: {
                    return "getDevicePolicy";
                }
                case 6: {
                    return "hasCustomAudioInputSupport";
                }
                case 7: {
                    return "canCreateMirrorDisplays";
                }
                case 8: {
                    return "goToSleep";
                }
                case 9: {
                    return "wakeUp";
                }
                case 10: {
                    return "close";
                }
                case 11: {
                    return "setDevicePolicy";
                }
                case 12: {
                    return "addActivityPolicyExemption";
                }
                case 13: {
                    return "removeActivityPolicyExemption";
                }
                case 14: {
                    return "setDevicePolicyForDisplay";
                }
                case 15: {
                    return "onAudioSessionStarting";
                }
                case 16: {
                    return "onAudioSessionEnded";
                }
                case 17: {
                    return "createVirtualDisplay";
                }
                case 18: {
                    return "createVirtualDpad";
                }
                case 19: {
                    return "createVirtualKeyboard";
                }
                case 20: {
                    return "createVirtualMouse";
                }
                case 21: {
                    return "createVirtualTouchscreen";
                }
                case 22: {
                    return "createVirtualNavigationTouchpad";
                }
                case 23: {
                    return "createVirtualStylus";
                }
                case 24: {
                    return "createVirtualRotaryEncoder";
                }
                case 25: {
                    return "getVirtualSensorList";
                }
                case 26: {
                    return "sendSensorEvent";
                }
                case 27: {
                    return "sendSensorAdditionalInfo";
                }
                case 28: {
                    return "launchPendingIntent";
                }
                case 29: {
                    return "setShowPointerIcon";
                }
                case 30: {
                    return "setDisplayImePolicy";
                }
                case 31: {
                    return "registerIntentInterceptor";
                }
                case 32: {
                    return "unregisterIntentInterceptor";
                }
                case 33: {
                    return "registerVirtualCamera";
                }
                case 34: {
                    return "unregisterVirtualCamera";
                }
                case 35: {
                    return "getVirtualCameraId";
                }
                case 36: {
                    return "setListeners";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualDevice.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _result = this.getAssociationId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    int _result = this.getDeviceId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    String _result = this.getPersistentDeviceId();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 4: {
                    int[] _result = this.getDisplayIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDevicePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    boolean _result = this.hasCustomAudioInputSupport();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    boolean _result = this.canCreateMirrorDisplays();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    this.goToSleep();
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    this.wakeUp();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDevicePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    ActivityPolicyExemption _arg0 = data.readTypedObject(ActivityPolicyExemption.CREATOR);
                    data.enforceNoDataAvail();
                    this.addActivityPolicyExemption(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    ActivityPolicyExemption _arg0 = data.readTypedObject(ActivityPolicyExemption.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeActivityPolicyExemption(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDevicePolicyForDisplay(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    IAudioRoutingCallback _arg1 = IAudioRoutingCallback.Stub.asInterface(data.readStrongBinder());
                    IAudioConfigChangedCallback _arg2 = IAudioConfigChangedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onAudioSessionStarting(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    this.onAudioSessionEnded();
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    VirtualDisplayConfig _arg0 = data.readTypedObject(VirtualDisplayConfig.CREATOR);
                    IVirtualDisplayCallback _arg1 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.createVirtualDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 18: {
                    VirtualDpadConfig _arg0 = data.readTypedObject(VirtualDpadConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IVirtualInputDevice _result = this.createVirtualDpad(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 19: {
                    VirtualKeyboardConfig _arg0 = data.readTypedObject(VirtualKeyboardConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IVirtualInputDevice _result = this.createVirtualKeyboard(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 20: {
                    VirtualMouseConfig _arg0 = data.readTypedObject(VirtualMouseConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IVirtualInputDevice _result = this.createVirtualMouse(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 21: {
                    VirtualTouchscreenConfig _arg0 = data.readTypedObject(VirtualTouchscreenConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IVirtualInputDevice _result = this.createVirtualTouchscreen(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 22: {
                    VirtualNavigationTouchpadConfig _arg0 = data.readTypedObject(VirtualNavigationTouchpadConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IVirtualInputDevice _result = this.createVirtualNavigationTouchpad(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 23: {
                    VirtualStylusConfig _arg0 = data.readTypedObject(VirtualStylusConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IVirtualInputDevice _result = this.createVirtualStylus(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 24: {
                    VirtualRotaryEncoderConfig _arg0 = data.readTypedObject(VirtualRotaryEncoderConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IVirtualInputDevice _result = this.createVirtualRotaryEncoder(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 25: {
                    List<VirtualSensor> _result = this.getVirtualSensorList();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 26: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualSensorEvent _arg1 = data.readTypedObject(VirtualSensorEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendSensorEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualSensorAdditionalInfo _arg1 = data.readTypedObject(VirtualSensorAdditionalInfo.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendSensorAdditionalInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.launchPendingIntent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShowPointerIcon(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDisplayImePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IVirtualDeviceIntentInterceptor _arg0 = IVirtualDeviceIntentInterceptor.Stub.asInterface(data.readStrongBinder());
                    IntentFilter _arg1 = data.readTypedObject(IntentFilter.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerIntentInterceptor(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    IVirtualDeviceIntentInterceptor _arg0 = IVirtualDeviceIntentInterceptor.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterIntentInterceptor(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    VirtualCameraConfig _arg0 = data.readTypedObject(VirtualCameraConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerVirtualCamera(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    VirtualCameraConfig _arg0 = data.readTypedObject(VirtualCameraConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterVirtualCamera(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    VirtualCameraConfig _arg0 = data.readTypedObject(VirtualCameraConfig.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getVirtualCameraId(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 36: {
                    IVirtualDeviceActivityListener _arg0 = IVirtualDeviceActivityListener.Stub.asInterface(data.readStrongBinder());
                    IVirtualDeviceSoundEffectListener _arg1 = IVirtualDeviceSoundEffectListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setListeners(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 35;
        }

        private static class Proxy
        implements IVirtualDevice {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualDevice.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAssociationId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPersistentDeviceId() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getDisplayIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDevicePolicy(int policyType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(policyType);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasCustomAudioInputSupport() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canCreateMirrorDisplays() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void goToSleep() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wakeUp() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDevicePolicy(int policyType, int devicePolicy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(policyType);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addActivityPolicyExemption(ActivityPolicyExemption exemption) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(exemption, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeActivityPolicyExemption(ActivityPolicyExemption exemption) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(exemption, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDevicePolicyForDisplay(int displayId, int policyType, int devicePolicy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(policyType);
                    _data.writeInt(devicePolicy);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioSessionStarting(int displayId, IAudioRoutingCallback routingCallback, IAudioConfigChangedCallback configChangedCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(routingCallback);
                    _data.writeStrongInterface(configChangedCallback);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioSessionEnded() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(virtualDisplayConfig, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualInputDevice createVirtualDpad(VirtualDpadConfig config, IBinder token) throws RemoteException {
                IVirtualInputDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualInputDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualInputDevice createVirtualKeyboard(VirtualKeyboardConfig config, IBinder token) throws RemoteException {
                IVirtualInputDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualInputDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualInputDevice createVirtualMouse(VirtualMouseConfig config, IBinder token) throws RemoteException {
                IVirtualInputDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualInputDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualInputDevice createVirtualTouchscreen(VirtualTouchscreenConfig config, IBinder token) throws RemoteException {
                IVirtualInputDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualInputDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualInputDevice createVirtualNavigationTouchpad(VirtualNavigationTouchpadConfig config, IBinder token) throws RemoteException {
                IVirtualInputDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualInputDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualInputDevice createVirtualStylus(VirtualStylusConfig config, IBinder token) throws RemoteException {
                IVirtualInputDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualInputDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualInputDevice createVirtualRotaryEncoder(VirtualRotaryEncoderConfig config, IBinder token) throws RemoteException {
                IVirtualInputDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualInputDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<VirtualSensor> getVirtualSensorList() throws RemoteException {
                ArrayList<VirtualSensor> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(VirtualSensor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendSensorEvent(IBinder token, VirtualSensorEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendSensorAdditionalInfo(IBinder token, VirtualSensorAdditionalInfo info) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void launchPendingIntent(int displayId, PendingIntent pendingIntent, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShowPointerIcon(boolean showPointerIcon) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeBoolean(showPointerIcon);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayImePolicy(int displayId, int policy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(policy);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerIntentInterceptor(IVirtualDeviceIntentInterceptor intentInterceptor, IntentFilter filter) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongInterface(intentInterceptor);
                    _data.writeTypedObject(filter, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterIntentInterceptor(IVirtualDeviceIntentInterceptor intentInterceptor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongInterface(intentInterceptor);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerVirtualCamera(VirtualCameraConfig camera) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(camera, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterVirtualCamera(VirtualCameraConfig camera) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(camera, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getVirtualCameraId(VirtualCameraConfig camera) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(camera, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setListeners(IVirtualDeviceActivityListener activityListener, IVirtualDeviceSoundEffectListener soundEffectListener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongInterface(activityListener);
                    _data.writeStrongInterface(soundEffectListener);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualDevice {
        @Override
        public int getAssociationId() throws RemoteException {
            return 0;
        }

        @Override
        public int getDeviceId() throws RemoteException {
            return 0;
        }

        @Override
        public String getPersistentDeviceId() throws RemoteException {
            return null;
        }

        @Override
        public int[] getDisplayIds() throws RemoteException {
            return null;
        }

        @Override
        public int getDevicePolicy(int policyType) throws RemoteException {
            return 0;
        }

        @Override
        public boolean hasCustomAudioInputSupport() throws RemoteException {
            return false;
        }

        @Override
        public boolean canCreateMirrorDisplays() throws RemoteException {
            return false;
        }

        @Override
        public void goToSleep() throws RemoteException {
        }

        @Override
        public void wakeUp() throws RemoteException {
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void setDevicePolicy(int policyType, int devicePolicy) throws RemoteException {
        }

        @Override
        public void addActivityPolicyExemption(ActivityPolicyExemption exemption) throws RemoteException {
        }

        @Override
        public void removeActivityPolicyExemption(ActivityPolicyExemption exemption) throws RemoteException {
        }

        @Override
        public void setDevicePolicyForDisplay(int displayId, int policyType, int devicePolicy) throws RemoteException {
        }

        @Override
        public void onAudioSessionStarting(int displayId, IAudioRoutingCallback routingCallback, IAudioConfigChangedCallback configChangedCallback) throws RemoteException {
        }

        @Override
        public void onAudioSessionEnded() throws RemoteException {
        }

        @Override
        public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback) throws RemoteException {
            return 0;
        }

        @Override
        public IVirtualInputDevice createVirtualDpad(VirtualDpadConfig config, IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public IVirtualInputDevice createVirtualKeyboard(VirtualKeyboardConfig config, IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public IVirtualInputDevice createVirtualMouse(VirtualMouseConfig config, IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public IVirtualInputDevice createVirtualTouchscreen(VirtualTouchscreenConfig config, IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public IVirtualInputDevice createVirtualNavigationTouchpad(VirtualNavigationTouchpadConfig config, IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public IVirtualInputDevice createVirtualStylus(VirtualStylusConfig config, IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public IVirtualInputDevice createVirtualRotaryEncoder(VirtualRotaryEncoderConfig config, IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public List<VirtualSensor> getVirtualSensorList() throws RemoteException {
            return null;
        }

        @Override
        public boolean sendSensorEvent(IBinder token, VirtualSensorEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendSensorAdditionalInfo(IBinder token, VirtualSensorAdditionalInfo info) throws RemoteException {
            return false;
        }

        @Override
        public void launchPendingIntent(int displayId, PendingIntent pendingIntent, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void setShowPointerIcon(boolean showPointerIcon) throws RemoteException {
        }

        @Override
        public void setDisplayImePolicy(int displayId, int policy) throws RemoteException {
        }

        @Override
        public void registerIntentInterceptor(IVirtualDeviceIntentInterceptor intentInterceptor, IntentFilter filter) throws RemoteException {
        }

        @Override
        public void unregisterIntentInterceptor(IVirtualDeviceIntentInterceptor intentInterceptor) throws RemoteException {
        }

        @Override
        public void registerVirtualCamera(VirtualCameraConfig camera) throws RemoteException {
        }

        @Override
        public void unregisterVirtualCamera(VirtualCameraConfig camera) throws RemoteException {
        }

        @Override
        public String getVirtualCameraId(VirtualCameraConfig camera) throws RemoteException {
            return null;
        }

        @Override
        public void setListeners(IVirtualDeviceActivityListener activityListener, IVirtualDeviceSoundEffectListener soundEffectListener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

