/*
 * Decompiled with CFR 0.152.
 */
package android.companion.datatransfer.continuity;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.companion.datatransfer.continuity.IHandoffRequestCallback;
import android.companion.datatransfer.continuity.IRemoteTaskListener;
import android.companion.datatransfer.continuity.ITaskContinuityManager;
import android.companion.datatransfer.continuity.RemoteTask;
import android.content.Context;
import android.os.RemoteException;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
@FlaggedApi(value="android.companion.enable_task_continuity")
public class TaskContinuityManager {
    private final Context mContext;
    private final ITaskContinuityManager mService;
    private final RemoteTaskListenerHolder mListenerHolder;
    public static final int HANDOFF_REQUEST_RESULT_SUCCESS = 0;
    public static final int HANDOFF_REQUEST_RESULT_FAILURE_TASK_NOT_FOUND = 1;
    public static final int HANDOFF_REQUEST_RESULT_FAILURE_NO_DATA_PROVIDED_BY_TASK = 2;
    public static final int HANDOFF_REQUEST_RESULT_FAILURE_SENDER_LOST_CONNECTION = 3;
    public static final int HANDOFF_REQUEST_RESULT_FAILURE_TIMEOUT = 4;
    public static final int HANDOFF_REQUEST_RESULT_FAILURE_DEVICE_NOT_FOUND = 5;

    public TaskContinuityManager(@NonNull Context context, @NonNull ITaskContinuityManager service) {
        this.mContext = context;
        this.mService = service;
        this.mListenerHolder = new RemoteTaskListenerHolder(service);
    }

    @NonNull
    public List<RemoteTask> getRemoteTasks() {
        try {
            return this.mService.getRemoteTasks();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerRemoteTaskListener(@NonNull Executor executor, @NonNull RemoteTaskListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        try {
            this.mListenerHolder.registerListener(executor, listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterRemoteTaskListener(@NonNull RemoteTaskListener listener) {
        Objects.requireNonNull(listener);
        try {
            this.mListenerHolder.unregisterListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestHandoff(int associationId, int remoteTaskId, @NonNull Executor executor, @NonNull HandoffRequestCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            HandoffRequestCallbackHolder callbackHolder = new HandoffRequestCallbackHolder(this, executor, callback);
            this.mService.requestHandoff(associationId, remoteTaskId, callbackHolder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class RemoteTaskListenerHolder
    extends IRemoteTaskListener.Stub {
        @GuardedBy(value={"mListeners"})
        private final Map<RemoteTaskListener, Executor> mListeners = new ArrayMap<RemoteTaskListener, Executor>();
        @GuardedBy(value={"mListeners"})
        private boolean mRegistered = false;

        public RemoteTaskListenerHolder(ITaskContinuityManager service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerListener(@NonNull Executor executor, @NonNull RemoteTaskListener listener) throws RemoteException {
            Objects.requireNonNull(executor);
            Objects.requireNonNull(listener);
            Map<RemoteTaskListener, Executor> map = this.mListeners;
            synchronized (map) {
                if (!this.mRegistered) {
                    TaskContinuityManager.this.mService.registerRemoteTaskListener(this);
                    this.mRegistered = true;
                }
                this.mListeners.put(listener, executor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterListener(@NonNull RemoteTaskListener listener) throws RemoteException {
            Objects.requireNonNull(listener);
            Map<RemoteTaskListener, Executor> map = this.mListeners;
            synchronized (map) {
                this.mListeners.remove(listener);
                if (this.mListeners.isEmpty() && this.mRegistered) {
                    this.mRegistered = false;
                    TaskContinuityManager.this.mService.unregisterRemoteTaskListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteTasksChanged(List<RemoteTask> remoteTasks) throws RemoteException {
            Map<RemoteTaskListener, Executor> map = this.mListeners;
            synchronized (map) {
                for (Map.Entry<RemoteTaskListener, Executor> entry : this.mListeners.entrySet()) {
                    RemoteTaskListener listener = entry.getKey();
                    Executor executor = entry.getValue();
                    executor.execute(() -> listener.onRemoteTasksChanged(remoteTasks));
                }
            }
        }
    }

    public static interface RemoteTaskListener {
        public void onRemoteTasksChanged(@NonNull List<RemoteTask> var1);
    }

    private class HandoffRequestCallbackHolder
    extends IHandoffRequestCallback.Stub {
        private final Executor mExecutor;
        private final HandoffRequestCallback mCallback;

        HandoffRequestCallbackHolder(@NonNull TaskContinuityManager taskContinuityManager, @NonNull Executor executor, HandoffRequestCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onHandoffRequestFinished(int associationId, int remoteTaskId, int resultCode) throws RemoteException {
            this.mExecutor.execute(() -> this.mCallback.onHandoffRequestFinished(associationId, remoteTaskId, resultCode));
        }
    }

    public static interface HandoffRequestCallback {
        public void onHandoffRequestFinished(int var1, int var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HandoffRequestResultCode {
    }
}

