/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.companion.DeviceId;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import com.android.internal.hidden_from_bootclasspath.android.companion.Flags;
import java.util.Objects;

@FlaggedApi(value="android.companion.device_presence")
public class ObservingDevicePresenceRequest
implements Parcelable {
    private final int mAssociationId;
    @Nullable
    private final ParcelUuid mUuid;
    @Nullable
    private final DeviceId mDeviceId;
    private static final int PARCEL_UUID_NULL = 0;
    private static final int PARCEL_UUID_NOT_NULL = 1;
    @NonNull
    public static final Parcelable.Creator<ObservingDevicePresenceRequest> CREATOR = new Parcelable.Creator<ObservingDevicePresenceRequest>(){

        public ObservingDevicePresenceRequest[] newArray(int size) {
            return new ObservingDevicePresenceRequest[size];
        }

        @Override
        public ObservingDevicePresenceRequest createFromParcel(@NonNull Parcel in) {
            return new ObservingDevicePresenceRequest(in);
        }
    };

    private ObservingDevicePresenceRequest(int associationId, @Nullable ParcelUuid uuid, @Nullable DeviceId deviceId) {
        this.mAssociationId = associationId;
        this.mUuid = uuid;
        this.mDeviceId = deviceId;
    }

    private ObservingDevicePresenceRequest(@NonNull Parcel in) {
        this.mAssociationId = in.readInt();
        this.mUuid = in.readInt() == 0 ? null : ParcelUuid.CREATOR.createFromParcel(in);
        this.mDeviceId = in.readInt() == 1 && Flags.associationVerification() ? DeviceId.CREATOR.createFromParcel(in) : null;
    }

    public int getAssociationId() {
        return this.mAssociationId;
    }

    @Nullable
    public ParcelUuid getUuid() {
        return this.mUuid;
    }

    @SystemApi
    @Nullable
    @FlaggedApi(value="android.companion.association_verification")
    public DeviceId getDeviceId() {
        return this.mDeviceId;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAssociationId);
        if (this.mUuid == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            this.mUuid.writeToParcel(dest, flags);
        }
        if (Flags.associationVerification() && this.mDeviceId != null) {
            dest.writeInt(1);
            this.mDeviceId.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "ObservingDevicePresenceRequest { Association Id= " + this.mAssociationId + ",ParcelUuid= " + this.mUuid + ",Device id= " + this.mDeviceId + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObservingDevicePresenceRequest)) {
            return false;
        }
        ObservingDevicePresenceRequest that = (ObservingDevicePresenceRequest)o;
        if (Flags.associationVerification()) {
            return Objects.equals(this.mUuid, that.mUuid) && this.mAssociationId == that.mAssociationId && Objects.equals(this.mDeviceId, that.mDeviceId);
        }
        return Objects.equals(this.mUuid, that.mUuid) && this.mAssociationId == that.mAssociationId;
    }

    public int hashCode() {
        return Objects.hash(this.mAssociationId, this.mUuid);
    }

    public static class Builder {
        private int mAssociationId = -1;
        private ParcelUuid mUuid;
        private DeviceId mDeviceId;

        @NonNull
        public Builder setAssociationId(int associationId) {
            this.mAssociationId = associationId;
            return this;
        }

        @NonNull
        @RequiresPermission(allOf={"android.permission.REQUEST_OBSERVE_DEVICE_UUID_PRESENCE", "android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_SCAN"})
        public Builder setUuid(@NonNull ParcelUuid uuid) {
            this.mUuid = uuid;
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresPermission(value="android.permission.ACCESS_COMPANION_INFO")
        @FlaggedApi(value="android.companion.association_verification")
        public Builder setDeviceId(@NonNull DeviceId deviceId) {
            this.mDeviceId = deviceId;
            return this;
        }

        @NonNull
        public ObservingDevicePresenceRequest build() {
            int providedCount = 0;
            if (this.mDeviceId != null) {
                ++providedCount;
            }
            if (this.mUuid != null) {
                ++providedCount;
            }
            if (this.mAssociationId != -1) {
                ++providedCount;
            }
            if (providedCount != 1) {
                throw new IllegalStateException("Must provide exactly one of device id, parcel uuid, or association id to observe device presence.");
            }
            return new ObservingDevicePresenceRequest(this.mAssociationId, this.mUuid, this.mDeviceId);
        }
    }
}

