/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManagerInternal;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.companion.AssociationInfo;
import android.companion.AssociationRequest;
import android.companion.CompanionException;
import android.companion.DeviceId;
import android.companion.DeviceNotAssociatedException;
import android.companion.IAssociationRequestCallback;
import android.companion.ICompanionDeviceManager;
import android.companion.IOnAssociationsChangedListener;
import android.companion.IOnMessageReceivedListener;
import android.companion.IOnTransportsChangedListener;
import android.companion.ISystemDataTransferCallback;
import android.companion.ObservingDevicePresenceRequest;
import android.companion.datatransfer.PermissionSyncRequest;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.MacAddress;
import android.os.Binder;
import android.os.Handler;
import android.os.OutcomeReceiver;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.android.companion.Flags;
import com.android.internal.util.CollectionUtils;
import com.android.server.LocalServices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import libcore.io.IoUtils;

@SuppressLint(value={"LongLogTag"})
public class CompanionDeviceManager {
    private static final String TAG = "CDM_CompanionDeviceManager";
    private static final int ICON_TARGET_SIZE = 24;
    public static final int RESULT_OK = -1;
    public static final int RESULT_CANCELED = 0;
    public static final int RESULT_USER_REJECTED = 1;
    public static final int RESULT_DISCOVERY_TIMEOUT = 2;
    public static final int RESULT_INTERNAL_ERROR = 3;
    @FlaggedApi(value="android.companion.association_failure_code")
    public static final int RESULT_SECURITY_ERROR = 4;
    public static final String REASON_USER_REJECTED = "user_rejected";
    public static final String REASON_DISCOVERY_TIMEOUT = "discovery_timeout";
    public static final String REASON_INTERNAL_ERROR = "internal_error";
    public static final String REASON_CANCELED = "canceled";
    public static final int FLAG_CALL_METADATA = 1;
    @Deprecated
    public static final String EXTRA_DEVICE = "android.companion.extra.DEVICE";
    public static final String EXTRA_ASSOCIATION = "android.companion.extra.ASSOCIATION";
    public static final int MESSAGE_REQUEST_PING = 1669362552;
    public static final int MESSAGE_ONEWAY_PING = 1132491640;
    public static final int MESSAGE_REQUEST_REMOTE_AUTHENTICATION = 1669494629;
    public static final int MESSAGE_REQUEST_CONTEXT_SYNC = 1667729539;
    public static final int MESSAGE_ONEWAY_TASK_CONTINUITY = 1130858628;
    public static final int MESSAGE_REQUEST_PERMISSION_RESTORE = 1669491075;
    public static final int MESSAGE_ONEWAY_FROM_WEARABLE = 1131446919;
    public static final int MESSAGE_ONEWAY_TO_WEARABLE = 1132755335;
    public static final int TRANSPORT_FLAG_EXTEND_PATCH_DIFF = 1;
    private final ICompanionDeviceManager mService;
    private final Context mContext;
    @GuardedBy(value={"mListeners"})
    private final ArrayList<OnAssociationsChangedListenerProxy> mListeners = new ArrayList();
    @GuardedBy(value={"mTransportsChangedListeners"})
    private final ArrayList<OnTransportsChangedListenerProxy> mTransportsChangedListeners = new ArrayList();
    @GuardedBy(value={"mMessageReceivedListeners"})
    private final SparseArray<Set<OnMessageReceivedListenerProxy>> mMessageReceivedListeners = new SparseArray();
    @GuardedBy(value={"mTransports"})
    private final SparseArray<Transport> mTransports = new SparseArray();

    public CompanionDeviceManager(@Nullable ICompanionDeviceManager service, @NonNull Context context) {
        this.mService = service;
        this.mContext = context;
    }

    @RequiresPermission(anyOf={"android.permission.REQUEST_COMPANION_PROFILE_WATCH", "android.permission.REQUEST_COMPANION_PROFILE_COMPUTER", "android.permission.REQUEST_COMPANION_PROFILE_APP_STREAMING", "android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION"}, conditional=true)
    public void associate(@NonNull AssociationRequest request, @NonNull Callback callback, @Nullable Handler handler) {
        Icon deviceIcon;
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        Objects.requireNonNull(request, "Request cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        handler = Handler.mainIfNull(handler);
        if (Flags.associationDeviceIcon() && (deviceIcon = request.getDeviceIcon()) != null) {
            request.setDeviceIcon(this.scaleIcon(deviceIcon, this.mContext));
        }
        try {
            this.mService.associate(request, new AssociationRequestCallbackProxy(handler, callback), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.REQUEST_COMPANION_PROFILE_WATCH", "android.permission.REQUEST_COMPANION_PROFILE_COMPUTER", "android.permission.REQUEST_COMPANION_PROFILE_APP_STREAMING", "android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION"}, conditional=true)
    public void associate(@NonNull AssociationRequest request, @NonNull Executor executor, @NonNull Callback callback) {
        Icon deviceIcon;
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        Objects.requireNonNull(request, "Request cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        if (Flags.associationDeviceIcon() && (deviceIcon = request.getDeviceIcon()) != null) {
            request.setDeviceIcon(this.scaleIcon(deviceIcon, this.mContext));
        }
        try {
            this.mService.associate(request, new AssociationRequestCallbackProxy(executor, callback), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public IntentSender buildAssociationCancellationIntent() {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return null;
        }
        try {
            PendingIntent pendingIntent = this.mService.buildAssociationCancellationIntent(this.mContext.getOpPackageName(), this.mContext.getUserId());
            return pendingIntent.getIntentSender();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void enableSystemDataSyncForTypes(int associationId, int flags) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.enableSystemDataSync(associationId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disableSystemDataSyncForTypes(int associationId, int flags) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.disableSystemDataSync(associationId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void enablePermissionsSync(int associationId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.enablePermissionsSync(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disablePermissionsSync(int associationId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.disablePermissionsSync(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public PermissionSyncRequest getPermissionSyncRequest(int associationId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return null;
        }
        try {
            return this.mService.getPermissionSyncRequest(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @NonNull
    public List<String> getAssociations() {
        return CollectionUtils.mapNotNull(this.getMyAssociations(), a -> a.isSelfManaged() ? null : a.getDeviceMacAddressAsString());
    }

    @NonNull
    public List<AssociationInfo> getMyAssociations() {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return Collections.emptyList();
        }
        try {
            return this.mService.getAssociations(this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void disassociate(@NonNull String deviceMacAddress) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.legacyDisassociate(deviceMacAddress, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disassociate(int associationId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.disassociate(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestNotificationAccess(ComponentName component) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            PendingIntent pendingIntent = this.mService.requestNotificationAccess(component, this.mContext.getUserId());
            if (pendingIntent == null) {
                return;
            }
            IntentSender intentSender = pendingIntent.getIntentSender();
            this.mContext.startIntentSender(intentSender, null, 0, 0, 0, ActivityOptions.makeBasic().setPendingIntentBackgroundActivityStartMode(1).toBundle());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IntentSender.SendIntentException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public boolean hasNotificationAccess(ComponentName component) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return false;
        }
        try {
            return this.mService.hasNotificationAccess(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean isDeviceAssociatedForWifiConnection(@NonNull String packageName, @NonNull MacAddress macAddress, @NonNull UserHandle user) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return false;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(macAddress, "mac address cannot be null");
        Objects.requireNonNull(user, "user cannot be null");
        try {
            return this.mService.isDeviceAssociatedForWifiConnection(packageName, ((Object)macAddress).toString(), user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    @NonNull
    public List<AssociationInfo> getAllAssociations() {
        return this.getAllAssociations(this.mContext.getUserId());
    }

    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    @NonNull
    public List<AssociationInfo> getAllAssociations(int userId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return Collections.emptyList();
        }
        try {
            return this.mService.getAllAssociationsForUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void addOnAssociationsChangedListener(@NonNull Executor executor, @NonNull OnAssociationsChangedListener listener) {
        this.addOnAssociationsChangedListener(executor, listener, this.mContext.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void addOnAssociationsChangedListener(@NonNull Executor executor, @NonNull OnAssociationsChangedListener listener, int userId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        ArrayList<OnAssociationsChangedListenerProxy> arrayList = this.mListeners;
        synchronized (arrayList) {
            OnAssociationsChangedListenerProxy proxy = new OnAssociationsChangedListenerProxy(executor, listener);
            try {
                this.mService.addOnAssociationsChangedListener(proxy, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mListeners.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void removeOnAssociationsChangedListener(@NonNull OnAssociationsChangedListener listener) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        ArrayList<OnAssociationsChangedListenerProxy> arrayList = this.mListeners;
        synchronized (arrayList) {
            Iterator<OnAssociationsChangedListenerProxy> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                OnAssociationsChangedListenerProxy proxy = iterator.next();
                if (proxy.mListener != listener) continue;
                try {
                    this.mService.removeOnAssociationsChangedListener(proxy, this.mContext.getUserId());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void addOnTransportsChangedListener(@NonNull Executor executor, @NonNull Consumer<List<AssociationInfo>> listener) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        ArrayList<OnTransportsChangedListenerProxy> arrayList = this.mTransportsChangedListeners;
        synchronized (arrayList) {
            OnTransportsChangedListenerProxy proxy = new OnTransportsChangedListenerProxy(executor, listener);
            try {
                this.mService.addOnTransportsChangedListener(proxy);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mTransportsChangedListeners.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void removeOnTransportsChangedListener(@NonNull Consumer<List<AssociationInfo>> listener) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        ArrayList<OnTransportsChangedListenerProxy> arrayList = this.mTransportsChangedListeners;
        synchronized (arrayList) {
            Iterator<OnTransportsChangedListenerProxy> iterator = this.mTransportsChangedListeners.iterator();
            while (iterator.hasNext()) {
                OnTransportsChangedListenerProxy proxy = iterator.next();
                if (proxy.mListener != listener) continue;
                try {
                    this.mService.removeOnTransportsChangedListener(proxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                iterator.remove();
            }
        }
    }

    @RequiresPermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void sendMessage(int messageType, @NonNull byte[] data, @NonNull int[] associationIds) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.sendMessage(messageType, data, associationIds);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void addOnMessageReceivedListener(@NonNull Executor executor, int messageType, @NonNull BiConsumer<Integer, byte[]> listener) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        SparseArray<Set<OnMessageReceivedListenerProxy>> sparseArray = this.mMessageReceivedListeners;
        synchronized (sparseArray) {
            OnMessageReceivedListenerProxy proxy = new OnMessageReceivedListenerProxy(executor, listener);
            try {
                this.mService.addOnMessageReceivedListener(messageType, proxy);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            if (!this.mMessageReceivedListeners.contains(messageType)) {
                this.mMessageReceivedListeners.put(messageType, new HashSet());
            }
            this.mMessageReceivedListeners.get(messageType).add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void removeOnMessageReceivedListener(int messageType, @NonNull BiConsumer<Integer, byte[]> listener) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        SparseArray<Set<OnMessageReceivedListenerProxy>> sparseArray = this.mMessageReceivedListeners;
        synchronized (sparseArray) {
            if (!this.mMessageReceivedListeners.contains(messageType)) {
                Log.w(TAG, "Can't remove OnMessageReceivedListener. messageType " + messageType + " is not being listened.");
                return;
            }
            Iterator<OnMessageReceivedListenerProxy> iterator = this.mMessageReceivedListeners.get(messageType).iterator();
            while (iterator.hasNext()) {
                OnMessageReceivedListenerProxy proxy = iterator.next();
                if (proxy.mListener != listener) continue;
                try {
                    this.mService.removeOnMessageReceivedListener(messageType, proxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                iterator.remove();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean canPairWithoutPrompt(@NonNull String packageName, @NonNull String deviceMacAddress, @NonNull UserHandle user) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return false;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(deviceMacAddress, "device mac address cannot be null");
        Objects.requireNonNull(user, "user handle cannot be null");
        try {
            return this.mService.canPairWithoutPrompt(packageName, deviceMacAddress, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.companion.unpair_associated_device")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeBond(int associationId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return false;
        }
        try {
            return this.mService.removeBond(associationId, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @FlaggedApi(value="android.companion.device_presence")
    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void startObservingDevicePresence(@NonNull String deviceAddress) throws DeviceNotAssociatedException {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        Objects.requireNonNull(deviceAddress, "address cannot be null");
        try {
            this.mService.legacyStartObservingDevicePresence(deviceAddress, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        ActivityManagerInternal managerInternal = LocalServices.getService(ActivityManagerInternal.class);
        if (managerInternal != null) {
            managerInternal.logFgsApiBegin(9, callingUid, callingPid);
        }
    }

    @Deprecated
    @FlaggedApi(value="android.companion.device_presence")
    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void stopObservingDevicePresence(@NonNull String deviceAddress) throws DeviceNotAssociatedException {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        Objects.requireNonNull(deviceAddress, "address cannot be null");
        try {
            this.mService.legacyStopObservingDevicePresence(deviceAddress, this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
        }
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        ActivityManagerInternal managerInternal = LocalServices.getService(ActivityManagerInternal.class);
        if (managerInternal != null) {
            managerInternal.logFgsApiEnd(9, callingUid, callingPid);
        }
    }

    @FlaggedApi(value="android.companion.device_presence")
    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void startObservingDevicePresence(@NonNull ObservingDevicePresenceRequest request) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        Objects.requireNonNull(request, "request cannot be null");
        try {
            this.mService.startObservingDevicePresence(request, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.companion.device_presence")
    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void stopObservingDevicePresence(@NonNull ObservingDevicePresenceRequest request) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        Objects.requireNonNull(request, "request cannot be null");
        try {
            this.mService.stopObservingDevicePresence(request, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void dispatchMessage(int messageId, int associationId, @NonNull byte[] message) throws DeviceNotAssociatedException {
        Log.w(TAG, "dispatchMessage replaced by attachSystemDataTransport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void attachSystemDataTransport(int associationId, @NonNull InputStream in, @NonNull OutputStream out) throws DeviceNotAssociatedException {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        SparseArray<Transport> sparseArray = this.mTransports;
        synchronized (sparseArray) {
            if (this.mTransports.contains(associationId)) {
                this.detachSystemDataTransport(associationId);
            }
            try {
                Transport transport = new Transport(associationId, in, out, 0);
                this.mTransports.put(associationId, transport);
                transport.start();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to attach transport", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void attachSystemDataTransport(int associationId, @NonNull InputStream in, @NonNull OutputStream out, int flags) throws DeviceNotAssociatedException {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        SparseArray<Transport> sparseArray = this.mTransports;
        synchronized (sparseArray) {
            if (this.mTransports.contains(associationId)) {
                this.detachSystemDataTransport(associationId);
            }
            try {
                Transport transport = new Transport(associationId, in, out, flags);
                this.mTransports.put(associationId, transport);
                transport.start();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to attach transport", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void detachSystemDataTransport(int associationId) throws DeviceNotAssociatedException {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        SparseArray<Transport> sparseArray = this.mTransports;
        synchronized (sparseArray) {
            Transport transport = this.mTransports.get(associationId);
            if (transport != null) {
                this.mTransports.delete(associationId);
                transport.stop();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ASSOCIATE_COMPANION_DEVICES")
    public void associate(@NonNull String packageName, @NonNull MacAddress macAddress, @NonNull byte[] certificate) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(macAddress, "mac address cannot be null");
        UserHandle user = Process.myUserHandle();
        try {
            this.mService.createAssociation(packageName, ((Object)macAddress).toString(), user.getIdentifier(), certificate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
    public void notifyDeviceAppeared(int associationId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.notifySelfManagedDeviceAppeared(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
    public void notifyDeviceDisappeared(int associationId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.notifySelfManagedDeviceDisappeared(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public IntentSender buildPermissionTransferUserConsentIntent(int associationId) throws DeviceNotAssociatedException {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return null;
        }
        try {
            PendingIntent pendingIntent = this.mService.buildPermissionTransferUserConsentIntent(this.mContext.getOpPackageName(), this.mContext.getUserId(), associationId);
            if (pendingIntent == null) {
                return null;
            }
            return pendingIntent.getIntentSender();
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.companion.perm_sync_user_consent")
    public boolean isPermissionTransferUserConsented(int associationId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return false;
        }
        try {
            return this.mService.isPermissionTransferUserConsented(this.mContext.getOpPackageName(), this.mContext.getUserId(), associationId);
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void startSystemDataTransfer(int associationId) throws DeviceNotAssociatedException {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.startSystemDataTransfer(this.mContext.getOpPackageName(), this.mContext.getUserId(), associationId, null);
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    public void startSystemDataTransfer(int associationId, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, CompanionException> result) throws DeviceNotAssociatedException {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.startSystemDataTransfer(this.mContext.getOpPackageName(), this.mContext.getUserId(), associationId, new SystemDataTransferCallbackProxy(executor, result));
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isCompanionApplicationBound() {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return false;
        }
        try {
            return this.mService.isCompanionApplicationBound(this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void enableSecureTransport(boolean enabled) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.enableSecureTransport(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @FlaggedApi(value="android.companion.association_verification")
    public void setDeviceId(int associationId, @Nullable DeviceId deviceId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return;
        }
        try {
            this.mService.setDeviceId(associationId, deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.companion.association_verification")
    @Nullable
    public DeviceId createAndSetDeviceId(int associationId, @Nullable DeviceId deviceId) {
        if (this.mService == null) {
            Log.w(TAG, "CompanionDeviceManager service is not available.");
            return null;
        }
        try {
            return this.mService.setDeviceId(associationId, deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="android.companion.association_verification")
    @RequiresPermission(value="android.permission.ACCESS_COMPANION_INFO")
    @Nullable
    public AssociationInfo getAssociationByDeviceId(@NonNull DeviceId deviceId) {
        Objects.requireNonNull(deviceId, "DeviceId can not be null.");
        try {
            return this.mService.getAssociationByDeviceId(this.mContext.getUserId(), deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private Icon scaleIcon(Icon icon, Context context) {
        Bitmap bitmap;
        if (icon == null) {
            return null;
        }
        if (icon.getType() == 6 || icon.getType() == 4) {
            throw new IllegalArgumentException("The URI based Icon is not supported.");
        }
        Drawable drawable2 = icon.loadDrawable(context);
        if (drawable2 instanceof BitmapDrawable) {
            bitmap = Bitmap.createScaledBitmap(((BitmapDrawable)drawable2).getBitmap(), 24, 24, false);
        } else {
            bitmap = Bitmap.createBitmap(context.getResources().getDisplayMetrics(), 24, 24, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        return Icon.createWithBitmap(bitmap);
    }

    private static class AssociationRequestCallbackProxy
    extends IAssociationRequestCallback.Stub {
        private final Handler mHandler;
        private final Callback mCallback;
        private final Executor mExecutor;

        private AssociationRequestCallbackProxy(@NonNull Executor executor, @NonNull Callback callback) {
            this.mExecutor = executor;
            this.mHandler = null;
            this.mCallback = callback;
        }

        private AssociationRequestCallbackProxy(@NonNull Handler handler, @NonNull Callback callback) {
            this.mHandler = handler;
            this.mExecutor = null;
            this.mCallback = callback;
        }

        @Override
        public void onAssociationPending(@NonNull PendingIntent pi) {
            this.execute(this.mCallback::onAssociationPending, pi.getIntentSender());
        }

        @Override
        public void onAssociationCreated(@NonNull AssociationInfo association) {
            this.execute(this.mCallback::onAssociationCreated, association);
        }

        @Override
        public void onFailure(int errorCode, @Nullable CharSequence error) {
            if (Flags.associationFailureCode()) {
                this.execute(this.mCallback::onFailure, errorCode, error);
            }
            this.execute(this.mCallback::onFailure, error);
        }

        private <T> void execute(Consumer<T> callback, T arg) {
            if (this.mExecutor != null) {
                this.mExecutor.execute(() -> callback.accept(arg));
            } else if (this.mHandler != null) {
                this.mHandler.post(() -> callback.accept(arg));
            }
        }

        private <T, U> void execute(BiConsumer<T, U> callback, T arg1, U arg2) {
            if (this.mExecutor != null) {
                this.mExecutor.execute(() -> callback.accept(arg1, arg2));
            }
        }
    }

    public static abstract class Callback {
        @Deprecated
        public void onDeviceFound(@NonNull IntentSender intentSender) {
        }

        public void onAssociationPending(@NonNull IntentSender intentSender) {
            this.onDeviceFound(intentSender);
        }

        public void onAssociationCreated(@NonNull AssociationInfo associationInfo) {
        }

        public abstract void onFailure(@Nullable CharSequence var1);

        @FlaggedApi(value="android.companion.association_failure_code")
        public void onFailure(int errorCode, @Nullable CharSequence error) {
        }
    }

    @SystemApi
    public static interface OnAssociationsChangedListener {
        public void onAssociationsChanged(@NonNull List<AssociationInfo> var1);
    }

    private static class OnAssociationsChangedListenerProxy
    extends IOnAssociationsChangedListener.Stub {
        private final Executor mExecutor;
        private final OnAssociationsChangedListener mListener;

        private OnAssociationsChangedListenerProxy(Executor executor, OnAssociationsChangedListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onAssociationsChanged(@NonNull List<AssociationInfo> associations) {
            this.mExecutor.execute(() -> this.mListener.onAssociationsChanged(associations));
        }
    }

    private static class OnTransportsChangedListenerProxy
    extends IOnTransportsChangedListener.Stub {
        private final Executor mExecutor;
        private final Consumer<List<AssociationInfo>> mListener;

        private OnTransportsChangedListenerProxy(Executor executor, Consumer<List<AssociationInfo>> listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onTransportsChanged(@NonNull List<AssociationInfo> associations) {
            this.mExecutor.execute(() -> this.mListener.accept(associations));
        }
    }

    private static class OnMessageReceivedListenerProxy
    extends IOnMessageReceivedListener.Stub {
        private final Executor mExecutor;
        private final BiConsumer<Integer, byte[]> mListener;

        private OnMessageReceivedListenerProxy(Executor executor, BiConsumer<Integer, byte[]> listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onMessageReceived(int associationId, byte[] data) {
            this.mExecutor.execute(() -> this.mListener.accept(associationId, data));
        }
    }

    private class Transport {
        private final int mAssociationId;
        private final InputStream mRemoteIn;
        private final OutputStream mRemoteOut;
        private final int mFlags;
        private InputStream mLocalIn;
        private OutputStream mLocalOut;
        private volatile boolean mStopped;

        Transport(int associationId, InputStream remoteIn, OutputStream remoteOut) {
            this(associationId, remoteIn, remoteOut, 0);
        }

        Transport(int associationId, InputStream remoteIn, OutputStream remoteOut, int flags) {
            this.mAssociationId = associationId;
            this.mRemoteIn = remoteIn;
            this.mRemoteOut = remoteOut;
            this.mFlags = flags;
        }

        public void start() throws IOException {
            if (CompanionDeviceManager.this.mService == null) {
                Log.w(CompanionDeviceManager.TAG, "CompanionDeviceManager service is not available.");
                return;
            }
            ParcelFileDescriptor[] pair = ParcelFileDescriptor.createSocketPair();
            ParcelFileDescriptor localFd = pair[0];
            ParcelFileDescriptor remoteFd = pair[1];
            this.mLocalIn = new ParcelFileDescriptor.AutoCloseInputStream(localFd);
            this.mLocalOut = new ParcelFileDescriptor.AutoCloseOutputStream(localFd);
            try {
                CompanionDeviceManager.this.mService.attachSystemDataTransport(CompanionDeviceManager.this.mContext.getOpPackageName(), CompanionDeviceManager.this.mContext.getUserId(), this.mAssociationId, remoteFd, this.mFlags);
            }
            catch (RemoteException e) {
                throw new IOException("Failed to configure transport", e);
            }
            new Thread(() -> {
                block2: {
                    try {
                        this.copyWithFlushing(this.mLocalIn, this.mRemoteOut);
                    }
                    catch (IOException e) {
                        if (this.mStopped) break block2;
                        Log.w(CompanionDeviceManager.TAG, "Trouble during outgoing transport", e);
                        this.stop();
                    }
                }
            }).start();
            new Thread(() -> {
                block2: {
                    try {
                        this.copyWithFlushing(this.mRemoteIn, this.mLocalOut);
                    }
                    catch (IOException e) {
                        if (this.mStopped) break block2;
                        Log.w(CompanionDeviceManager.TAG, "Trouble during incoming transport", e);
                        this.stop();
                    }
                }
            }).start();
        }

        public void stop() {
            if (CompanionDeviceManager.this.mService == null) {
                Log.w(CompanionDeviceManager.TAG, "CompanionDeviceManager service is not available.");
                return;
            }
            this.mStopped = true;
            try {
                CompanionDeviceManager.this.mService.detachSystemDataTransport(CompanionDeviceManager.this.mContext.getOpPackageName(), CompanionDeviceManager.this.mContext.getUserId(), this.mAssociationId);
            }
            catch (RemoteException | IllegalArgumentException e) {
                Log.w(CompanionDeviceManager.TAG, "Failed to detach transport", e);
            }
            IoUtils.closeQuietly(this.mRemoteIn);
            IoUtils.closeQuietly(this.mRemoteOut);
            IoUtils.closeQuietly(this.mLocalIn);
            IoUtils.closeQuietly(this.mLocalOut);
        }

        private void copyWithFlushing(@NonNull InputStream in, @NonNull OutputStream out) throws IOException {
            int c;
            byte[] buffer = new byte[8192];
            while ((c = in.read(buffer)) != -1) {
                out.write(buffer, 0, c);
                out.flush();
            }
        }
    }

    private static class SystemDataTransferCallbackProxy
    extends ISystemDataTransferCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<Void, CompanionException> mCallback;

        private SystemDataTransferCallbackProxy(Executor executor, OutcomeReceiver<Void, CompanionException> callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onResult() {
            this.mExecutor.execute(() -> this.mCallback.onResult(null));
        }

        @Override
        public void onError(String error) {
            this.mExecutor.execute(() -> this.mCallback.onError(new CompanionException(error)));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransportFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataSyncTypes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResultCode {
    }
}

