/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.bluetooth.BluetoothDevice;
import android.net.wifi.ScanResult;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.util.Objects;

public class AssociatedDevice
implements Parcelable {
    private static final int CLASSIC_BLUETOOTH = 0;
    private static final int BLUETOOTH_LE = 1;
    private static final int WIFI = 2;
    @NonNull
    private final Parcelable mDevice;
    @NonNull
    public static final Parcelable.Creator<AssociatedDevice> CREATOR = new Parcelable.Creator<AssociatedDevice>(){

        public AssociatedDevice[] newArray(int size) {
            return new AssociatedDevice[size];
        }

        @Override
        public AssociatedDevice createFromParcel(@NonNull Parcel in) {
            return new AssociatedDevice(in);
        }
    };

    public AssociatedDevice(@NonNull Parcelable device) {
        this.mDevice = device;
    }

    private AssociatedDevice(Parcel in) {
        Parcelable.Creator<? extends Parcelable> creator = AssociatedDevice.getDeviceCreator(in.readInt());
        this.mDevice = creator.createFromParcel(in);
    }

    @Nullable
    public BluetoothDevice getBluetoothDevice() {
        if (this.mDevice instanceof BluetoothDevice) {
            return (BluetoothDevice)this.mDevice;
        }
        return null;
    }

    @Nullable
    public android.bluetooth.le.ScanResult getBleDevice() {
        if (this.mDevice instanceof android.bluetooth.le.ScanResult) {
            return (android.bluetooth.le.ScanResult)this.mDevice;
        }
        return null;
    }

    @Nullable
    public ScanResult getWifiDevice() {
        if (this.mDevice instanceof ScanResult) {
            return (ScanResult)this.mDevice;
        }
        return null;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.getDeviceType());
        this.mDevice.writeToParcel(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private int getDeviceType() {
        if (this.mDevice instanceof BluetoothDevice) {
            return 0;
        }
        if (this.mDevice instanceof android.bluetooth.le.ScanResult) {
            return 1;
        }
        if (this.mDevice instanceof ScanResult) {
            return 2;
        }
        throw new UnsupportedOperationException("Unsupported device type.");
    }

    private static Parcelable.Creator<? extends Parcelable> getDeviceCreator(int deviceType) {
        switch (deviceType) {
            case 0: {
                return BluetoothDevice.CREATOR;
            }
            case 1: {
                return android.bluetooth.le.ScanResult.CREATOR;
            }
            case 2: {
                return ScanResult.CREATOR;
            }
        }
        throw new UnsupportedOperationException("Unsupported device type.");
    }

    public String toString() {
        return "AssociatedDevice { device = " + this.mDevice + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociatedDevice that = (AssociatedDevice)o;
        if (this.getDeviceType() != that.getDeviceType()) {
            return false;
        }
        if (this.mDevice instanceof android.bluetooth.le.ScanResult || this.mDevice instanceof ScanResult) {
            return this.mDevice.toString().equals(that.mDevice.toString());
        }
        return Objects.equals(this.mDevice, that.mDevice);
    }

    public int hashCode() {
        return Objects.hash(this.mDevice);
    }
}

