/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class TransportBlock
implements Parcelable {
    private static final String TAG = TransportBlock.class.getSimpleName();
    private final int mOrgId;
    private final int mTdsFlags;
    private final int mTransportDataLength;
    private final byte[] mTransportData;
    @NonNull
    public static final Parcelable.Creator<TransportBlock> CREATOR = new Parcelable.Creator<TransportBlock>(){

        @Override
        public TransportBlock createFromParcel(Parcel in) {
            return new TransportBlock(in);
        }

        public TransportBlock[] newArray(int size) {
            return new TransportBlock[size];
        }
    };

    public TransportBlock(int orgId, int tdsFlags, int transportDataLength, @Nullable byte[] transportData) {
        this.mOrgId = orgId;
        this.mTdsFlags = tdsFlags;
        this.mTransportDataLength = transportDataLength;
        this.mTransportData = transportData;
    }

    private TransportBlock(Parcel in) {
        this.mOrgId = in.readInt();
        this.mTdsFlags = in.readInt();
        this.mTransportDataLength = in.readInt();
        if (this.mTransportDataLength > 0) {
            this.mTransportData = new byte[this.mTransportDataLength];
            in.readByteArray(this.mTransportData);
        } else {
            this.mTransportData = null;
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mOrgId);
        dest.writeInt(this.mTdsFlags);
        dest.writeInt(this.mTransportDataLength);
        if (this.mTransportData != null) {
            dest.writeByteArray(this.mTransportData);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransportBlock other = (TransportBlock)obj;
        return Arrays.equals(this.toByteArray(), other.toByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public int getOrgId() {
        return this.mOrgId;
    }

    public int getTdsFlags() {
        return this.mTdsFlags;
    }

    public int getTransportDataLength() {
        return this.mTransportDataLength;
    }

    @Nullable
    public byte[] getTransportData() {
        return this.mTransportData;
    }

    @Nullable
    public byte[] toByteArray() {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(this.totalBytes());
            buffer.put((byte)this.mOrgId);
            buffer.put((byte)this.mTdsFlags);
            buffer.put((byte)this.mTransportDataLength);
            if (this.mTransportData != null) {
                buffer.put(this.mTransportData);
            }
            return buffer.array();
        }
        catch (BufferOverflowException e) {
            Log.e(TAG, "Error converting to byte array: " + ((Object)e).toString());
            return null;
        }
    }

    public int totalBytes() {
        int size = 3 + this.mTransportDataLength;
        return size;
    }
}

