/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.compat.CompatChanges;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.bluetooth.jarjar.com.android.bluetooth.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class ScanSettings
implements Parcelable {
    public static final int SCAN_MODE_OPPORTUNISTIC = -1;
    public static final int SCAN_MODE_LOW_POWER = 0;
    public static final int SCAN_MODE_BALANCED = 1;
    public static final int SCAN_MODE_LOW_LATENCY = 2;
    @SystemApi
    public static final int SCAN_MODE_AMBIENT_DISCOVERY = 3;
    public static final int SCAN_MODE_SCREEN_OFF = 4;
    public static final int SCAN_MODE_SCREEN_OFF_BALANCED = 5;
    public static final int CALLBACK_TYPE_ALL_MATCHES = 1;
    public static final int CALLBACK_TYPE_FIRST_MATCH = 2;
    public static final int CALLBACK_TYPE_MATCH_LOST = 4;
    public static final int CALLBACK_TYPE_ALL_MATCHES_AUTO_BATCH = 8;
    public static final long AUTO_BATCH_MIN_REPORT_DELAY_MILLIS = 600000L;
    public static final int MATCH_NUM_ONE_ADVERTISEMENT = 1;
    public static final int MATCH_NUM_FEW_ADVERTISEMENT = 2;
    public static final int MATCH_NUM_MAX_ADVERTISEMENT = 3;
    public static final int MATCH_MODE_AGGRESSIVE = 1;
    public static final int MATCH_MODE_STICKY = 2;
    @SystemApi
    public static final int SCAN_RESULT_TYPE_FULL = 0;
    @SystemApi
    public static final int SCAN_RESULT_TYPE_ABBREVIATED = 1;
    public static final int PHY_LE_ALL_SUPPORTED = 255;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_passive_scanning")
    public static final int SCAN_TYPE_UNKNOWN = 0;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_passive_scanning")
    public static final int SCAN_TYPE_PASSIVE = 1;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_passive_scanning")
    public static final int SCAN_TYPE_ACTIVE = 2;
    static final long CHANGE_DEFAULT_TRACKABLE_ADV_NUMBER = 386727721L;
    private final int mScanMode;
    private final int mCallbackType;
    private final int mScanResultType;
    private final long mReportDelayMillis;
    private final int mMatchMode;
    private final int mNumOfMatchesPerFilter;
    private final boolean mLegacy;
    private final int mPhy;
    private final int mRssiThreshold;
    private final int mScanType;
    @NonNull
    public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

        public ScanSettings[] newArray(int size) {
            return new ScanSettings[size];
        }

        @Override
        public ScanSettings createFromParcel(Parcel in) {
            return new ScanSettings(in);
        }
    };

    public int getScanMode() {
        return this.mScanMode;
    }

    public int getCallbackType() {
        return this.mCallbackType;
    }

    public int getScanResultType() {
        return this.mScanResultType;
    }

    public long getReportDelayMillis() {
        return this.mReportDelayMillis;
    }

    public int getMatchMode() {
        return this.mMatchMode;
    }

    public int getNumOfMatches() {
        return this.mNumOfMatchesPerFilter;
    }

    public boolean getLegacy() {
        return this.mLegacy;
    }

    public int getPhy() {
        return this.mPhy;
    }

    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.rssi_scan_filter")
    public int getRssiThreshold() {
        return this.mRssiThreshold;
    }

    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_passive_scanning")
    public int getScanType() {
        return this.mScanType;
    }

    private ScanSettings(int scanMode, int callbackType, int scanResultType, long reportDelayMillis, int matchMode, int numOfMatchesPerFilter, boolean legacy, int phy, int rssiThreshold, int scanType) {
        this.mScanMode = scanMode;
        this.mCallbackType = callbackType;
        this.mScanResultType = scanResultType;
        this.mReportDelayMillis = reportDelayMillis;
        this.mNumOfMatchesPerFilter = numOfMatchesPerFilter;
        this.mMatchMode = matchMode;
        this.mLegacy = legacy;
        this.mPhy = phy;
        this.mRssiThreshold = rssiThreshold;
        this.mScanType = scanType;
    }

    private ScanSettings(Parcel in) {
        this.mScanMode = in.readInt();
        this.mCallbackType = in.readInt();
        this.mScanResultType = in.readInt();
        this.mReportDelayMillis = in.readLong();
        this.mMatchMode = in.readInt();
        this.mNumOfMatchesPerFilter = in.readInt();
        this.mLegacy = in.readInt() != 0;
        this.mPhy = in.readInt();
        this.mRssiThreshold = in.readInt();
        this.mScanType = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mScanMode);
        dest.writeInt(this.mCallbackType);
        dest.writeInt(this.mScanResultType);
        dest.writeLong(this.mReportDelayMillis);
        dest.writeInt(this.mMatchMode);
        dest.writeInt(this.mNumOfMatchesPerFilter);
        dest.writeInt(this.mLegacy ? 1 : 0);
        dest.writeInt(this.mPhy);
        dest.writeInt(this.mRssiThreshold);
        dest.writeInt(this.mScanType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static String getScanModeString(int scanMode) {
        String string2;
        switch (scanMode) {
            case -1: {
                string2 = "SCAN_MODE_OPPORTUNISTIC";
                break;
            }
            case 0: {
                string2 = "SCAN_MODE_LOW_POWER";
                break;
            }
            case 1: {
                string2 = "SCAN_MODE_BALANCED";
                break;
            }
            case 2: {
                string2 = "SCAN_MODE_LOW_LATENCY";
                break;
            }
            case 3: {
                string2 = "SCAN_MODE_AMBIENT_DISCOVERY";
                break;
            }
            case 4: {
                string2 = "SCAN_MODE_SCREEN_OFF";
                break;
            }
            case 5: {
                string2 = "SCAN_MODE_SCREEN_OFF_BALANCED";
                break;
            }
            default: {
                string2 = "UNKNOWN value=" + scanMode;
            }
        }
        return string2;
    }

    public static class Builder {
        private int mScanMode = 0;
        private int mCallbackType = 1;
        private int mScanResultType = 0;
        private long mReportDelayMillis = 0L;
        private int mMatchMode = 1;
        private int mNumOfMatchesPerFilter = 3;
        private boolean mLegacy = true;
        private int mPhy = 1;
        private int mRssiThreshold = -128;
        private int mScanType;

        public Builder() {
            int n = this.mScanType = Flags.supportPassiveScanning() ? 2 : 2;
            if (Flags.changeDefaultTrackableAdvNumber() && CompatChanges.isChangeEnabled(386727721L)) {
                this.mNumOfMatchesPerFilter = 2;
            }
        }

        public Builder setScanMode(int scanMode) {
            if (!List.of(Integer.valueOf(-1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)).contains(scanMode)) {
                throw new IllegalArgumentException("invalid scan mode " + scanMode);
            }
            this.mScanMode = scanMode;
            return this;
        }

        public Builder setCallbackType(int callbackType) {
            if (!Builder.isValidCallbackType(callbackType)) {
                throw new IllegalArgumentException("invalid callback type - " + callbackType);
            }
            this.mCallbackType = callbackType;
            return this;
        }

        private static boolean isValidCallbackType(int callbackType) {
            if (callbackType == 1 || callbackType == 8 || callbackType == 2 || callbackType == 4) {
                return true;
            }
            return callbackType == 6;
        }

        @SystemApi
        public Builder setScanResultType(int scanResultType) {
            if (scanResultType < 0 || scanResultType > 1) {
                throw new IllegalArgumentException("invalid scanResultType - " + scanResultType);
            }
            this.mScanResultType = scanResultType;
            return this;
        }

        public Builder setReportDelay(long reportDelayMillis) {
            if (reportDelayMillis < 0L) {
                throw new IllegalArgumentException("reportDelay must be > 0");
            }
            this.mReportDelayMillis = reportDelayMillis;
            return this;
        }

        public Builder setNumOfMatches(int numOfMatches) {
            if (numOfMatches < 1 || numOfMatches > 3) {
                throw new IllegalArgumentException("invalid numOfMatches " + numOfMatches);
            }
            this.mNumOfMatchesPerFilter = numOfMatches;
            return this;
        }

        public Builder setMatchMode(int matchMode) {
            if (matchMode < 1 || matchMode > 2) {
                throw new IllegalArgumentException("invalid matchMode " + matchMode);
            }
            this.mMatchMode = matchMode;
            return this;
        }

        public Builder setLegacy(boolean legacy) {
            this.mLegacy = legacy;
            return this;
        }

        public Builder setPhy(int phy) {
            this.mPhy = phy;
            return this;
        }

        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.rssi_scan_filter")
        @NonNull
        public Builder setRssiThreshold(int rssiThreshold) {
            this.mRssiThreshold = rssiThreshold;
            return this;
        }

        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_passive_scanning")
        @NonNull
        public Builder setScanType(int scanType) {
            if (scanType != 1 && scanType != 2) {
                throw new IllegalArgumentException("invalid scan type");
            }
            this.mScanType = scanType;
            return this;
        }

        public ScanSettings build() {
            if (this.mCallbackType == 8 && this.mReportDelayMillis < 600000L) {
                throw new IllegalArgumentException("report delay for auto batch must be >= 600000");
            }
            return new ScanSettings(this.mScanMode, this.mCallbackType, this.mScanResultType, this.mReportDelayMillis, this.mMatchMode, this.mNumOfMatchesPerFilter, this.mLegacy, this.mPhy, this.mRssiThreshold, this.mScanType);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanType {
    }
}

