/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.bluetooth.IBluetoothManagerCallback;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothManager
extends IInterface {
    public static final String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    public static final String IPC_CACHE_MODULE_SYSTEM = "system_server";
    public static final String GET_SYSTEM_STATE_API = "BluetoothAdapter_getSystemState";
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String ACTION_BLE_STATE_CHANGED = "android.bluetooth.adapter.action.BLE_STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static final String ACTION_AUTO_ON_STATE_CHANGED = "android.bluetooth.action.AUTO_ON_STATE_CHANGED";
    public static final String EXTRA_AUTO_ON_STATE = "android.bluetooth.extra.AUTO_ON_STATE";
    public static final int AUTO_ON_STATE_DISABLED = 1;
    public static final int AUTO_ON_STATE_ENABLED = 2;
    public static final int BT_SNOOP_LOG_MODE_DISABLED = 0;
    public static final int BT_SNOOP_LOG_MODE_FILTERED = 1;
    public static final int BT_SNOOP_LOG_MODE_FULL = 2;

    @RequiresNoPermission
    public IBinder registerAdapter(IBluetoothManagerCallback var1) throws RemoteException;

    @RequiresNoPermission
    public void unregisterAdapter(IBluetoothManagerCallback var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enable(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enableNoAutoConnect(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public boolean disable(AttributionSource var1, boolean var2) throws RemoteException;

    @RequiresNoPermission
    public int getState() throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    public String getAddress(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean factoryReset(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean onFactoryReset(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public boolean isBleScanAvailable() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enableBle(AttributionSource var1, IBinder var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disableBle(AttributionSource var1, IBinder var2) throws RemoteException;

    @RequiresNoPermission
    public boolean isHearingAidProfileSupported() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int setBtHciSnoopLogMode(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getBtHciSnoopLogMode() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean isAutoOnSupported() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean isAutoOnEnabled() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void setAutoOnEnabled(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothManager {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothManager";
        static final int TRANSACTION_registerAdapter = 1;
        static final int TRANSACTION_unregisterAdapter = 2;
        static final int TRANSACTION_enable = 3;
        static final int TRANSACTION_enableNoAutoConnect = 4;
        static final int TRANSACTION_disable = 5;
        static final int TRANSACTION_getState = 6;
        static final int TRANSACTION_getAddress = 7;
        static final int TRANSACTION_getName = 8;
        static final int TRANSACTION_factoryReset = 9;
        static final int TRANSACTION_onFactoryReset = 10;
        static final int TRANSACTION_isBleScanAvailable = 11;
        static final int TRANSACTION_enableBle = 12;
        static final int TRANSACTION_disableBle = 13;
        static final int TRANSACTION_isHearingAidProfileSupported = 14;
        static final int TRANSACTION_setBtHciSnoopLogMode = 15;
        static final int TRANSACTION_getBtHciSnoopLogMode = 16;
        static final int TRANSACTION_isAutoOnSupported = 17;
        static final int TRANSACTION_isAutoOnEnabled = 18;
        static final int TRANSACTION_setAutoOnEnabled = 19;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothManager) {
                return (IBluetoothManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerAdapter";
                }
                case 2: {
                    return "unregisterAdapter";
                }
                case 3: {
                    return "enable";
                }
                case 4: {
                    return "enableNoAutoConnect";
                }
                case 5: {
                    return "disable";
                }
                case 6: {
                    return "getState";
                }
                case 7: {
                    return "getAddress";
                }
                case 8: {
                    return "getName";
                }
                case 9: {
                    return "factoryReset";
                }
                case 10: {
                    return "onFactoryReset";
                }
                case 11: {
                    return "isBleScanAvailable";
                }
                case 12: {
                    return "enableBle";
                }
                case 13: {
                    return "disableBle";
                }
                case 14: {
                    return "isHearingAidProfileSupported";
                }
                case 15: {
                    return "setBtHciSnoopLogMode";
                }
                case 16: {
                    return "getBtHciSnoopLogMode";
                }
                case 17: {
                    return "isAutoOnSupported";
                }
                case 18: {
                    return "isAutoOnEnabled";
                }
                case 19: {
                    return "setAutoOnEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBluetoothManagerCallback _arg0 = IBluetoothManagerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IBinder _result = this.registerAdapter(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 2: {
                    IBluetoothManagerCallback _arg0 = IBluetoothManagerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAdapter(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.enable(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.enableNoAutoConnect(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.disable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getAddress(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 8: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 9: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.factoryReset(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.onFactoryReset(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    boolean _result = this.isBleScanAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.enableBle(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.disableBle(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    boolean _result = this.isHearingAidProfileSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setBtHciSnoopLogMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 16: {
                    int _result = this.getBtHciSnoopLogMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 17: {
                    boolean _result = this.isAutoOnSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    boolean _result = this.isAutoOnEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAutoOnEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 18;
        }

        private static class Proxy
        implements IBluetoothManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder registerAdapter(IBluetoothManagerCallback callback) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAdapter(IBluetoothManagerCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enable(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableNoAutoConnect(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disable(AttributionSource attributionSource, boolean persist) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeBoolean(persist);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAddress(AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getName(AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean factoryReset(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onFactoryReset(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBleScanAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableBle(AttributionSource attributionSource, IBinder b) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeStrongBinder(b);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disableBle(AttributionSource attributionSource, IBinder b) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeStrongBinder(b);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHearingAidProfileSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setBtHciSnoopLogMode(int mode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBtHciSnoopLogMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutoOnSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutoOnEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoOnEnabled(boolean status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(status);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothManager {
        @Override
        public IBinder registerAdapter(IBluetoothManagerCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterAdapter(IBluetoothManagerCallback callback) throws RemoteException {
        }

        @Override
        public boolean enable(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean enableNoAutoConnect(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean disable(AttributionSource attributionSource, boolean persist) throws RemoteException {
            return false;
        }

        @Override
        public int getState() throws RemoteException {
            return 0;
        }

        @Override
        public String getAddress(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public String getName(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean factoryReset(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean onFactoryReset(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean isBleScanAvailable() throws RemoteException {
            return false;
        }

        @Override
        public boolean enableBle(AttributionSource attributionSource, IBinder b) throws RemoteException {
            return false;
        }

        @Override
        public boolean disableBle(AttributionSource attributionSource, IBinder b) throws RemoteException {
            return false;
        }

        @Override
        public boolean isHearingAidProfileSupported() throws RemoteException {
            return false;
        }

        @Override
        public int setBtHciSnoopLogMode(int mode) throws RemoteException {
            return 0;
        }

        @Override
        public int getBtHciSnoopLogMode() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isAutoOnSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isAutoOnEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setAutoOnEnabled(boolean status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

