/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothLeCall;
import android.bluetooth.IBluetoothLeCallControlCallback;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothLeCallControl
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothLeCallControl";

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerBearer(String var1, IBluetoothLeCallControlCallback var2, String var3, List<String> var4, int var5, String var6, int var7, AttributionSource var8) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterBearer(String var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void requestResult(int var1, int var2, int var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void callAdded(int var1, BluetoothLeCall var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void callRemoved(int var1, ParcelUuid var2, int var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void callStateChanged(int var1, ParcelUuid var2, int var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void currentCallsList(int var1, List<BluetoothLeCall> var2, AttributionSource var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothLeCallControl {
        static final int TRANSACTION_registerBearer = 1;
        static final int TRANSACTION_unregisterBearer = 2;
        static final int TRANSACTION_requestResult = 3;
        static final int TRANSACTION_callAdded = 4;
        static final int TRANSACTION_callRemoved = 5;
        static final int TRANSACTION_callStateChanged = 6;
        static final int TRANSACTION_currentCallsList = 7;

        public Stub() {
            this.attachInterface(this, IBluetoothLeCallControl.DESCRIPTOR);
        }

        public static IBluetoothLeCallControl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothLeCallControl.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothLeCallControl) {
                return (IBluetoothLeCallControl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerBearer";
                }
                case 2: {
                    return "unregisterBearer";
                }
                case 3: {
                    return "requestResult";
                }
                case 4: {
                    return "callAdded";
                }
                case 5: {
                    return "callRemoved";
                }
                case 6: {
                    return "callStateChanged";
                }
                case 7: {
                    return "currentCallsList";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothLeCallControl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    IBluetoothLeCallControlCallback _arg1 = IBluetoothLeCallControlCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    ArrayList<String> _arg3 = data.createStringArrayList();
                    int _arg4 = data.readInt();
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    AttributionSource _arg7 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerBearer(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterBearer(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestResult(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    BluetoothLeCall _arg1 = data.readTypedObject(BluetoothLeCall.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.callAdded(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.callRemoved(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.callStateChanged(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    ArrayList<BluetoothLeCall> _arg1 = data.createTypedArrayList(BluetoothLeCall.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.currentCallsList(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IBluetoothLeCallControl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothLeCallControl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerBearer(String token, IBluetoothLeCallControlCallback callback, String uci, List<String> uriSchemes, int capabilities, String provider, int technology, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControl.DESCRIPTOR);
                    _data.writeString(token);
                    _data.writeStrongInterface(callback);
                    _data.writeString(uci);
                    _data.writeStringList(uriSchemes);
                    _data.writeInt(capabilities);
                    _data.writeString(provider);
                    _data.writeInt(technology);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterBearer(String token, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControl.DESCRIPTOR);
                    _data.writeString(token);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestResult(int ccid, int requestId, int result, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControl.DESCRIPTOR);
                    _data.writeInt(ccid);
                    _data.writeInt(requestId);
                    _data.writeInt(result);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callAdded(int ccid, BluetoothLeCall call, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControl.DESCRIPTOR);
                    _data.writeInt(ccid);
                    _data.writeTypedObject(call, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callRemoved(int ccid, ParcelUuid callId, int reason, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControl.DESCRIPTOR);
                    _data.writeInt(ccid);
                    _data.writeTypedObject(callId, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callStateChanged(int ccid, ParcelUuid callId, int state, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControl.DESCRIPTOR);
                    _data.writeInt(ccid);
                    _data.writeTypedObject(callId, 0);
                    _data.writeInt(state);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void currentCallsList(int ccid, List<BluetoothLeCall> calls, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControl.DESCRIPTOR);
                    _data.writeInt(ccid);
                    _data.writeTypedList(calls, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothLeCallControl {
        @Override
        public void registerBearer(String token, IBluetoothLeCallControlCallback callback, String uci, List<String> uriSchemes, int capabilities, String provider, int technology, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterBearer(String token, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void requestResult(int ccid, int requestId, int result, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void callAdded(int ccid, BluetoothLeCall call, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void callRemoved(int ccid, ParcelUuid callId, int reason, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void callStateChanged(int ccid, ParcelUuid callId, int state, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void currentCallsList(int ccid, List<BluetoothLeCall> calls, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

