/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattService;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothGattCallback
extends IInterface {
    public void onClientRegistered(int var1) throws RemoteException;

    public void onClientConnectionState(int var1, boolean var2, BluetoothDevice var3) throws RemoteException;

    public void onPhyUpdate(BluetoothDevice var1, int var2, int var3, int var4) throws RemoteException;

    public void onPhyRead(BluetoothDevice var1, int var2, int var3, int var4) throws RemoteException;

    public void onSearchComplete(BluetoothDevice var1, List<BluetoothGattService> var2, int var3) throws RemoteException;

    public void onCharacteristicRead(BluetoothDevice var1, int var2, int var3, byte[] var4) throws RemoteException;

    public void onCharacteristicWrite(BluetoothDevice var1, int var2, int var3, byte[] var4) throws RemoteException;

    public void onExecuteWrite(BluetoothDevice var1, int var2) throws RemoteException;

    public void onDescriptorRead(BluetoothDevice var1, int var2, int var3, byte[] var4) throws RemoteException;

    public void onDescriptorWrite(BluetoothDevice var1, int var2, int var3, byte[] var4) throws RemoteException;

    public void onNotify(BluetoothDevice var1, int var2, byte[] var3) throws RemoteException;

    public void onReadRemoteRssi(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void onConfigureMTU(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void onConnectionUpdated(BluetoothDevice var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void onServiceChanged(BluetoothDevice var1) throws RemoteException;

    public void onSubrateChange(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothGattCallback {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothGattCallback";
        static final int TRANSACTION_onClientRegistered = 1;
        static final int TRANSACTION_onClientConnectionState = 2;
        static final int TRANSACTION_onPhyUpdate = 3;
        static final int TRANSACTION_onPhyRead = 4;
        static final int TRANSACTION_onSearchComplete = 5;
        static final int TRANSACTION_onCharacteristicRead = 6;
        static final int TRANSACTION_onCharacteristicWrite = 7;
        static final int TRANSACTION_onExecuteWrite = 8;
        static final int TRANSACTION_onDescriptorRead = 9;
        static final int TRANSACTION_onDescriptorWrite = 10;
        static final int TRANSACTION_onNotify = 11;
        static final int TRANSACTION_onReadRemoteRssi = 12;
        static final int TRANSACTION_onConfigureMTU = 13;
        static final int TRANSACTION_onConnectionUpdated = 14;
        static final int TRANSACTION_onServiceChanged = 15;
        static final int TRANSACTION_onSubrateChange = 16;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothGattCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothGattCallback) {
                return (IBluetoothGattCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onClientRegistered";
                }
                case 2: {
                    return "onClientConnectionState";
                }
                case 3: {
                    return "onPhyUpdate";
                }
                case 4: {
                    return "onPhyRead";
                }
                case 5: {
                    return "onSearchComplete";
                }
                case 6: {
                    return "onCharacteristicRead";
                }
                case 7: {
                    return "onCharacteristicWrite";
                }
                case 8: {
                    return "onExecuteWrite";
                }
                case 9: {
                    return "onDescriptorRead";
                }
                case 10: {
                    return "onDescriptorWrite";
                }
                case 11: {
                    return "onNotify";
                }
                case 12: {
                    return "onReadRemoteRssi";
                }
                case 13: {
                    return "onConfigureMTU";
                }
                case 14: {
                    return "onConnectionUpdated";
                }
                case 15: {
                    return "onServiceChanged";
                }
                case 16: {
                    return "onSubrateChange";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onClientRegistered(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    BluetoothDevice _arg2 = data.readTypedObject(BluetoothDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onClientConnectionState(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPhyUpdate(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPhyRead(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    ArrayList<BluetoothGattService> _arg1 = data.createTypedArrayList(BluetoothGattService.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSearchComplete(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onCharacteristicRead(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 7: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onCharacteristicWrite(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 8: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onExecuteWrite(_arg0, _arg1);
                    break;
                }
                case 9: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onDescriptorRead(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 10: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onDescriptorWrite(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 11: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onNotify(_arg0, _arg1, _arg2);
                    break;
                }
                case 12: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onReadRemoteRssi(_arg0, _arg1, _arg2);
                    break;
                }
                case 13: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConfigureMTU(_arg0, _arg1, _arg2);
                    break;
                }
                case 14: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConnectionUpdated(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 15: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onServiceChanged(_arg0);
                    break;
                }
                case 16: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSubrateChange(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 15;
        }

        private static class Proxy
        implements IBluetoothGattCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClientRegistered(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClientConnectionState(int status, boolean connected, BluetoothDevice device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeBoolean(connected);
                    _data.writeTypedObject(device, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhyUpdate(BluetoothDevice device, int txPhy, int rxPhy, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhyRead(BluetoothDevice device, int txPhy, int rxPhy, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSearchComplete(BluetoothDevice device, List<BluetoothGattService> services, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedList(services, 0);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCharacteristicRead(BluetoothDevice device, int status, int handle, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(status);
                    _data.writeInt(handle);
                    _data.writeByteArray(value);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCharacteristicWrite(BluetoothDevice device, int status, int handle, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(status);
                    _data.writeInt(handle);
                    _data.writeByteArray(value);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onExecuteWrite(BluetoothDevice device, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDescriptorRead(BluetoothDevice device, int status, int handle, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(status);
                    _data.writeInt(handle);
                    _data.writeByteArray(value);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDescriptorWrite(BluetoothDevice device, int status, int handle, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(status);
                    _data.writeInt(handle);
                    _data.writeByteArray(value);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotify(BluetoothDevice device, int handle, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(handle);
                    _data.writeByteArray(value);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReadRemoteRssi(BluetoothDevice device, int rssi, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(rssi);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigureMTU(BluetoothDevice device, int mtu, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(mtu);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionUpdated(BluetoothDevice device, int interval, int latency, int timeout, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(interval);
                    _data.writeInt(latency);
                    _data.writeInt(timeout);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceChanged(BluetoothDevice device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubrateChange(BluetoothDevice device, int subrateMode, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(subrateMode);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothGattCallback {
        @Override
        public void onClientRegistered(int status) throws RemoteException {
        }

        @Override
        public void onClientConnectionState(int status, boolean connected, BluetoothDevice device) throws RemoteException {
        }

        @Override
        public void onPhyUpdate(BluetoothDevice device, int txPhy, int rxPhy, int status) throws RemoteException {
        }

        @Override
        public void onPhyRead(BluetoothDevice device, int txPhy, int rxPhy, int status) throws RemoteException {
        }

        @Override
        public void onSearchComplete(BluetoothDevice device, List<BluetoothGattService> services, int status) throws RemoteException {
        }

        @Override
        public void onCharacteristicRead(BluetoothDevice device, int status, int handle, byte[] value) throws RemoteException {
        }

        @Override
        public void onCharacteristicWrite(BluetoothDevice device, int status, int handle, byte[] value) throws RemoteException {
        }

        @Override
        public void onExecuteWrite(BluetoothDevice device, int status) throws RemoteException {
        }

        @Override
        public void onDescriptorRead(BluetoothDevice device, int status, int handle, byte[] value) throws RemoteException {
        }

        @Override
        public void onDescriptorWrite(BluetoothDevice device, int status, int handle, byte[] value) throws RemoteException {
        }

        @Override
        public void onNotify(BluetoothDevice device, int handle, byte[] value) throws RemoteException {
        }

        @Override
        public void onReadRemoteRssi(BluetoothDevice device, int rssi, int status) throws RemoteException {
        }

        @Override
        public void onConfigureMTU(BluetoothDevice device, int mtu, int status) throws RemoteException {
        }

        @Override
        public void onConnectionUpdated(BluetoothDevice device, int interval, int latency, int timeout, int status) throws RemoteException {
        }

        @Override
        public void onServiceChanged(BluetoothDevice device) throws RemoteException {
        }

        @Override
        public void onSubrateChange(BluetoothDevice device, int subrateMode, int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

