/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothInputStream;
import android.bluetooth.BluetoothOutputStream;
import android.bluetooth.BluetoothSocketException;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothSocketManager;
import android.bluetooth.SocketMetrics;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.net.LocalSocket;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.jarjar.com.android.bluetooth.flags.Flags;
import com.android.internal.lang.System_Delegate;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;

public class BluetoothSocket
implements Closeable {
    private static final String TAG = BluetoothSocket.class.getSimpleName();
    private static final boolean DBG = Log.isLoggable("bluetooth", 3);
    private static final boolean VDBG = Log.isLoggable("bluetooth", 2);
    public static final int MAX_RFCOMM_CHANNEL = 30;
    static final int MAX_L2CAP_PACKAGE_SIZE = 65535;
    public static final int TYPE_RFCOMM = 1;
    public static final int TYPE_SCO = 2;
    public static final int TYPE_L2CAP = 3;
    public static final int TYPE_L2CAP_BREDR = 3;
    public static final int TYPE_L2CAP_LE = 4;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
    public static final int TYPE_LE = 4;
    static final int EBADFD = 77;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    static final int EADDRINUSE = 98;
    static final int SEC_FLAG_ENCRYPT = 1;
    static final int SEC_FLAG_AUTH = 2;
    static final int BTSOCK_FLAG_NO_SDP = 4;
    static final int SEC_FLAG_AUTH_PITM = 8;
    static final int SEC_FLAG_AUTH_16_DIGIT = 16;
    static final String DEFAULT_SOCKET_NAME = "default_name";
    private final int mType;
    private BluetoothDevice mDevice;
    private String mAddress;
    private final boolean mAuth;
    private final boolean mEncrypt;
    private final BluetoothInputStream mInputStream;
    private final BluetoothOutputStream mOutputStream;
    private final ParcelUuid mUuid;
    private final int mDataPath;
    private final String mSocketName;
    private final long mHubId;
    private final long mEndpointId;
    private final int mMaximumPacketSize;
    private boolean mExcludeSdp = false;
    private boolean mAuthPitm = false;
    private boolean mMin16DigitPin = false;
    @UnsupportedAppUsage(publicAlternatives="Use {@link BluetoothSocket} public API instead.")
    private ParcelFileDescriptor mPfd;
    @UnsupportedAppUsage
    private LocalSocket mSocket;
    private InputStream mSocketIS;
    private OutputStream mSocketOS;
    @UnsupportedAppUsage
    private int mPort;
    private String mServiceName;
    private static final int SOCK_CONNECTION_SIGNAL_SIZE = 44;
    private static final long INVALID_SOCKET_ID = 0L;
    private static final int SOCK_ACCEPT_SIGNAL_SIZE = 4;
    private ByteBuffer mL2capBuffer = null;
    private int mMaxTxPacketSize = 0;
    private int mMaxRxPacketSize = 0;
    private ParcelUuid mConnectionUuid;
    private long mSocketId;
    private long mSocketCreationTimeNanos = 0L;
    private long mSocketCreationLatencyNanos = 0L;
    private volatile SocketState mSocketState;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    BluetoothSocket(int type, boolean auth, boolean encrypt, int port, ParcelUuid uuid) throws IOException {
        this(type, auth, encrypt, port, uuid, false, false);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    BluetoothSocket(int type, boolean auth, boolean encrypt, int port, ParcelUuid uuid, boolean pitm, boolean min16DigitPin) throws IOException {
        this(type, auth, encrypt, port, uuid, pitm, min16DigitPin, 0, DEFAULT_SOCKET_NAME, 0L, 0L, 0);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    BluetoothSocket(int type, boolean auth, boolean encrypt, int port, ParcelUuid uuid, boolean pitm, boolean min16DigitPin, int dataPath, @NonNull String socketName, long hubId, long endpointId, int maximumPacketSize) throws IOException {
        if (VDBG) {
            Log.d(TAG, "Creating new BluetoothSocket of type: " + type);
        }
        this.mSocketCreationTimeNanos = System_Delegate.nanoTime();
        if (type == 1 && uuid == null && port != -2 && (port < 1 || port > 30)) {
            throw new IOException("Invalid RFCOMM channel: " + port);
        }
        this.mUuid = uuid != null ? uuid : new ParcelUuid(new UUID(0L, 0L));
        this.mType = type;
        this.mAuth = auth;
        this.mAuthPitm = pitm;
        this.mMin16DigitPin = min16DigitPin;
        this.mEncrypt = encrypt;
        this.mPort = port;
        this.mDevice = null;
        this.mDataPath = dataPath;
        this.mSocketName = socketName;
        this.mHubId = hubId;
        this.mEndpointId = endpointId;
        this.mMaximumPacketSize = maximumPacketSize;
        this.mSocketState = SocketState.INIT;
        this.mAddress = BluetoothAdapter.getDefaultAdapter().getAddress();
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
        this.mSocketCreationLatencyNanos = System_Delegate.nanoTime() - this.mSocketCreationTimeNanos;
    }

    BluetoothSocket(BluetoothDevice device, int type, boolean auth, boolean encrypt, int port, ParcelUuid uuid) throws IOException {
        this(device, type, auth, encrypt, port, uuid, false, false);
    }

    BluetoothSocket(@NonNull BluetoothDevice device, int type, boolean auth, boolean encrypt, int port, ParcelUuid uuid, boolean pitm, boolean min16DigitPin) throws IOException {
        this(device, type, auth, encrypt, port, uuid, pitm, min16DigitPin, 0, DEFAULT_SOCKET_NAME, 0L, 0L, 0);
    }

    BluetoothSocket(@NonNull BluetoothDevice device, int type, boolean auth, boolean encrypt, int port, ParcelUuid uuid, boolean pitm, boolean min16DigitPin, int dataPath, @NonNull String socketName, long hubId, long endpointId, int maximumPacketSize) throws IOException {
        if (VDBG) {
            Log.d(TAG, "Creating new BluetoothSocket of type: " + type);
        }
        this.mSocketCreationTimeNanos = System_Delegate.nanoTime();
        if (type == 1 && uuid == null && port != -2 && (port < 1 || port > 30)) {
            throw new IOException("Invalid RFCOMM channel: " + port);
        }
        this.mUuid = uuid != null ? uuid : new ParcelUuid(new UUID(0L, 0L));
        this.mType = type;
        this.mAuth = auth;
        this.mAuthPitm = pitm;
        this.mMin16DigitPin = min16DigitPin;
        this.mEncrypt = encrypt;
        this.mDevice = device;
        this.mPort = port;
        this.mDataPath = dataPath;
        this.mSocketName = socketName;
        this.mHubId = hubId;
        this.mEndpointId = endpointId;
        this.mMaximumPacketSize = maximumPacketSize;
        this.mSocketState = SocketState.INIT;
        this.mAddress = device.getAddress();
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
        this.mSocketCreationLatencyNanos = System_Delegate.nanoTime() - this.mSocketCreationTimeNanos;
    }

    static BluetoothSocket createSocketFromOpenFd(ParcelFileDescriptor pfd, BluetoothDevice device, ParcelUuid uuid) throws IOException {
        BluetoothSocket bluetoothSocket = new BluetoothSocket(device, 1, true, true, -1, uuid);
        bluetoothSocket.mPfd = pfd;
        bluetoothSocket.mSocket = new LocalSocket(pfd.getFileDescriptor());
        bluetoothSocket.mSocketIS = bluetoothSocket.mSocket.getInputStream();
        bluetoothSocket.mSocketOS = bluetoothSocket.mSocket.getOutputStream();
        bluetoothSocket.mSocketState = SocketState.CONNECTED;
        return bluetoothSocket;
    }

    private BluetoothSocket(BluetoothSocket s) {
        if (VDBG) {
            Log.d(TAG, "Creating new Private BluetoothSocket of type: " + s.mType);
        }
        this.mUuid = s.mUuid;
        this.mType = s.mType;
        this.mAuth = s.mAuth;
        this.mEncrypt = s.mEncrypt;
        this.mPort = s.mPort;
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
        this.mMaxRxPacketSize = s.mMaxRxPacketSize;
        this.mMaxTxPacketSize = s.mMaxTxPacketSize;
        this.mConnectionUuid = s.mConnectionUuid;
        this.mSocketId = s.mSocketId;
        this.mServiceName = s.mServiceName;
        this.mExcludeSdp = s.mExcludeSdp;
        this.mAuthPitm = s.mAuthPitm;
        this.mMin16DigitPin = s.mMin16DigitPin;
        this.mDataPath = s.mDataPath;
        this.mSocketName = s.mSocketName;
        this.mHubId = s.mHubId;
        this.mEndpointId = s.mEndpointId;
        this.mMaximumPacketSize = s.mMaximumPacketSize;
        this.mSocketCreationTimeNanos = s.mSocketCreationTimeNanos;
        this.mSocketCreationLatencyNanos = s.mSocketCreationLatencyNanos;
    }

    private BluetoothSocket acceptSocket(String remoteAddr) throws IOException {
        BluetoothSocket as = new BluetoothSocket(this);
        as.mSocketState = SocketState.CONNECTED;
        Object[] fds = this.mSocket.getAncillaryFileDescriptors();
        if (DBG) {
            Log.d(TAG, "acceptSocket: socket fd passed by stack fds:" + Arrays.toString(fds));
        }
        if (fds == null || fds.length != 1) {
            Log.e(TAG, "socket fd passed from stack failed, fds: " + Arrays.toString(fds));
            as.close();
            throw new IOException("bt socket accept failed");
        }
        as.mPfd = ParcelFileDescriptor.dup((FileDescriptor)fds[0]);
        as.mSocket = new LocalSocket((FileDescriptor)fds[0]);
        as.mSocketIS = as.mSocket.getInputStream();
        as.mSocketOS = as.mSocket.getOutputStream();
        as.mAddress = remoteAddr;
        as.mDevice = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(remoteAddr);
        return as;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private int getSecurityFlags() {
        int flags = 0;
        if (this.mAuth) {
            flags |= 2;
        }
        if (this.mEncrypt) {
            flags |= 1;
        }
        if (this.mExcludeSdp) {
            flags |= 4;
        }
        if (this.mAuthPitm) {
            flags |= 8;
        }
        if (this.mMin16DigitPin) {
            flags |= 0x10;
        }
        return flags;
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteDevice() {
        return this.mDevice;
    }

    @RequiresNoPermission
    public InputStream getInputStream() throws IOException {
        return this.mInputStream;
    }

    @RequiresNoPermission
    public OutputStream getOutputStream() throws IOException {
        return this.mOutputStream;
    }

    @RequiresNoPermission
    public boolean isConnected() {
        return this.mSocketState == SocketState.CONNECTED;
    }

    void setServiceName(String name) {
        this.mServiceName = name;
    }

    boolean isAuth() {
        return this.mAuth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void connect() throws IOException {
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        long socketConnectionTimeNanos = System_Delegate.nanoTime();
        if (bluetoothProxy == null) {
            throw new BluetoothSocketException(15);
        }
        try {
            if (this.mDevice == null) {
                throw new BluetoothSocketException(19);
            }
            if (this.mSocketState == SocketState.CLOSED) {
                throw new BluetoothSocketException(17);
            }
            IBluetoothSocketManager socketManager = bluetoothProxy.getSocketManager();
            if (socketManager == null) {
                throw new BluetoothSocketException(16);
            }
            this.mPfd = Flags.socketSettingsApi() ? (this.mDataPath == 0 ? socketManager.connectSocket(this.mDevice, this.mType, this.mUuid, this.mPort, this.getSecurityFlags()) : socketManager.connectSocketWithOffload(this.mDevice, this.mType, this.mUuid, this.mPort, this.getSecurityFlags(), this.mDataPath, this.mSocketName, this.mHubId, this.mEndpointId, this.mMaximumPacketSize)) : socketManager.connectSocket(this.mDevice, this.mType, this.mUuid, this.mPort, this.getSecurityFlags());
            BluetoothSocket bluetoothSocket = this;
            synchronized (bluetoothSocket) {
                Log.i(TAG, "connect(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
                if (this.mSocketState == SocketState.CLOSED) {
                    throw new BluetoothSocketException(17);
                }
                if (this.mPfd == null) {
                    throw new BluetoothSocketException(21);
                }
                FileDescriptor fd = this.mPfd.getFileDescriptor();
                this.mSocket = new LocalSocket(fd);
                this.mSocketIS = this.mSocket.getInputStream();
                this.mSocketOS = this.mSocket.getOutputStream();
            }
            int channel = BluetoothSocket.readInt(this.mSocketIS);
            if (channel == 0) {
                int errCode = this.mSocketIS.read();
                throw new BluetoothSocketException(errCode);
            }
            if (channel < 0) {
                throw new BluetoothSocketException(18);
            }
            this.mPort = channel;
            this.waitSocketSignal(this.mSocketIS);
            BluetoothSocket bluetoothSocket2 = this;
            synchronized (bluetoothSocket2) {
                if (this.mSocketState == SocketState.CLOSED) {
                    throw new BluetoothSocketException(17);
                }
                this.mSocketState = SocketState.CONNECTED;
                Log.i(TAG, "connect(), socket connected. mPort=" + this.mPort);
            }
        }
        catch (BluetoothSocketException e) {
            SocketMetrics.logSocketConnect(e.getErrorCode(), socketConnectionTimeNanos, this.mType, this.mDevice, this.mPort, this.mAuth, this.mSocketCreationTimeNanos, this.mSocketCreationLatencyNanos);
            throw e;
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            SocketMetrics.logSocketConnect(20, socketConnectionTimeNanos, this.mType, this.mDevice, this.mPort, this.mAuth, this.mSocketCreationTimeNanos, this.mSocketCreationLatencyNanos);
            throw new BluetoothSocketException(20, "unable to send RPC: " + e.getMessage());
        }
        SocketMetrics.logSocketConnect(-1, socketConnectionTimeNanos, this.mType, this.mDevice, this.mPort, this.mAuth, this.mSocketCreationTimeNanos, this.mSocketCreationLatencyNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    int bindListen() {
        int ret;
        if (this.mSocketState == SocketState.CLOSED) {
            return 77;
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            Log.e(TAG, "bindListen fail, reason: bluetooth is off");
            return -1;
        }
        try {
            IBluetoothSocketManager socketManager;
            if (DBG) {
                Log.d(TAG, "bindListen(): mPort=" + this.mPort + ", mType=" + this.mType);
            }
            if ((socketManager = bluetoothProxy.getSocketManager()) == null) {
                Log.e(TAG, "bindListen() bt get socket manager failed");
                return -1;
            }
            this.mPfd = socketManager.createSocketChannel(this.mType, this.mServiceName, this.mUuid, this.mPort, this.getSecurityFlags());
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return -1;
        }
        try {
            Object fd;
            BluetoothSocket e = this;
            synchronized (e) {
                if (DBG) {
                    Log.d(TAG, "bindListen(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
                }
                if (this.mSocketState != SocketState.INIT) {
                    return 77;
                }
                if (this.mPfd == null) {
                    return -1;
                }
                fd = this.mPfd.getFileDescriptor();
                if (fd == null) {
                    Log.e(TAG, "bindListen(), null file descriptor");
                    return -1;
                }
                if (DBG) {
                    Log.d(TAG, "bindListen(), Create LocalSocket");
                }
                this.mSocket = new LocalSocket((FileDescriptor)fd);
                if (DBG) {
                    Log.d(TAG, "bindListen(), new LocalSocket.getInputStream()");
                }
                this.mSocketIS = this.mSocket.getInputStream();
                this.mSocketOS = this.mSocket.getOutputStream();
            }
            if (DBG) {
                Log.d(TAG, "bindListen(), readInt mSocketIS: " + this.mSocketIS);
            }
            int channel = BluetoothSocket.readInt(this.mSocketIS);
            fd = this;
            synchronized (fd) {
                if (this.mSocketState == SocketState.INIT) {
                    this.mSocketState = SocketState.LISTENING;
                }
            }
            if (DBG) {
                Log.d(TAG, "bindListen(): channel=" + channel + ", mPort=" + this.mPort);
            }
            if (this.mPort <= -1) {
                this.mPort = channel;
            }
            ret = 0;
        }
        catch (IOException e) {
            if (this.mPfd != null) {
                try {
                    this.mPfd.close();
                }
                catch (IOException e1) {
                    Log.e(TAG, "bindListen, close mPfd: " + e1);
                }
                this.mPfd = null;
            }
            Log.e(TAG, "bindListen, fail to get port number, exception: " + e);
            return -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    int bindListenWithOffload() {
        int ret;
        if (this.mSocketState == SocketState.CLOSED) {
            return 77;
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            Log.e(TAG, "bindListenWithOffload() fail, reason: bluetooth is off");
            return -1;
        }
        try {
            IBluetoothSocketManager socketManager;
            if (DBG) {
                Log.d(TAG, "bindListenWithOffload(): mPort=" + this.mPort + ", mType=" + this.mType);
            }
            if ((socketManager = bluetoothProxy.getSocketManager()) == null) {
                Log.e(TAG, "bindListenWithOffload() bt get socket manager failed");
                return -1;
            }
            this.mPfd = socketManager.createSocketChannelWithOffload(this.mType, this.mServiceName, this.mUuid, this.mPort, this.getSecurityFlags(), this.mDataPath, this.mSocketName, this.mHubId, this.mEndpointId, this.mMaximumPacketSize);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return -1;
        }
        try {
            Object fd;
            BluetoothSocket e = this;
            synchronized (e) {
                if (DBG) {
                    Log.d(TAG, "bindListenWithOffload(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
                }
                if (this.mSocketState != SocketState.INIT) {
                    return 77;
                }
                if (this.mPfd == null) {
                    return -1;
                }
                fd = this.mPfd.getFileDescriptor();
                if (fd == null) {
                    Log.e(TAG, "bindListenWithOffload(), null file descriptor");
                    return -1;
                }
                if (DBG) {
                    Log.d(TAG, "bindListenWithOffload(), Create LocalSocket");
                }
                this.mSocket = new LocalSocket((FileDescriptor)fd);
                if (DBG) {
                    Log.d(TAG, "bindListenWithOffload(), new LocalSocket.getInputStream()");
                }
                this.mSocketIS = this.mSocket.getInputStream();
                this.mSocketOS = this.mSocket.getOutputStream();
            }
            if (DBG) {
                Log.d(TAG, "bindListenWithOffload(), readInt mSocketIS: " + this.mSocketIS);
            }
            int channel = BluetoothSocket.readInt(this.mSocketIS);
            fd = this;
            synchronized (fd) {
                if (this.mSocketState == SocketState.INIT) {
                    this.mSocketState = SocketState.LISTENING;
                }
            }
            if (DBG) {
                Log.d(TAG, "bindListenWithOffload(): channel=" + channel + ", mPort=" + this.mPort);
            }
            if (this.mPort <= -1) {
                this.mPort = channel;
            }
            ret = 0;
        }
        catch (IOException e) {
            if (this.mPfd != null) {
                try {
                    this.mPfd.close();
                }
                catch (IOException e1) {
                    Log.e(TAG, "bindListenWithOffload, close mPfd: " + e1);
                }
                this.mPfd = null;
            }
            Log.e(TAG, "bindListenWithOffload, fail to get port number, exception: " + e);
            return -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BluetoothSocket accept(int timeout) throws IOException {
        BluetoothSocket acceptedSocket;
        String RemoteAddr;
        if (this.mSocketState != SocketState.LISTENING) {
            throw new IOException("bt socket is not in listen state");
        }
        Log.d(TAG, "accept(), timeout (ms):" + timeout);
        if (timeout > 0) {
            this.mSocket.setSoTimeout(timeout);
        }
        this.sendSocketAcceptSignal(this.mSocketOS, true);
        try {
            RemoteAddr = this.waitSocketSignal(this.mSocketIS);
        }
        finally {
            this.sendSocketAcceptSignal(this.mSocketOS, false);
        }
        if (timeout > 0) {
            this.mSocket.setSoTimeout(0);
        }
        BluetoothSocket bluetoothSocket = this;
        synchronized (bluetoothSocket) {
            if (this.mSocketState != SocketState.LISTENING) {
                throw new IOException("bt socket is not in listen state");
            }
            acceptedSocket = this.acceptSocket(RemoteAddr);
        }
        return acceptedSocket;
    }

    int available() throws IOException {
        if (!Flags.fixLecocSocketAvailable()) {
            int socketAvailable = this.mSocketIS.available();
            if (VDBG) {
                Log.d(TAG, "available returns: mSocketIS.available=" + socketAvailable);
            }
            return socketAvailable;
        }
        if (this.mSocketState == SocketState.CLOSED) {
            Log.e(TAG, "available called on closed socket!");
            return 0;
        }
        int available = this.mSocketIS.available();
        if ((this.mType == 3 || this.mType == 4) && this.mL2capBuffer != null && this.mL2capBuffer.remaining() > 0) {
            available = this.mL2capBuffer.remaining();
            if (VDBG) {
                Log.d(TAG, "available returns: mL2capBuffer.remaining=" + available);
            }
        } else if (VDBG) {
            Log.d(TAG, "available returns: mSocketIS.available=" + available);
        }
        return available;
    }

    int read(byte[] b, int offset, int length) throws IOException {
        int ret = 0;
        if (VDBG) {
            Log.d(TAG, "read in:  " + this.mSocketIS + " len: " + length);
        }
        if (this.mType == 3 || this.mType == 4) {
            int bytesToRead = length;
            if (VDBG) {
                Log.v(TAG, "l2cap: read(): offset: " + offset + " length:" + length + "mL2capBuffer= " + this.mL2capBuffer);
            }
            if (this.mL2capBuffer == null) {
                this.createL2capRxBuffer();
            }
            if (this.mL2capBuffer.remaining() == 0) {
                if (VDBG) {
                    Log.v(TAG, "l2cap buffer empty, refilling...");
                }
                if (this.fillL2capRxBuffer() == -1) {
                    Log.d(TAG, "socket EOF, returning -1");
                    this.mSocketState = SocketState.CLOSED;
                    return -1;
                }
            }
            if (bytesToRead > this.mL2capBuffer.remaining()) {
                bytesToRead = this.mL2capBuffer.remaining();
            }
            if (VDBG) {
                Log.v(TAG, "get(): offset: " + offset + " bytesToRead: " + bytesToRead);
            }
            this.mL2capBuffer.get(b, offset, bytesToRead);
            ret = bytesToRead;
        } else {
            if (VDBG) {
                Log.v(TAG, "default: read(): offset: " + offset + " length:" + length);
            }
            ret = this.mSocketIS.read(b, offset, length);
        }
        if (ret < 0) {
            this.mSocketState = SocketState.CLOSED;
            throw new IOException("bt socket closed, read return: " + ret);
        }
        if (VDBG) {
            Log.d(TAG, "read out:  " + this.mSocketIS + " ret: " + ret);
        }
        return ret;
    }

    int write(byte[] b, int offset, int length) throws IOException {
        if (VDBG) {
            Log.d(TAG, "write: " + this.mSocketOS + " length: " + length);
        }
        if (this.mType == 3 || this.mType == 4) {
            if (length <= this.mMaxTxPacketSize) {
                this.mSocketOS.write(b, offset, length);
            } else {
                int tmpLength;
                if (DBG) {
                    Log.w(TAG, "WARNING: Write buffer larger than L2CAP packet size!\nPacket will be divided into SDU packets of size " + this.mMaxTxPacketSize);
                }
                int tmpOffset = offset;
                for (int bytesToWrite = length; bytesToWrite > 0; bytesToWrite -= tmpLength) {
                    tmpLength = bytesToWrite > this.mMaxTxPacketSize ? this.mMaxTxPacketSize : bytesToWrite;
                    this.mSocketOS.write(b, tmpOffset, tmpLength);
                    tmpOffset += tmpLength;
                }
            }
        } else {
            this.mSocketOS.write(b, offset, length);
        }
        if (VDBG) {
            Log.d(TAG, "write out: " + this.mSocketOS + " length: " + length);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Log.d(TAG, "close() this: " + this + ", channel: " + this.mPort + ", mSocketIS: " + this.mSocketIS + ", mSocketOS: " + this.mSocketOS + ", mSocket: " + this.mSocket + ", mSocketState: " + (Object)((Object)this.mSocketState));
        if (this.mSocketState == SocketState.CLOSED) {
            return;
        }
        BluetoothSocket bluetoothSocket = this;
        synchronized (bluetoothSocket) {
            if (this.mSocketState == SocketState.CLOSED) {
                return;
            }
            this.mSocketState = SocketState.CLOSED;
            if (this.mSocket != null) {
                if (DBG) {
                    Log.d(TAG, "Closing mSocket: " + this.mSocket);
                }
                this.mSocket.shutdownInput();
                this.mSocket.shutdownOutput();
                this.mSocket.close();
                this.mSocket = null;
            }
            if (this.mPfd != null) {
                this.mPfd.close();
                this.mPfd = null;
            }
            this.mConnectionUuid = null;
            this.mSocketId = 0L;
        }
    }

    void removeChannel() {
    }

    int getPort() {
        return this.mPort;
    }

    long getSocketCreationTime() {
        return this.mSocketCreationTimeNanos;
    }

    @RequiresNoPermission
    public int getMaxTransmitPacketSize() {
        return this.mMaxTxPacketSize;
    }

    @RequiresNoPermission
    public int getMaxReceivePacketSize() {
        return this.mMaxRxPacketSize;
    }

    @RequiresNoPermission
    public int getConnectionType() {
        if (this.mType == 4) {
            return 3;
        }
        return this.mType;
    }

    @RequiresNoPermission
    public void setExcludeSdp(boolean excludeSdp) {
        this.mExcludeSdp = excludeSdp;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void requestMaximumTxDataLength() throws IOException {
        if (this.mDevice == null) {
            throw new IOException("requestMaximumTxDataLength is called on null device");
        }
        try {
            IBluetoothSocketManager socketManager;
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
            if (bluetoothProxy == null) {
                throw new IOException("Bluetooth is off");
            }
            if (DBG) {
                Log.d(TAG, "requestMaximumTxDataLength");
            }
            if ((socketManager = bluetoothProxy.getSocketManager()) == null) {
                throw new IOException("bt get socket manager failed");
            }
            socketManager.requestMaximumTxDataLength(this.mDevice);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            throw new IOException("unable to send RPC: " + e.getMessage());
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.bt_socket_api_l2cap_cid")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getL2capLocalChannelId() throws IOException {
        int cid;
        if (this.mType != 4) {
            throw new BluetoothSocketException(1);
        }
        if (this.mSocketState != SocketState.CONNECTED || this.mConnectionUuid == null) {
            throw new BluetoothSocketException(17);
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            throw new BluetoothSocketException(15);
        }
        try {
            IBluetoothSocketManager socketManager = bluetoothProxy.getSocketManager();
            if (socketManager == null) {
                throw new BluetoothSocketException(16);
            }
            cid = socketManager.getL2capLocalChannelId(this.mConnectionUuid, AttributionSource.myAttributionSource());
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            throw new IOException("unable to send RPC: " + e.getMessage());
        }
        if (cid == -1) {
            throw new BluetoothSocketException(17);
        }
        return cid;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.bt_socket_api_l2cap_cid")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getL2capRemoteChannelId() throws IOException {
        int cid;
        if (this.mType != 4) {
            throw new BluetoothSocketException(1);
        }
        if (this.mSocketState != SocketState.CONNECTED || this.mConnectionUuid == null) {
            throw new BluetoothSocketException(17);
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            throw new BluetoothSocketException(15);
        }
        try {
            IBluetoothSocketManager socketManager = bluetoothProxy.getSocketManager();
            if (socketManager == null) {
                throw new BluetoothSocketException(16);
            }
            cid = socketManager.getL2capRemoteChannelId(this.mConnectionUuid, AttributionSource.myAttributionSource());
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            throw new IOException("unable to send RPC: " + e.getMessage());
        }
        if (cid == -1) {
            throw new BluetoothSocketException(17);
        }
        return cid;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
    @RequiresNoPermission
    public long getSocketId() throws IOException {
        if (this.mSocketState != SocketState.CONNECTED || this.mSocketId == 0L) {
            throw new BluetoothSocketException(17);
        }
        return this.mSocketId;
    }

    @RequiresNoPermission
    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.mPfd;
    }

    private static String convertAddr(byte[] addr) {
        return String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);
    }

    private void sendSocketAcceptSignal(OutputStream os, boolean isAccepting) throws IOException {
        if (Flags.socketSettingsApi()) {
            if (this.mDataPath == 0) {
                return;
            }
            Log.d(TAG, "sendSocketAcceptSignal isAccepting " + isAccepting);
            byte[] sig = new byte[4];
            ByteBuffer bb = ByteBuffer.wrap(sig);
            bb.order(ByteOrder.nativeOrder());
            bb.putShort((short)4);
            bb.putShort((short)(isAccepting ? 1 : 0));
            os.write(sig, 0, 4);
        }
    }

    private String waitSocketSignal(InputStream is) throws IOException {
        byte[] sig = new byte[44];
        int ret = BluetoothSocket.readAll(is, sig);
        if (VDBG) {
            Log.d(TAG, "waitSocketSignal read 44 bytes signal ret: " + ret);
        }
        ByteBuffer bb = ByteBuffer.wrap(sig);
        bb.order(ByteOrder.nativeOrder());
        short size = bb.getShort();
        if (size != 44) {
            throw new IOException("Connection failure, wrong signal size: " + size);
        }
        byte[] addr = new byte[6];
        bb.get(addr);
        int channel = bb.getInt();
        int status = bb.getInt();
        this.mMaxTxPacketSize = bb.getShort() & 0xFFFF;
        this.mMaxRxPacketSize = bb.getShort() & 0xFFFF;
        long uuidLsb = bb.getLong();
        long uuidMsb = bb.getLong();
        this.mConnectionUuid = new ParcelUuid(new UUID(uuidMsb, uuidLsb));
        this.mSocketId = bb.getLong();
        String RemoteAddr = BluetoothSocket.convertAddr(addr);
        if (VDBG) {
            Log.d(TAG, "waitSocketSignal: sig size: " + size + ", remote addr: " + RemoteAddr + ", channel: " + channel + ", status: " + status + " MaxRxPktSize: " + this.mMaxRxPacketSize + " MaxTxPktSize: " + this.mMaxTxPacketSize + " mConnectionUuid: " + ((Object)this.mConnectionUuid).toString() + " mSocketId: " + this.mSocketId);
        }
        if (status != 0) {
            throw new IOException("Connection failure, status: " + status);
        }
        return RemoteAddr;
    }

    private void createL2capRxBuffer() {
        if (this.mType == 3 || this.mType == 4) {
            if (VDBG) {
                Log.v(TAG, "  Creating mL2capBuffer: mMaxPacketSize: " + this.mMaxRxPacketSize);
            }
            this.mL2capBuffer = ByteBuffer.wrap(new byte[this.mMaxRxPacketSize]);
            if (VDBG) {
                Log.v(TAG, "mL2capBuffer.remaining()" + this.mL2capBuffer.remaining());
            }
            this.mL2capBuffer.limit(0);
            if (VDBG) {
                Log.v(TAG, "mL2capBuffer.remaining() after limit(0):" + this.mL2capBuffer.remaining());
            }
        }
    }

    private static int readAll(InputStream is, byte[] b) throws IOException {
        int left = b.length;
        while (left > 0) {
            int ret = is.read(b, b.length - left, left);
            if (ret <= 0) {
                throw new IOException("read failed, socket might closed or timeout, read ret: " + ret);
            }
            if ((left -= ret) == 0) continue;
            Log.w(TAG, "readAll() looping, read partial size: " + (b.length - left) + ", expect size: " + b.length);
        }
        return b.length;
    }

    private static int readInt(InputStream is) throws IOException {
        byte[] ibytes = new byte[4];
        int ret = BluetoothSocket.readAll(is, ibytes);
        if (VDBG) {
            Log.d(TAG, "inputStream.read ret: " + ret);
        }
        ByteBuffer bb = ByteBuffer.wrap(ibytes);
        bb.order(ByteOrder.nativeOrder());
        return bb.getInt();
    }

    private int fillL2capRxBuffer() throws IOException {
        this.mL2capBuffer.rewind();
        int ret = this.mSocketIS.read(this.mL2capBuffer.array());
        if (ret == -1) {
            this.mL2capBuffer.limit(0);
            return -1;
        }
        this.mL2capBuffer.limit(ret);
        return ret;
    }

    public String toString() {
        return BluetoothUtils.toAnonymizedAddress(this.mAddress);
    }

    private static enum SocketState {
        INIT,
        CONNECTED,
        LISTENING,
        CLOSED;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SocketType {
    }
}

