/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BluetoothGattCharacteristic
implements Parcelable {
    public static final int PROPERTY_BROADCAST = 1;
    public static final int PROPERTY_READ = 2;
    public static final int PROPERTY_WRITE_NO_RESPONSE = 4;
    public static final int PROPERTY_WRITE = 8;
    public static final int PROPERTY_NOTIFY = 16;
    public static final int PROPERTY_INDICATE = 32;
    public static final int PROPERTY_SIGNED_WRITE = 64;
    public static final int PROPERTY_EXTENDED_PROPS = 128;
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_READ_ENCRYPTED = 2;
    public static final int PERMISSION_READ_ENCRYPTED_MITM = 4;
    public static final int PERMISSION_WRITE = 16;
    public static final int PERMISSION_WRITE_ENCRYPTED = 32;
    public static final int PERMISSION_WRITE_ENCRYPTED_MITM = 64;
    public static final int PERMISSION_WRITE_SIGNED = 128;
    public static final int PERMISSION_WRITE_SIGNED_MITM = 256;
    public static final int WRITE_TYPE_DEFAULT = 2;
    public static final int WRITE_TYPE_NO_RESPONSE = 1;
    public static final int WRITE_TYPE_SIGNED = 4;
    public static final int FORMAT_UINT8 = 17;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_FLOAT = 52;
    protected UUID mUuid;
    @UnsupportedAppUsage
    protected int mInstance;
    protected int mProperties;
    protected int mPermissions;
    protected int mKeySize = 16;
    protected int mWriteType;
    @UnsupportedAppUsage
    protected BluetoothGattService mService;
    protected byte[] mValue;
    protected List<BluetoothGattDescriptor> mDescriptors;
    @NonNull
    public static final Parcelable.Creator<BluetoothGattCharacteristic> CREATOR = new Parcelable.Creator<BluetoothGattCharacteristic>(){

        @Override
        public BluetoothGattCharacteristic createFromParcel(Parcel in) {
            return new BluetoothGattCharacteristic(in);
        }

        public BluetoothGattCharacteristic[] newArray(int size) {
            return new BluetoothGattCharacteristic[size];
        }
    };

    public BluetoothGattCharacteristic(UUID uuid, int properties, int permissions) {
        this.initCharacteristic(null, uuid, 0, properties, permissions);
    }

    BluetoothGattCharacteristic(BluetoothGattService service, UUID uuid, int instanceId, int properties, int permissions) {
        this.initCharacteristic(service, uuid, instanceId, properties, permissions);
    }

    public BluetoothGattCharacteristic(UUID uuid, int instanceId, int properties, int permissions) {
        this.initCharacteristic(null, uuid, instanceId, properties, permissions);
    }

    private void initCharacteristic(BluetoothGattService service, UUID uuid, int instanceId, int properties, int permissions) {
        this.mUuid = uuid;
        this.mInstance = instanceId;
        this.mProperties = properties;
        this.mPermissions = permissions;
        this.mService = service;
        this.mValue = null;
        this.mDescriptors = new ArrayList<BluetoothGattDescriptor>();
        this.mWriteType = (this.mProperties & 4) != 0 ? 1 : 2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        new ParcelUuid(this.mUuid).writeToParcel(out, flags);
        out.writeInt(this.mInstance);
        out.writeInt(this.mProperties);
        out.writeInt(this.mPermissions);
        out.writeInt(this.mKeySize);
        out.writeInt(this.mWriteType);
        out.writeTypedList(this.mDescriptors);
    }

    private BluetoothGattCharacteristic(Parcel in) {
        this.mUuid = ParcelUuid.CREATOR.createFromParcel(in).getUuid();
        this.mInstance = in.readInt();
        this.mProperties = in.readInt();
        this.mPermissions = in.readInt();
        this.mKeySize = in.readInt();
        this.mWriteType = in.readInt();
        this.mDescriptors = in.createTypedArrayList(BluetoothGattDescriptor.CREATOR);
        for (BluetoothGattDescriptor desc : this.mDescriptors) {
            desc.setCharacteristic(this);
        }
    }

    public int getKeySize() {
        return this.mKeySize;
    }

    public boolean addDescriptor(BluetoothGattDescriptor descriptor) {
        this.mDescriptors.add(descriptor);
        descriptor.setCharacteristic(this);
        return true;
    }

    BluetoothGattDescriptor getDescriptor(UUID uuid, int instanceId) {
        for (BluetoothGattDescriptor descriptor : this.mDescriptors) {
            if (!((Object)descriptor.getUuid()).equals(uuid) || descriptor.getInstanceId() != instanceId) continue;
            return descriptor;
        }
        return null;
    }

    public BluetoothGattService getService() {
        return this.mService;
    }

    @UnsupportedAppUsage
    void setService(BluetoothGattService service) {
        this.mService = service;
    }

    public UUID getUuid() {
        return this.mUuid;
    }

    public int getInstanceId() {
        return this.mInstance;
    }

    public void setInstanceId(int instanceId) {
        this.mInstance = instanceId;
    }

    public int getProperties() {
        return this.mProperties;
    }

    public int getPermissions() {
        return this.mPermissions;
    }

    public int getWriteType() {
        return this.mWriteType;
    }

    public void setWriteType(int writeType) {
        this.mWriteType = writeType;
    }

    @UnsupportedAppUsage
    public void setKeySize(int keySize) {
        this.mKeySize = keySize;
    }

    public List<BluetoothGattDescriptor> getDescriptors() {
        return this.mDescriptors;
    }

    public BluetoothGattDescriptor getDescriptor(UUID uuid) {
        for (BluetoothGattDescriptor descriptor : this.mDescriptors) {
            if (!((Object)descriptor.getUuid()).equals(uuid)) continue;
            return descriptor;
        }
        return null;
    }

    @Deprecated
    public byte[] getValue() {
        return this.mValue;
    }

    @Deprecated
    public Integer getIntValue(int formatType, int offset) {
        Integer n;
        if (offset + BluetoothGattCharacteristic.getTypeLen(formatType) > this.mValue.length) {
            return null;
        }
        switch (formatType) {
            case 17: {
                n = BluetoothGattCharacteristic.unsignedByteToInt(this.mValue[offset]);
                break;
            }
            case 18: {
                n = BluetoothGattCharacteristic.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]);
                break;
            }
            case 20: {
                n = BluetoothGattCharacteristic.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]);
                break;
            }
            case 33: {
                n = BluetoothGattCharacteristic.unsignedToSigned(BluetoothGattCharacteristic.unsignedByteToInt(this.mValue[offset]), 8);
                break;
            }
            case 34: {
                n = BluetoothGattCharacteristic.unsignedToSigned(BluetoothGattCharacteristic.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]), 16);
                break;
            }
            case 36: {
                n = BluetoothGattCharacteristic.unsignedToSigned(BluetoothGattCharacteristic.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]), 32);
                break;
            }
            default: {
                n = null;
            }
        }
        return n;
    }

    @Deprecated
    public Float getFloatValue(int formatType, int offset) {
        Float f;
        if (offset + BluetoothGattCharacteristic.getTypeLen(formatType) > this.mValue.length) {
            return null;
        }
        switch (formatType) {
            case 50: {
                f = Float.valueOf(BluetoothGattCharacteristic.bytesToFloat(this.mValue[offset], this.mValue[offset + 1]));
                break;
            }
            case 52: {
                f = Float.valueOf(BluetoothGattCharacteristic.bytesToFloat(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]));
                break;
            }
            default: {
                f = null;
            }
        }
        return f;
    }

    @Deprecated
    public String getStringValue(int offset) {
        if (this.mValue == null || offset > this.mValue.length) {
            return null;
        }
        byte[] strBytes = new byte[this.mValue.length - offset];
        for (int i = 0; i != this.mValue.length - offset; ++i) {
            strBytes[i] = this.mValue[offset + i];
        }
        return new String(strBytes);
    }

    @Deprecated
    public boolean setValue(byte[] value) {
        this.mValue = value;
        return true;
    }

    @Deprecated
    public boolean setValue(int value, int formatType, int offset) {
        int len = offset + BluetoothGattCharacteristic.getTypeLen(formatType);
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        switch (formatType) {
            case 33: {
                value = BluetoothGattCharacteristic.intToSignedBits(value, 8);
            }
            case 17: {
                this.mValue[offset] = (byte)(value & 0xFF);
                break;
            }
            case 34: {
                value = BluetoothGattCharacteristic.intToSignedBits(value, 16);
            }
            case 18: {
                this.mValue[offset++] = (byte)(value & 0xFF);
                this.mValue[offset] = (byte)(value >> 8 & 0xFF);
                break;
            }
            case 36: {
                value = BluetoothGattCharacteristic.intToSignedBits(value, 32);
            }
            case 20: {
                this.mValue[offset++] = (byte)(value & 0xFF);
                this.mValue[offset++] = (byte)(value >> 8 & 0xFF);
                this.mValue[offset++] = (byte)(value >> 16 & 0xFF);
                this.mValue[offset] = (byte)(value >> 24 & 0xFF);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public boolean setValue(int mantissa, int exponent, int formatType, int offset) {
        int len = offset + BluetoothGattCharacteristic.getTypeLen(formatType);
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        switch (formatType) {
            case 50: {
                mantissa = BluetoothGattCharacteristic.intToSignedBits(mantissa, 12);
                exponent = BluetoothGattCharacteristic.intToSignedBits(exponent, 4);
                this.mValue[offset++] = (byte)(mantissa & 0xFF);
                this.mValue[offset] = (byte)(mantissa >> 8 & 0xF);
                int n = offset;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)((exponent & 0xF) << 4));
                break;
            }
            case 52: {
                mantissa = BluetoothGattCharacteristic.intToSignedBits(mantissa, 24);
                exponent = BluetoothGattCharacteristic.intToSignedBits(exponent, 8);
                this.mValue[offset++] = (byte)(mantissa & 0xFF);
                this.mValue[offset++] = (byte)(mantissa >> 8 & 0xFF);
                this.mValue[offset++] = (byte)(mantissa >> 16 & 0xFF);
                int n = offset;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)(exponent & 0xFF));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public boolean setValue(String value) {
        this.mValue = value.getBytes();
        return true;
    }

    private static int getTypeLen(int formatType) {
        return formatType & 0xF;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private static int unsignedBytesToInt(byte b0, byte b1) {
        return BluetoothGattCharacteristic.unsignedByteToInt(b0) + (BluetoothGattCharacteristic.unsignedByteToInt(b1) << 8);
    }

    private static int unsignedBytesToInt(byte b0, byte b1, byte b2, byte b3) {
        return BluetoothGattCharacteristic.unsignedByteToInt(b0) + (BluetoothGattCharacteristic.unsignedByteToInt(b1) << 8) + (BluetoothGattCharacteristic.unsignedByteToInt(b2) << 16) + (BluetoothGattCharacteristic.unsignedByteToInt(b3) << 24);
    }

    private static float bytesToFloat(byte b0, byte b1) {
        int mantissa = BluetoothGattCharacteristic.unsignedToSigned(BluetoothGattCharacteristic.unsignedByteToInt(b0) + ((BluetoothGattCharacteristic.unsignedByteToInt(b1) & 0xF) << 8), 12);
        int exponent = BluetoothGattCharacteristic.unsignedToSigned(BluetoothGattCharacteristic.unsignedByteToInt(b1) >> 4, 4);
        return (float)((double)mantissa * Math.pow(10.0, exponent));
    }

    private static float bytesToFloat(byte b0, byte b1, byte b2, byte b3) {
        int mantissa = BluetoothGattCharacteristic.unsignedToSigned(BluetoothGattCharacteristic.unsignedByteToInt(b0) + (BluetoothGattCharacteristic.unsignedByteToInt(b1) << 8) + (BluetoothGattCharacteristic.unsignedByteToInt(b2) << 16), 24);
        return (float)((double)mantissa * Math.pow(10.0, b3));
    }

    private static int unsignedToSigned(int unsigned, int size) {
        if ((unsigned & 1 << size - 1) != 0) {
            unsigned = -1 * ((1 << size - 1) - (unsigned & (1 << size - 1) - 1));
        }
        return unsigned;
    }

    private static int intToSignedBits(int i, int size) {
        if (i < 0) {
            i = (1 << size - 1) + (i & (1 << size - 1) - 1);
        }
        return i;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WriteType {
    }
}

