/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothCodecConfig;
import android.bluetooth.BluetoothUtils;
import android.os.Parcel;
import android.os.Parcelable;

public class BluetoothCodecType
implements Parcelable {
    private final int mNativeCodecType;
    private final long mCodecId;
    @NonNull
    private final String mCodecName;
    public static final long CODEC_ID_SBC = 0L;
    public static final long CODEC_ID_AAC = 2L;
    public static final long CODEC_ID_APTX = 16797695L;
    public static final long CODEC_ID_APTX_HD = 604035071L;
    public static final long CODEC_ID_LDAC = -1442763265L;
    public static final long CODEC_ID_OPUS = 16834815L;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.a2dp_lhdc_api")
    public static final long CODEC_ID_LHDCV5 = 327307049727L;
    @NonNull
    public static final Parcelable.Creator<BluetoothCodecType> CREATOR = new Parcelable.Creator<BluetoothCodecType>(){

        @Override
        public BluetoothCodecType createFromParcel(Parcel in) {
            return new BluetoothCodecType(in);
        }

        public BluetoothCodecType[] newArray(int size) {
            return new BluetoothCodecType[size];
        }
    };

    private BluetoothCodecType(Parcel in) {
        this.mNativeCodecType = in.readInt();
        this.mCodecId = in.readLong() & 0xFFFFFFFFL;
        this.mCodecName = in.readString();
    }

    private BluetoothCodecType(int codecType, long codecId) {
        this.mNativeCodecType = codecType;
        this.mCodecId = codecId & 0xFFFFFFFFL;
        this.mCodecName = BluetoothCodecConfig.getCodecName(codecType);
    }

    @SystemApi
    public BluetoothCodecType(int codecType, long codecId, @NonNull String codecName) {
        this.mNativeCodecType = codecType;
        this.mCodecId = codecId & 0xFFFFFFFFL;
        this.mCodecName = codecName;
    }

    public boolean isMandatoryCodec() {
        return this.mNativeCodecType == 0;
    }

    public long getCodecId() {
        return this.mCodecId;
    }

    @NonNull
    public String getCodecName() {
        return this.mCodecName;
    }

    public int getNativeCodecType() {
        return this.mNativeCodecType;
    }

    public String toString() {
        return this.mCodecName;
    }

    public int hashCode() {
        return Long.hashCode(this.mCodecId);
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof BluetoothCodecType) {
            BluetoothCodecType other = (BluetoothCodecType)o;
            return other.mCodecId == this.mCodecId;
        }
        return false;
    }

    @NonNull
    public static BluetoothCodecType createFromParcel(Parcel in) {
        return new BluetoothCodecType(in);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mNativeCodecType);
        dest.writeLong(this.mCodecId);
        BluetoothUtils.writeStringToParcel(dest, this.mCodecName);
    }

    @SystemApi
    @Nullable
    public static BluetoothCodecType createFromType(int codecType) {
        long codecId;
        switch (codecType) {
            case 0: {
                long l = 0L;
                break;
            }
            case 1: {
                long l = 2L;
                break;
            }
            case 2: {
                long l = 16797695L;
                break;
            }
            case 3: {
                long l = 604035071L;
                break;
            }
            case 4: {
                long l = -1442763265L;
                break;
            }
            case 6: {
                long l = 16834815L;
                break;
            }
            case 5: 
            case 1000000: {
                long l = -1L;
                break;
            }
            default: {
                long l = codecId = -1L;
            }
        }
        if (codecId == -1L) {
            return null;
        }
        return new BluetoothCodecType(codecType, codecId);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

