/*
 * Decompiled with CFR 0.152.
 */
package android.apphibernation;

import android.annotation.RequiresPermission;
import android.apphibernation.HibernationStats;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public interface IAppHibernationService
extends IInterface {
    public static final String DESCRIPTOR = "android.apphibernation.IAppHibernationService";

    public boolean isHibernatingForUser(String var1, int var2) throws RemoteException;

    public void setHibernatingForUser(String var1, int var2, boolean var3) throws RemoteException;

    public boolean isHibernatingGlobally(String var1) throws RemoteException;

    public void setHibernatingGlobally(String var1, boolean var2) throws RemoteException;

    public List<String> getHibernatingPackagesForUser(int var1) throws RemoteException;

    public Map<String, HibernationStats> getHibernationStatsForUser(List<String> var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    public boolean isOatArtifactDeletionEnabled() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAppHibernationService {
        static final int TRANSACTION_isHibernatingForUser = 1;
        static final int TRANSACTION_setHibernatingForUser = 2;
        static final int TRANSACTION_isHibernatingGlobally = 3;
        static final int TRANSACTION_setHibernatingGlobally = 4;
        static final int TRANSACTION_getHibernatingPackagesForUser = 5;
        static final int TRANSACTION_getHibernationStatsForUser = 6;
        static final int TRANSACTION_isOatArtifactDeletionEnabled = 7;

        public Stub() {
            this.attachInterface(this, IAppHibernationService.DESCRIPTOR);
        }

        public static IAppHibernationService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAppHibernationService.DESCRIPTOR);
            if (iin != null && iin instanceof IAppHibernationService) {
                return (IAppHibernationService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isHibernatingForUser";
                }
                case 2: {
                    return "setHibernatingForUser";
                }
                case 3: {
                    return "isHibernatingGlobally";
                }
                case 4: {
                    return "setHibernatingGlobally";
                }
                case 5: {
                    return "getHibernatingPackagesForUser";
                }
                case 6: {
                    return "getHibernationStatsForUser";
                }
                case 7: {
                    return "isOatArtifactDeletionEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAppHibernationService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHibernatingForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHibernatingForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHibernatingGlobally(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHibernatingGlobally(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getHibernatingPackagesForUser(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 6: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    Map<String, HibernationStats> _result = this.getHibernationStatsForUser(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result == null) {
                        reply.writeInt(-1);
                        break;
                    }
                    reply.writeInt(_result.size());
                    _result.forEach((k, v) -> {
                        reply.writeString((String)k);
                        reply.writeTypedObject(v, 1);
                    });
                    break;
                }
                case 7: {
                    boolean _result = this.isOatArtifactDeletionEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IAppHibernationService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAppHibernationService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHibernatingForUser(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHibernatingForUser(String packageName, int userId, boolean isHibernating) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeBoolean(isHibernating);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHibernatingGlobally(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHibernatingGlobally(String packageName, boolean isHibernating) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(isHibernating);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getHibernatingPackagesForUser(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, HibernationStats> getHibernationStatsForUser(List<String> packageNames, int userId) throws RemoteException {
                HashMap<String, HibernationStats> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeStringList(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    int N2 = _reply.readInt();
                    _result = N2 < 0 ? null : new HashMap<String, HibernationStats>();
                    IntStream.range(0, N2).forEach(i -> {
                        String k = _reply.readString();
                        HibernationStats v = _reply.readTypedObject(HibernationStats.CREATOR);
                        _result.put(k, v);
                    });
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOatArtifactDeletionEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAppHibernationService {
        @Override
        public boolean isHibernatingForUser(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setHibernatingForUser(String packageName, int userId, boolean isHibernating) throws RemoteException {
        }

        @Override
        public boolean isHibernatingGlobally(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void setHibernatingGlobally(String packageName, boolean isHibernating) throws RemoteException {
        }

        @Override
        public List<String> getHibernatingPackagesForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public Map<String, HibernationStats> getHibernationStatsForUser(List<String> packageNames, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isOatArtifactDeletionEnabled() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

