/*
 * Decompiled with CFR 0.152.
 */
package android.app.wearable;

import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.app.wearable.IWearableSensingCallback;
import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.SharedMemory;

public interface IWearableSensingManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.wearable.IWearableSensingManager";

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public int getAvailableConnectionCount() throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideConnection(ParcelFileDescriptor var1, IWearableSensingCallback var2, RemoteCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public int provideConcurrentConnection(ParcelFileDescriptor var1, PersistableBundle var2, IWearableSensingCallback var3, RemoteCallback var4) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public boolean removeConnection(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void removeAllConnections() throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideReadOnlyParcelFileDescriptor(ParcelFileDescriptor var1, PersistableBundle var2, RemoteCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideDataStream(ParcelFileDescriptor var1, IWearableSensingCallback var2, RemoteCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideData(PersistableBundle var1, SharedMemory var2, RemoteCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void registerDataRequestObserver(int var1, PendingIntent var2, RemoteCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void unregisterDataRequestObserver(int var1, PendingIntent var2, RemoteCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void startHotwordRecognition(ComponentName var1, RemoteCallback var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void stopHotwordRecognition(RemoteCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWearableSensingManager {
        static final int TRANSACTION_getAvailableConnectionCount = 1;
        static final int TRANSACTION_provideConnection = 2;
        static final int TRANSACTION_provideConcurrentConnection = 3;
        static final int TRANSACTION_removeConnection = 4;
        static final int TRANSACTION_removeAllConnections = 5;
        static final int TRANSACTION_provideReadOnlyParcelFileDescriptor = 6;
        static final int TRANSACTION_provideDataStream = 7;
        static final int TRANSACTION_provideData = 8;
        static final int TRANSACTION_registerDataRequestObserver = 9;
        static final int TRANSACTION_unregisterDataRequestObserver = 10;
        static final int TRANSACTION_startHotwordRecognition = 11;
        static final int TRANSACTION_stopHotwordRecognition = 12;

        public Stub() {
            this.attachInterface(this, IWearableSensingManager.DESCRIPTOR);
        }

        public static IWearableSensingManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWearableSensingManager.DESCRIPTOR);
            if (iin != null && iin instanceof IWearableSensingManager) {
                return (IWearableSensingManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAvailableConnectionCount";
                }
                case 2: {
                    return "provideConnection";
                }
                case 3: {
                    return "provideConcurrentConnection";
                }
                case 4: {
                    return "removeConnection";
                }
                case 5: {
                    return "removeAllConnections";
                }
                case 6: {
                    return "provideReadOnlyParcelFileDescriptor";
                }
                case 7: {
                    return "provideDataStream";
                }
                case 8: {
                    return "provideData";
                }
                case 9: {
                    return "registerDataRequestObserver";
                }
                case 10: {
                    return "unregisterDataRequestObserver";
                }
                case 11: {
                    return "startHotwordRecognition";
                }
                case 12: {
                    return "stopHotwordRecognition";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWearableSensingManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _result = this.getAvailableConnectionCount();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    IWearableSensingCallback _arg1 = IWearableSensingCallback.Stub.asInterface(data.readStrongBinder());
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideConnection(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    IWearableSensingCallback _arg2 = IWearableSensingCallback.Stub.asInterface(data.readStrongBinder());
                    RemoteCallback _arg3 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.provideConcurrentConnection(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeConnection(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    this.removeAllConnections();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideReadOnlyParcelFileDescriptor(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    IWearableSensingCallback _arg1 = IWearableSensingCallback.Stub.asInterface(data.readStrongBinder());
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideDataStream(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    SharedMemory _arg1 = data.readTypedObject(SharedMemory.CREATOR);
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerDataRequestObserver(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterDataRequestObserver(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.startHotwordRecognition(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    RemoteCallback _arg0 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopHotwordRecognition(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IWearableSensingManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWearableSensingManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAvailableConnectionCount() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideConnection(ParcelFileDescriptor parcelFileDescriptor, IWearableSensingCallback wearableSensingCallback, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(parcelFileDescriptor, 0);
                    _data.writeStrongInterface(wearableSensingCallback);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int provideConcurrentConnection(ParcelFileDescriptor parcelFileDescriptor, PersistableBundle metadata, IWearableSensingCallback wearableSensingCallback, RemoteCallback statusCallback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(parcelFileDescriptor, 0);
                    _data.writeTypedObject(metadata, 0);
                    _data.writeStrongInterface(wearableSensingCallback);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeConnection(int connectionId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeInt(connectionId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAllConnections() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideReadOnlyParcelFileDescriptor(ParcelFileDescriptor parcelFileDescriptor, PersistableBundle metadata, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(parcelFileDescriptor, 0);
                    _data.writeTypedObject(metadata, 0);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideDataStream(ParcelFileDescriptor parcelFileDescriptor, IWearableSensingCallback wearableSensingCallback, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(parcelFileDescriptor, 0);
                    _data.writeStrongInterface(wearableSensingCallback);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideData(PersistableBundle data, SharedMemory sharedMemory, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(data, 0);
                    _data.writeTypedObject(sharedMemory, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDataRequestObserver(int dataType, PendingIntent dataRequestPendingIntent, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeInt(dataType);
                    _data.writeTypedObject(dataRequestPendingIntent, 0);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDataRequestObserver(int dataType, PendingIntent dataRequestPendingIntent, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeInt(dataType);
                    _data.writeTypedObject(dataRequestPendingIntent, 0);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startHotwordRecognition(ComponentName targetVisComponentName, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(targetVisComponentName, 0);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopHotwordRecognition(RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWearableSensingManager {
        @Override
        public int getAvailableConnectionCount() throws RemoteException {
            return 0;
        }

        @Override
        public void provideConnection(ParcelFileDescriptor parcelFileDescriptor, IWearableSensingCallback wearableSensingCallback, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public int provideConcurrentConnection(ParcelFileDescriptor parcelFileDescriptor, PersistableBundle metadata, IWearableSensingCallback wearableSensingCallback, RemoteCallback statusCallback) throws RemoteException {
            return 0;
        }

        @Override
        public boolean removeConnection(int connectionId) throws RemoteException {
            return false;
        }

        @Override
        public void removeAllConnections() throws RemoteException {
        }

        @Override
        public void provideReadOnlyParcelFileDescriptor(ParcelFileDescriptor parcelFileDescriptor, PersistableBundle metadata, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void provideDataStream(ParcelFileDescriptor parcelFileDescriptor, IWearableSensingCallback wearableSensingCallback, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void provideData(PersistableBundle data, SharedMemory sharedMemory, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void registerDataRequestObserver(int dataType, PendingIntent dataRequestPendingIntent, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void unregisterDataRequestObserver(int dataType, PendingIntent dataRequestPendingIntent, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void startHotwordRecognition(ComponentName targetVisComponentName, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void stopHotwordRecognition(RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

