/*
 * Decompiled with CFR 0.152.
 */
package android.app.wallpapereffectsgeneration;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.wallpapereffectsgeneration.CinematicEffectRequest;
import android.app.wallpapereffectsgeneration.CinematicEffectResponse;
import android.app.wallpapereffectsgeneration.ICinematicEffectListener;
import android.app.wallpapereffectsgeneration.IWallpaperEffectsGenerationManager;
import android.os.RemoteException;
import java.util.concurrent.Executor;

@SystemApi
public class WallpaperEffectsGenerationManager {
    private final IWallpaperEffectsGenerationManager mService;

    public WallpaperEffectsGenerationManager(@NonNull IWallpaperEffectsGenerationManager service) {
        this.mService = service;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WALLPAPER_EFFECTS_GENERATION")
    public void generateCinematicEffect(@NonNull CinematicEffectRequest request, @NonNull Executor executor, @NonNull CinematicEffectListener listener) {
        try {
            this.mService.generateCinematicEffect(request, new CinematicEffectListenerWrapper(listener, executor));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class CinematicEffectListenerWrapper
    extends ICinematicEffectListener.Stub {
        @NonNull
        private final CinematicEffectListener mListener;
        @NonNull
        private final Executor mExecutor;

        CinematicEffectListenerWrapper(@NonNull CinematicEffectListener listener, @NonNull Executor executor) {
            this.mListener = listener;
            this.mExecutor = executor;
        }

        @Override
        public void onCinematicEffectGenerated(CinematicEffectResponse response) {
            this.mExecutor.execute(() -> this.mListener.onCinematicEffectGenerated(response));
        }
    }

    public static interface CinematicEffectListener {
        public void onCinematicEffectGenerated(@NonNull CinematicEffectResponse var1);
    }
}

