/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ShellCommand;
import java.io.PrintWriter;
import java.util.Objects;

@SystemApi
public class UnixEpochTime
implements Parcelable {
    private final long mElapsedRealtimeMillis;
    private final long mUnixEpochTimeMillis;
    @NonNull
    public static final Parcelable.Creator<UnixEpochTime> CREATOR = new Parcelable.Creator<UnixEpochTime>(){

        @Override
        public UnixEpochTime createFromParcel(@NonNull Parcel source) {
            long elapsedRealtimeMillis = source.readLong();
            long unixEpochTimeMillis = source.readLong();
            return new UnixEpochTime(elapsedRealtimeMillis, unixEpochTimeMillis);
        }

        public UnixEpochTime[] newArray(int size) {
            return new UnixEpochTime[size];
        }
    };

    public UnixEpochTime(long elapsedRealtimeMillis, long unixEpochTimeMillis) {
        this.mElapsedRealtimeMillis = elapsedRealtimeMillis;
        this.mUnixEpochTimeMillis = unixEpochTimeMillis;
    }

    @NonNull
    public static UnixEpochTime parseCommandLineArgs(ShellCommand cmd) {
        String opt;
        Long elapsedRealtimeMillis = null;
        Long unixEpochTimeMillis = null;
        block8: while ((opt = cmd.getNextArg()) != null) {
            switch (opt) {
                case "--elapsed_realtime": {
                    elapsedRealtimeMillis = Long.parseLong(cmd.getNextArgRequired());
                    continue block8;
                }
                case "--unix_epoch_time": {
                    unixEpochTimeMillis = Long.parseLong(cmd.getNextArgRequired());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown option: " + opt);
        }
        if (elapsedRealtimeMillis == null) {
            throw new IllegalArgumentException("No elapsedRealtimeMillis specified.");
        }
        if (unixEpochTimeMillis == null) {
            throw new IllegalArgumentException("No unixEpochTimeMillis specified.");
        }
        return new UnixEpochTime(elapsedRealtimeMillis, unixEpochTimeMillis);
    }

    public static void printCommandLineOpts(PrintWriter pw) {
        pw.println("UnixEpochTime options:\n");
        pw.println("  --elapsed_realtime <elapsed realtime millis>");
        pw.println("  --unix_epoch_time <Unix epoch time millis>");
        pw.println();
        pw.println("See " + UnixEpochTime.class.getName() + " for more information");
    }

    public long getElapsedRealtimeMillis() {
        return this.mElapsedRealtimeMillis;
    }

    public long getUnixEpochTimeMillis() {
        return this.mUnixEpochTimeMillis;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnixEpochTime that = (UnixEpochTime)o;
        return this.mElapsedRealtimeMillis == that.mElapsedRealtimeMillis && this.mUnixEpochTimeMillis == that.mUnixEpochTimeMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mElapsedRealtimeMillis, this.mUnixEpochTimeMillis);
    }

    public String toString() {
        return "UnixEpochTime{mElapsedRealtimeMillis=" + this.mElapsedRealtimeMillis + ", mUnixEpochTimeMillis=" + this.mUnixEpochTimeMillis + '}';
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mElapsedRealtimeMillis);
        dest.writeLong(this.mUnixEpochTimeMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public UnixEpochTime at(long elapsedRealtimeTimeMillis) {
        long adjustedUnixEpochTimeMillis = elapsedRealtimeTimeMillis - this.mElapsedRealtimeMillis + this.mUnixEpochTimeMillis;
        return new UnixEpochTime(elapsedRealtimeTimeMillis, adjustedUnixEpochTimeMillis);
    }

    public static long elapsedRealtimeDifference(@NonNull UnixEpochTime one, @NonNull UnixEpochTime two) {
        return one.mElapsedRealtimeMillis - two.mElapsedRealtimeMillis;
    }
}

