/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.app.time.DetectorStatusTypes;
import android.app.time.LocationTimeZoneAlgorithmStatus;
import android.app.time.TelephonyTimeZoneAlgorithmStatus;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class TimeZoneDetectorStatus
implements Parcelable {
    private final int mDetectorStatus;
    @NonNull
    private final TelephonyTimeZoneAlgorithmStatus mTelephonyTimeZoneAlgorithmStatus;
    @NonNull
    private final LocationTimeZoneAlgorithmStatus mLocationTimeZoneAlgorithmStatus;
    @NonNull
    public static final Parcelable.Creator<TimeZoneDetectorStatus> CREATOR = new Parcelable.Creator<TimeZoneDetectorStatus>(){

        @Override
        public TimeZoneDetectorStatus createFromParcel(Parcel in) {
            int detectorStatus = in.readInt();
            TelephonyTimeZoneAlgorithmStatus telephonyTimeZoneAlgorithmStatus = in.readParcelable(this.getClass().getClassLoader(), TelephonyTimeZoneAlgorithmStatus.class);
            LocationTimeZoneAlgorithmStatus locationTimeZoneAlgorithmStatus = in.readParcelable(this.getClass().getClassLoader(), LocationTimeZoneAlgorithmStatus.class);
            return new TimeZoneDetectorStatus(detectorStatus, telephonyTimeZoneAlgorithmStatus, locationTimeZoneAlgorithmStatus);
        }

        public TimeZoneDetectorStatus[] newArray(int size) {
            return new TimeZoneDetectorStatus[size];
        }
    };

    public TimeZoneDetectorStatus(int detectorStatus, @NonNull TelephonyTimeZoneAlgorithmStatus telephonyTimeZoneAlgorithmStatus, @NonNull LocationTimeZoneAlgorithmStatus locationTimeZoneAlgorithmStatus) {
        this.mDetectorStatus = DetectorStatusTypes.requireValidDetectorStatus(detectorStatus);
        this.mTelephonyTimeZoneAlgorithmStatus = Objects.requireNonNull(telephonyTimeZoneAlgorithmStatus);
        this.mLocationTimeZoneAlgorithmStatus = Objects.requireNonNull(locationTimeZoneAlgorithmStatus);
    }

    public int getDetectorStatus() {
        return this.mDetectorStatus;
    }

    @NonNull
    public TelephonyTimeZoneAlgorithmStatus getTelephonyTimeZoneAlgorithmStatus() {
        return this.mTelephonyTimeZoneAlgorithmStatus;
    }

    @NonNull
    public LocationTimeZoneAlgorithmStatus getLocationTimeZoneAlgorithmStatus() {
        return this.mLocationTimeZoneAlgorithmStatus;
    }

    public String toString() {
        return "TimeZoneDetectorStatus{mDetectorStatus=" + DetectorStatusTypes.detectorStatusToString(this.mDetectorStatus) + ", mTelephonyTimeZoneAlgorithmStatus=" + this.mTelephonyTimeZoneAlgorithmStatus + ", mLocationTimeZoneAlgorithmStatus=" + this.mLocationTimeZoneAlgorithmStatus + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeInt(this.mDetectorStatus);
        parcel.writeParcelable(this.mTelephonyTimeZoneAlgorithmStatus, flags);
        parcel.writeParcelable(this.mLocationTimeZoneAlgorithmStatus, flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneDetectorStatus that = (TimeZoneDetectorStatus)o;
        return this.mDetectorStatus == that.mDetectorStatus && this.mTelephonyTimeZoneAlgorithmStatus.equals(that.mTelephonyTimeZoneAlgorithmStatus) && this.mLocationTimeZoneAlgorithmStatus.equals(that.mLocationTimeZoneAlgorithmStatus);
    }

    public int hashCode() {
        return Objects.hash(this.mDetectorStatus, this.mTelephonyTimeZoneAlgorithmStatus, this.mLocationTimeZoneAlgorithmStatus);
    }
}

