/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.time.UnixEpochTime;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ShellCommand;
import java.io.PrintWriter;
import java.util.Objects;

@SystemApi
public class TimeState
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<TimeState> CREATOR = new Parcelable.Creator<TimeState>(){

        @Override
        public TimeState createFromParcel(Parcel in) {
            return TimeState.createFromParcel(in);
        }

        public TimeState[] newArray(int size) {
            return new TimeState[size];
        }
    };
    @NonNull
    private final UnixEpochTime mUnixEpochTime;
    private final boolean mUserShouldConfirmTime;

    public TimeState(@NonNull UnixEpochTime unixEpochTime, boolean userShouldConfirmTime) {
        this.mUnixEpochTime = Objects.requireNonNull(unixEpochTime);
        this.mUserShouldConfirmTime = userShouldConfirmTime;
    }

    private static TimeState createFromParcel(Parcel in) {
        UnixEpochTime unixEpochTime = in.readParcelable(null, UnixEpochTime.class);
        boolean userShouldConfirmId = in.readBoolean();
        return new TimeState(unixEpochTime, userShouldConfirmId);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mUnixEpochTime, 0);
        dest.writeBoolean(this.mUserShouldConfirmTime);
    }

    @Nullable
    public static TimeState parseCommandLineArgs(@NonNull ShellCommand cmd) {
        String opt;
        Long elapsedRealtimeMillis = null;
        Long unixEpochTimeMillis = null;
        Boolean userShouldConfirmTime = null;
        block10: while ((opt = cmd.getNextArg()) != null) {
            switch (opt) {
                case "--elapsed_realtime": {
                    elapsedRealtimeMillis = Long.parseLong(cmd.getNextArgRequired());
                    continue block10;
                }
                case "--unix_epoch_time": {
                    unixEpochTimeMillis = Long.parseLong(cmd.getNextArgRequired());
                    continue block10;
                }
                case "--user_should_confirm_time": {
                    userShouldConfirmTime = Boolean.parseBoolean(cmd.getNextArgRequired());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unknown option: " + opt);
        }
        if (elapsedRealtimeMillis == null) {
            throw new IllegalArgumentException("No elapsedRealtimeMillis specified.");
        }
        if (unixEpochTimeMillis == null) {
            throw new IllegalArgumentException("No unixEpochTimeMillis specified.");
        }
        if (userShouldConfirmTime == null) {
            throw new IllegalArgumentException("No userShouldConfirmTime specified.");
        }
        UnixEpochTime unixEpochTime = new UnixEpochTime(elapsedRealtimeMillis, unixEpochTimeMillis);
        return new TimeState(unixEpochTime, userShouldConfirmTime);
    }

    public static void printCommandLineOpts(@NonNull PrintWriter pw) {
        pw.println("TimeState options:");
        pw.println("  --elapsed_realtime <elapsed realtime millis>");
        pw.println("  --unix_epoch_time <Unix epoch time millis>");
        pw.println("  --user_should_confirm_time {true|false}");
        pw.println();
        pw.println("See " + TimeState.class.getName() + " for more information");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public UnixEpochTime getUnixEpochTime() {
        return this.mUnixEpochTime;
    }

    public boolean getUserShouldConfirmTime() {
        return this.mUserShouldConfirmTime;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeState that = (TimeState)o;
        return Objects.equals(this.mUnixEpochTime, that.mUnixEpochTime) && this.mUserShouldConfirmTime == that.mUserShouldConfirmTime;
    }

    public int hashCode() {
        return Objects.hash(this.mUnixEpochTime, this.mUserShouldConfirmTime);
    }

    public String toString() {
        return "TimeState{mUnixEpochTime=" + this.mUnixEpochTime + ", mUserShouldConfirmTime=" + this.mUserShouldConfirmTime + '}';
    }
}

