/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.time.ExternalTimeSuggestion;
import android.app.time.ITimeZoneDetectorListener;
import android.app.time.TimeCapabilitiesAndConfig;
import android.app.time.TimeConfiguration;
import android.app.time.TimeState;
import android.app.time.TimeZoneCapabilitiesAndConfig;
import android.app.time.TimeZoneConfiguration;
import android.app.time.TimeZoneState;
import android.app.time.UnixEpochTime;
import android.app.timedetector.ITimeDetectorService;
import android.app.timedetector.ManualTimeSuggestion;
import android.app.timezonedetector.ITimeZoneDetectorService;
import android.app.timezonedetector.ManualTimeZoneSuggestion;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.util.concurrent.Executor;

@SystemApi
public class TimeManager {
    private static final String TAG = "time.TimeManager";
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    private final ITimeZoneDetectorService mITimeZoneDetectorService = ITimeZoneDetectorService.Stub.asInterface(ServiceManager.getServiceOrThrow("time_zone_detector"));
    private final ITimeDetectorService mITimeDetectorService = ITimeDetectorService.Stub.asInterface(ServiceManager.getServiceOrThrow("time_detector"));
    @GuardedBy(value={"mLock"})
    private ITimeZoneDetectorListener mTimeZoneDetectorReceiver;
    @GuardedBy(value={"mLock"})
    private ArrayMap<TimeZoneDetectorListener, TimeZoneDetectorListener> mTimeZoneDetectorListeners;

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    @NonNull
    public TimeZoneCapabilitiesAndConfig getTimeZoneCapabilitiesAndConfig() {
        try {
            return this.mITimeZoneDetectorService.getCapabilitiesAndConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    @NonNull
    public TimeCapabilitiesAndConfig getTimeCapabilitiesAndConfig() {
        try {
            return this.mITimeDetectorService.getCapabilitiesAndConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public boolean updateTimeConfiguration(@NonNull TimeConfiguration configuration) {
        try {
            return this.mITimeDetectorService.updateConfiguration(configuration);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public boolean updateTimeZoneConfiguration(@NonNull TimeZoneConfiguration configuration) {
        try {
            return this.mITimeZoneDetectorService.updateConfiguration(configuration);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public void addTimeZoneDetectorListener(@NonNull Executor executor, @NonNull TimeZoneDetectorListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTimeZoneDetectorListeners == null) {
                this.mTimeZoneDetectorListeners = new ArrayMap();
            } else if (this.mTimeZoneDetectorListeners.containsKey(listener)) {
                return;
            }
            if (this.mTimeZoneDetectorReceiver == null) {
                ITimeZoneDetectorListener.Stub iListener = new ITimeZoneDetectorListener.Stub(){

                    @Override
                    public void onChange() {
                        TimeManager.this.notifyTimeZoneDetectorListeners();
                    }
                };
                this.mTimeZoneDetectorReceiver = iListener;
                try {
                    this.mITimeZoneDetectorService.addListener(this.mTimeZoneDetectorReceiver);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mTimeZoneDetectorListeners.put(listener, () -> executor.execute(listener::onChange));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTimeZoneDetectorListeners() {
        ArrayMap<TimeZoneDetectorListener, TimeZoneDetectorListener> timeZoneDetectorListeners;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTimeZoneDetectorListeners == null || this.mTimeZoneDetectorListeners.isEmpty()) {
                return;
            }
            timeZoneDetectorListeners = new ArrayMap<TimeZoneDetectorListener, TimeZoneDetectorListener>(this.mTimeZoneDetectorListeners);
        }
        int size = timeZoneDetectorListeners.size();
        for (int i = 0; i < size; ++i) {
            timeZoneDetectorListeners.valueAt(i).onChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public void removeTimeZoneDetectorListener(@NonNull TimeZoneDetectorListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTimeZoneDetectorListeners == null || this.mTimeZoneDetectorListeners.isEmpty()) {
                return;
            }
            this.mTimeZoneDetectorListeners.remove(listener);
            if (this.mTimeZoneDetectorListeners.isEmpty()) {
                try {
                    this.mITimeZoneDetectorService.removeListener(this.mTimeZoneDetectorReceiver);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                finally {
                    this.mTimeZoneDetectorReceiver = null;
                }
            }
        }
    }

    @RequiresPermission(value="android.permission.SUGGEST_EXTERNAL_TIME")
    public void suggestExternalTime(@NonNull ExternalTimeSuggestion timeSuggestion) {
        try {
            this.mITimeDetectorService.suggestExternalTime(timeSuggestion);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    @NonNull
    public TimeState getTimeState() {
        try {
            return this.mITimeDetectorService.getTimeState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public boolean confirmTime(@NonNull UnixEpochTime unixEpochTime) {
        try {
            return this.mITimeDetectorService.confirmTime(unixEpochTime);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public boolean setManualTime(@NonNull UnixEpochTime unixEpochTime) {
        try {
            ManualTimeSuggestion manualTimeSuggestion = new ManualTimeSuggestion(unixEpochTime);
            manualTimeSuggestion.addDebugInfo("TimeManager.setTime()");
            manualTimeSuggestion.addDebugInfo("UID: " + Process.myUid());
            manualTimeSuggestion.addDebugInfo("UserHandle: " + Process.myUserHandle());
            manualTimeSuggestion.addDebugInfo("Process: " + Process.myProcessName());
            return this.mITimeDetectorService.setManualTime(manualTimeSuggestion);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    @NonNull
    public TimeZoneState getTimeZoneState() {
        try {
            return this.mITimeZoneDetectorService.getTimeZoneState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public boolean confirmTimeZone(@NonNull String timeZoneId) {
        try {
            return this.mITimeZoneDetectorService.confirmTimeZone(timeZoneId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public boolean setManualTimeZone(@NonNull String timeZoneId) {
        try {
            ManualTimeZoneSuggestion manualTimeZoneSuggestion = new ManualTimeZoneSuggestion(timeZoneId);
            manualTimeZoneSuggestion.addDebugInfo("TimeManager.setManualTimeZone()");
            manualTimeZoneSuggestion.addDebugInfo("UID: " + Process.myUid());
            manualTimeZoneSuggestion.addDebugInfo("Process: " + Process.myProcessName());
            return this.mITimeZoneDetectorService.setManualTimeZone(manualTimeZoneSuggestion);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FunctionalInterface
    public static interface TimeZoneDetectorListener {
        public void onChange();
    }
}

