/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.time.DetectorStatusTypes;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.timezone.TimeZoneProviderStatus;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocationTimeZoneAlgorithmStatus
implements Parcelable {
    public static final int PROVIDER_STATUS_NOT_PRESENT = 1;
    public static final int PROVIDER_STATUS_NOT_READY = 2;
    public static final int PROVIDER_STATUS_IS_CERTAIN = 3;
    public static final int PROVIDER_STATUS_IS_UNCERTAIN = 4;
    public static final LocationTimeZoneAlgorithmStatus NOT_SUPPORTED = new LocationTimeZoneAlgorithmStatus(1, 1, null, 1, null);
    public static final LocationTimeZoneAlgorithmStatus RUNNING_NOT_REPORTED = new LocationTimeZoneAlgorithmStatus(2, 2, null, 2, null);
    public static final LocationTimeZoneAlgorithmStatus NOT_RUNNING = new LocationTimeZoneAlgorithmStatus(2, 2, null, 2, null);
    private final int mStatus;
    private final int mPrimaryProviderStatus;
    @Nullable
    private final TimeZoneProviderStatus mPrimaryProviderReportedStatus;
    private final int mSecondaryProviderStatus;
    @Nullable
    private final TimeZoneProviderStatus mSecondaryProviderReportedStatus;
    @NonNull
    public static final Parcelable.Creator<LocationTimeZoneAlgorithmStatus> CREATOR = new Parcelable.Creator<LocationTimeZoneAlgorithmStatus>(){

        @Override
        public LocationTimeZoneAlgorithmStatus createFromParcel(Parcel in) {
            int algorithmStatus = in.readInt();
            int primaryProviderStatus = in.readInt();
            TimeZoneProviderStatus primaryProviderReportedStatus = in.readParcelable(this.getClass().getClassLoader(), TimeZoneProviderStatus.class);
            int secondaryProviderStatus = in.readInt();
            TimeZoneProviderStatus secondaryProviderReportedStatus = in.readParcelable(this.getClass().getClassLoader(), TimeZoneProviderStatus.class);
            return new LocationTimeZoneAlgorithmStatus(algorithmStatus, primaryProviderStatus, primaryProviderReportedStatus, secondaryProviderStatus, secondaryProviderReportedStatus);
        }

        public LocationTimeZoneAlgorithmStatus[] newArray(int size) {
            return new LocationTimeZoneAlgorithmStatus[size];
        }
    };

    public LocationTimeZoneAlgorithmStatus(int status, int primaryProviderStatus, @Nullable TimeZoneProviderStatus primaryProviderReportedStatus, int secondaryProviderStatus, @Nullable TimeZoneProviderStatus secondaryProviderReportedStatus) {
        boolean secondaryProviderReportedStatusPresent;
        boolean primaryProviderReportedStatusPresent;
        this.mStatus = DetectorStatusTypes.requireValidDetectionAlgorithmStatus(status);
        this.mPrimaryProviderStatus = LocationTimeZoneAlgorithmStatus.requireValidProviderStatus(primaryProviderStatus);
        this.mPrimaryProviderReportedStatus = primaryProviderReportedStatus;
        this.mSecondaryProviderStatus = LocationTimeZoneAlgorithmStatus.requireValidProviderStatus(secondaryProviderStatus);
        this.mSecondaryProviderReportedStatus = secondaryProviderReportedStatus;
        boolean primaryProviderHasReported = LocationTimeZoneAlgorithmStatus.hasProviderReported(primaryProviderStatus);
        boolean bl = primaryProviderReportedStatusPresent = primaryProviderReportedStatus != null;
        if (!primaryProviderHasReported && primaryProviderReportedStatusPresent) {
            throw new IllegalArgumentException("primaryProviderReportedStatus=" + primaryProviderReportedStatus + ", primaryProviderStatus=" + LocationTimeZoneAlgorithmStatus.providerStatusToString(primaryProviderStatus));
        }
        boolean secondaryProviderHasReported = LocationTimeZoneAlgorithmStatus.hasProviderReported(secondaryProviderStatus);
        boolean bl2 = secondaryProviderReportedStatusPresent = secondaryProviderReportedStatus != null;
        if (!secondaryProviderHasReported && secondaryProviderReportedStatusPresent) {
            throw new IllegalArgumentException("secondaryProviderReportedStatus=" + secondaryProviderReportedStatus + ", secondaryProviderStatus=" + LocationTimeZoneAlgorithmStatus.providerStatusToString(secondaryProviderStatus));
        }
        if (status != 3 && (primaryProviderHasReported || secondaryProviderHasReported)) {
            throw new IllegalArgumentException("algorithmStatus=" + DetectorStatusTypes.detectionAlgorithmStatusToString(status) + ", primaryProviderReportedStatus=" + primaryProviderReportedStatus + ", secondaryProviderReportedStatus=" + secondaryProviderReportedStatus);
        }
    }

    public int getStatus() {
        return this.mStatus;
    }

    public int getPrimaryProviderStatus() {
        return this.mPrimaryProviderStatus;
    }

    @Nullable
    public TimeZoneProviderStatus getPrimaryProviderReportedStatus() {
        return this.mPrimaryProviderReportedStatus;
    }

    public int getSecondaryProviderStatus() {
        return this.mSecondaryProviderStatus;
    }

    @Nullable
    public TimeZoneProviderStatus getSecondaryProviderReportedStatus() {
        return this.mSecondaryProviderReportedStatus;
    }

    public String toString() {
        return "LocationTimeZoneAlgorithmStatus{mAlgorithmStatus=" + DetectorStatusTypes.detectionAlgorithmStatusToString(this.mStatus) + ", mPrimaryProviderStatus=" + LocationTimeZoneAlgorithmStatus.providerStatusToString(this.mPrimaryProviderStatus) + ", mPrimaryProviderReportedStatus=" + this.mPrimaryProviderReportedStatus + ", mSecondaryProviderStatus=" + LocationTimeZoneAlgorithmStatus.providerStatusToString(this.mSecondaryProviderStatus) + ", mSecondaryProviderReportedStatus=" + this.mSecondaryProviderReportedStatus + '}';
    }

    @NonNull
    public static LocationTimeZoneAlgorithmStatus parseCommandlineArg(@NonNull String arg) {
        Pattern pattern = Pattern.compile("LocationTimeZoneAlgorithmStatus\\{mAlgorithmStatus=(.+), mPrimaryProviderStatus=([^,]+), mPrimaryProviderReportedStatus=(null|TimeZoneProviderStatus\\{[^}]+\\}), mSecondaryProviderStatus=([^,]+), mSecondaryProviderReportedStatus=(null|TimeZoneProviderStatus\\{[^}]+\\})\\}");
        Matcher matcher = pattern.matcher(arg);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unable to parse algorithm status arg: " + arg);
        }
        int algorithmStatus = DetectorStatusTypes.detectionAlgorithmStatusFromString(matcher.group(1));
        int primaryProviderStatus = LocationTimeZoneAlgorithmStatus.providerStatusFromString(matcher.group(2));
        TimeZoneProviderStatus primaryProviderReportedStatus = LocationTimeZoneAlgorithmStatus.parseTimeZoneProviderStatusOrNull(matcher.group(3));
        int secondaryProviderStatus = LocationTimeZoneAlgorithmStatus.providerStatusFromString(matcher.group(4));
        TimeZoneProviderStatus secondaryProviderReportedStatus = LocationTimeZoneAlgorithmStatus.parseTimeZoneProviderStatusOrNull(matcher.group(5));
        return new LocationTimeZoneAlgorithmStatus(algorithmStatus, primaryProviderStatus, primaryProviderReportedStatus, secondaryProviderStatus, secondaryProviderReportedStatus);
    }

    @Nullable
    private static TimeZoneProviderStatus parseTimeZoneProviderStatusOrNull(String providerReportedStatusString) {
        TimeZoneProviderStatus providerReportedStatus = "null".equals(providerReportedStatusString) ? null : TimeZoneProviderStatus.parseProviderStatus(providerReportedStatusString);
        return providerReportedStatus;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeInt(this.mStatus);
        parcel.writeInt(this.mPrimaryProviderStatus);
        parcel.writeParcelable(this.mPrimaryProviderReportedStatus, flags);
        parcel.writeInt(this.mSecondaryProviderStatus);
        parcel.writeParcelable(this.mSecondaryProviderReportedStatus, flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationTimeZoneAlgorithmStatus that = (LocationTimeZoneAlgorithmStatus)o;
        return this.mStatus == that.mStatus && this.mPrimaryProviderStatus == that.mPrimaryProviderStatus && Objects.equals(this.mPrimaryProviderReportedStatus, that.mPrimaryProviderReportedStatus) && this.mSecondaryProviderStatus == that.mSecondaryProviderStatus && Objects.equals(this.mSecondaryProviderReportedStatus, that.mSecondaryProviderReportedStatus);
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mPrimaryProviderStatus, this.mPrimaryProviderReportedStatus, this.mSecondaryProviderStatus, this.mSecondaryProviderReportedStatus);
    }

    public boolean couldEnableTelephonyFallback() {
        if (this.mStatus == 0 || this.mStatus == 2 || this.mStatus == 1) {
            return false;
        }
        boolean primarySuggestsFallback = false;
        if (this.mPrimaryProviderStatus == 1) {
            primarySuggestsFallback = true;
        } else if (this.mPrimaryProviderStatus == 4 && this.mPrimaryProviderReportedStatus != null) {
            primarySuggestsFallback = this.mPrimaryProviderReportedStatus.couldEnableTelephonyFallback();
        }
        boolean secondarySuggestsFallback = false;
        if (this.mSecondaryProviderStatus == 1) {
            secondarySuggestsFallback = true;
        } else if (this.mSecondaryProviderStatus == 4 && this.mSecondaryProviderReportedStatus != null) {
            secondarySuggestsFallback = this.mSecondaryProviderReportedStatus.couldEnableTelephonyFallback();
        }
        return primarySuggestsFallback && secondarySuggestsFallback;
    }

    @VisibleForTesting
    @NonNull
    public static String providerStatusToString(int providerStatus) {
        switch (providerStatus) {
            case 1: {
                return "NOT_PRESENT";
            }
            case 2: {
                return "NOT_READY";
            }
            case 3: {
                return "IS_CERTAIN";
            }
            case 4: {
                return "IS_UNCERTAIN";
            }
        }
        throw new IllegalArgumentException("Unknown status: " + providerStatus);
    }

    @VisibleForTesting
    public static int providerStatusFromString(@Nullable String providerStatusString) {
        if (TextUtils.isEmpty(providerStatusString)) {
            throw new IllegalArgumentException("Empty status: " + providerStatusString);
        }
        switch (providerStatusString) {
            case "NOT_PRESENT": {
                return 1;
            }
            case "NOT_READY": {
                return 2;
            }
            case "IS_CERTAIN": {
                return 3;
            }
            case "IS_UNCERTAIN": {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + providerStatusString);
    }

    private static boolean hasProviderReported(int providerStatus) {
        return providerStatus == 3 || providerStatus == 4;
    }

    @VisibleForTesting
    public static int requireValidProviderStatus(int providerStatus) {
        if (providerStatus < 1 || providerStatus > 4) {
            throw new IllegalArgumentException("Invalid provider status: " + providerStatus);
        }
        return providerStatus;
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProviderStatus {
    }
}

