/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ClientTransactionHandler;
import android.app.IApplicationThread;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ClientTransactionItem;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ClientTransaction
implements Parcelable {
    @NonNull
    private final List<ClientTransactionItem> mTransactionItems = new ArrayList<ClientTransactionItem>();
    @Deprecated
    @Nullable
    @UnsupportedAppUsage(maxTargetSdk=34, trackingBug=324203798L, publicAlternatives="Use {@code #getTransactionItems()}")
    private List<ClientTransactionItem> mActivityCallbacks;
    @Nullable
    private ActivityLifecycleItem mLifecycleStateRequest;
    @Nullable
    private IBinder mActivityToken;
    @Nullable
    private final IApplicationThread mClient;
    @NonNull
    public static final Parcelable.Creator<ClientTransaction> CREATOR = new Parcelable.Creator<ClientTransaction>(){

        @Override
        public ClientTransaction createFromParcel(@NonNull Parcel in) {
            return new ClientTransaction(in);
        }

        public ClientTransaction[] newArray(int size) {
            return new ClientTransaction[size];
        }
    };

    @VisibleForTesting
    public ClientTransaction() {
        this.mClient = null;
    }

    public ClientTransaction(@NonNull IApplicationThread client) {
        this.mClient = Objects.requireNonNull(client);
    }

    public IApplicationThread getClient() {
        return this.mClient;
    }

    public void addTransactionItem(@NonNull ClientTransactionItem item) {
        this.mTransactionItems.add(item);
        if (item.isActivityLifecycleItem()) {
            this.setLifecycleStateRequest((ActivityLifecycleItem)item);
        } else {
            this.addCallback(item);
        }
    }

    @NonNull
    public List<ClientTransactionItem> getTransactionItems() {
        return this.mTransactionItems;
    }

    @Deprecated
    private void addCallback(@NonNull ClientTransactionItem activityCallback) {
        if (this.mActivityCallbacks == null) {
            this.mActivityCallbacks = new ArrayList<ClientTransactionItem>();
        }
        this.mActivityCallbacks.add(activityCallback);
        this.setActivityTokenIfNotSet(activityCallback);
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    @UnsupportedAppUsage(maxTargetSdk=34, trackingBug=324203798L, publicAlternatives="Use {@code #getTransactionItems()}")
    public List<ClientTransactionItem> getCallbacks() {
        return this.mActivityCallbacks;
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    @UnsupportedAppUsage(maxTargetSdk=34, trackingBug=324203798L, publicAlternatives="Use {@code android.app.servertransaction.ClientTransactionItem#getActivityToken()}")
    public IBinder getActivityToken() {
        return this.mActivityToken;
    }

    @Deprecated
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @Nullable
    @UnsupportedAppUsage(maxTargetSdk=34, trackingBug=324203798L, publicAlternatives="Use {@code #getTransactionItems()}")
    public ActivityLifecycleItem getLifecycleStateRequest() {
        return this.mLifecycleStateRequest;
    }

    @Deprecated
    private void setLifecycleStateRequest(@NonNull ActivityLifecycleItem stateRequest) {
        if (this.mLifecycleStateRequest != null) {
            return;
        }
        this.mLifecycleStateRequest = stateRequest;
        this.setActivityTokenIfNotSet(stateRequest);
    }

    private void setActivityTokenIfNotSet(@Nullable ClientTransactionItem item) {
        if (this.mActivityToken == null && item != null) {
            this.mActivityToken = item.getActivityToken();
        }
    }

    public void preExecute(@NonNull ClientTransactionHandler clientTransactionHandler) {
        int size = this.mTransactionItems.size();
        for (int i = 0; i < size; ++i) {
            this.mTransactionItems.get(i).preExecute(clientTransactionHandler);
        }
    }

    @Nullable
    public RemoteException schedule() {
        try {
            this.mClient.scheduleTransaction(this);
            return null;
        }
        catch (RemoteException e) {
            return e;
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelableList(this.mTransactionItems, flags);
    }

    private ClientTransaction(@NonNull Parcel in) {
        this.mClient = null;
        in.readParcelableList(this.mTransactionItems, this.getClass().getClassLoader(), ClientTransactionItem.class);
        int size = this.mTransactionItems.size();
        for (int i = 0; i < size; ++i) {
            ClientTransactionItem item = this.mTransactionItems.get(i);
            if (item.isActivityLifecycleItem()) {
                this.setLifecycleStateRequest((ActivityLifecycleItem)item);
                continue;
            }
            this.addCallback(item);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTransaction other = (ClientTransaction)o;
        return Objects.equals(this.mTransactionItems, other.mTransactionItems) && Objects.equals(this.mActivityCallbacks, other.mActivityCallbacks) && Objects.equals(this.mLifecycleStateRequest, other.mLifecycleStateRequest) && this.mClient == other.mClient && Objects.equals(this.mActivityToken, other.mActivityToken);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.mTransactionItems);
        result = 31 * result + Objects.hashCode(this.mActivityCallbacks);
        result = 31 * result + Objects.hashCode(this.mLifecycleStateRequest);
        result = 31 * result + Objects.hashCode(this.mClient);
        result = 31 * result + Objects.hashCode(this.mActivityToken);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientTransaction{");
        sb.append("\n  transactionItems=[");
        int size = this.mTransactionItems.size();
        for (int i = 0; i < size; ++i) {
            sb.append("\n    ").append(this.mTransactionItems.get(i));
        }
        sb.append("\n  ]");
        sb.append("\n}");
        return sb.toString();
    }

    void dump(@NonNull String prefix, @NonNull PrintWriter pw, @NonNull ClientTransactionHandler transactionHandler) {
        pw.append(prefix).println("ClientTransaction{");
        pw.append(prefix).print("  transactionItems=[");
        String itemPrefix = prefix + "    ";
        int size = this.mTransactionItems.size();
        if (size > 0) {
            pw.println();
            for (int i = 0; i < size; ++i) {
                this.mTransactionItems.get(i).dump(itemPrefix, pw, transactionHandler);
            }
            pw.append(prefix).println("  ]");
        } else {
            pw.println("]");
        }
        pw.append(prefix).println("}");
    }
}

