/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ClientTransactionItem;
import android.app.servertransaction.PendingTransactionActions;
import android.app.servertransaction.TransactionExecutorHelper;
import android.os.IBinder;
import android.os.Parcel;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.util.Objects;

public abstract class ActivityTransactionItem
extends ClientTransactionItem {
    @NonNull
    private final IBinder mActivityToken;

    public ActivityTransactionItem(@NonNull IBinder activityToken) {
        this.mActivityToken = Objects.requireNonNull(activityToken);
    }

    @Override
    public void execute(@NonNull ClientTransactionHandler client, @NonNull PendingTransactionActions pendingActions) {
        ActivityThread.ActivityClientRecord r = this.getActivityClientRecord(client);
        this.execute(client, r, pendingActions);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public abstract void execute(@NonNull ClientTransactionHandler var1, @NonNull ActivityThread.ActivityClientRecord var2, @NonNull PendingTransactionActions var3);

    @NonNull
    ActivityThread.ActivityClientRecord getActivityClientRecord(@NonNull ClientTransactionHandler client) {
        ActivityThread.ActivityClientRecord r = client.getActivityClient(this.getActivityToken());
        if (r == null) {
            throw new IllegalArgumentException("Activity client record must not be null to execute transaction item: " + this);
        }
        if (client.getActivity(this.getActivityToken()) == null) {
            throw new IllegalArgumentException("Activity must not be null to execute transaction item: " + this);
        }
        return r;
    }

    @Override
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @NonNull
    public IBinder getActivityToken() {
        return this.mActivityToken;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeStrongBinder(this.mActivityToken);
    }

    ActivityTransactionItem(@NonNull Parcel in) {
        this(in.readStrongBinder());
    }

    @Override
    void dump(@NonNull String prefix, @NonNull PrintWriter pw, @NonNull ClientTransactionHandler transactionHandler) {
        super.dump(prefix, pw, transactionHandler);
        pw.append(prefix).append("Target activity: ").println(TransactionExecutorHelper.getActivityName(this.mActivityToken, transactionHandler));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityTransactionItem other = (ActivityTransactionItem)o;
        return Objects.equals(this.mActivityToken, other.mActivityToken);
    }

    public int hashCode() {
        return Objects.hashCode(this.mActivityToken);
    }

    public String toString() {
        return "mActivityToken=" + this.mActivityToken;
    }
}

