/*
 * Decompiled with CFR 0.152.
 */
package android.app.search;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class SearchTargetEvent
implements Parcelable {
    @NonNull
    private final List<String> mTargetIds;
    @Nullable
    private final String mLocation;
    private final int mAction;
    private int mFlags;
    public static final int FLAG_IME_SHOWN = 1;
    public static final int ACTION_SURFACE_VISIBLE = 1;
    public static final int ACTION_TAP = 3;
    public static final int ACTION_LONGPRESS = 4;
    public static final int ACTION_LAUNCH_TOUCH = 5;
    public static final int ACTION_LAUNCH_KEYBOARD_FOCUS = 6;
    public static final int ACTION_DRAGNDROP = 7;
    public static final int ACTION_SURFACE_INVISIBLE = 8;
    public static final int ACTION_DELETE = 9;
    public static final int ACTION_DISMISS = 10;
    @NonNull
    public static final Parcelable.Creator<SearchTargetEvent> CREATOR = new Parcelable.Creator<SearchTargetEvent>(){

        @Override
        public SearchTargetEvent createFromParcel(Parcel parcel) {
            return new SearchTargetEvent(parcel);
        }

        public SearchTargetEvent[] newArray(int size) {
            return new SearchTargetEvent[size];
        }
    };

    private SearchTargetEvent(@NonNull List<String> targetIds, @Nullable String location, int actionType, int flags) {
        this.mTargetIds = Objects.requireNonNull(targetIds);
        this.mLocation = location;
        this.mAction = actionType;
        this.mFlags = flags;
    }

    private SearchTargetEvent(Parcel parcel) {
        this.mTargetIds = new ArrayList<String>();
        parcel.readStringList(this.mTargetIds);
        this.mLocation = parcel.readString();
        this.mAction = parcel.readInt();
        this.mFlags = parcel.readInt();
    }

    @NonNull
    public String getTargetId() {
        return this.mTargetIds.get(0);
    }

    @NonNull
    public List<String> getTargetIds() {
        return this.mTargetIds;
    }

    @Nullable
    public String getLaunchLocation() {
        return this.mLocation;
    }

    public int getAction() {
        return this.mAction;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int hashCode() {
        return this.mTargetIds.get(0).hashCode() + this.mAction;
    }

    public boolean equals(@Nullable Object o) {
        if (!this.getClass().equals(o != null ? o.getClass() : null)) {
            return false;
        }
        SearchTargetEvent other = (SearchTargetEvent)o;
        return this.mTargetIds.equals(other.mTargetIds) && this.mAction == other.mAction && this.mFlags == other.mFlags && this.mLocation == null ? other.mLocation == null : this.mLocation.equals(other.mLocation);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeStringList(this.mTargetIds);
        dest.writeString(this.mLocation);
        dest.writeInt(this.mAction);
        dest.writeInt(this.mFlags);
    }

    @SystemApi
    public static class Builder {
        @NonNull
        private List<String> mTargetIds;
        @Nullable
        private String mLocation;
        private int mAction;
        private int mFlags;

        public Builder(@NonNull String id2, int actionType) {
            this.mTargetIds = new ArrayList<String>();
            this.mTargetIds.add(id2);
            this.mAction = actionType;
        }

        public Builder(@NonNull List<String> ids, int actionType) {
            this.mTargetIds = ids;
            this.mAction = actionType;
        }

        @NonNull
        public Builder setLaunchLocation(@Nullable String location) {
            this.mLocation = location;
            return this;
        }

        @NonNull
        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        @NonNull
        public SearchTargetEvent build() {
            return new SearchTargetEvent(this.mTargetIds, this.mLocation, this.mAction, this.mFlags);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlagType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActionType {
    }
}

