/*
 * Decompiled with CFR 0.152.
 */
package android.app.search;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class Query
implements Parcelable {
    public static final String EXTRA_IME_HEIGHT = "android.app.search.extra.IME_HEIGHT";
    @NonNull
    private final String mInput;
    private final long mTimestampMillis;
    @NonNull
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<Query> CREATOR = new Parcelable.Creator<Query>(){

        @Override
        public Query createFromParcel(Parcel parcel) {
            return new Query(parcel);
        }

        public Query[] newArray(int size) {
            return new Query[size];
        }
    };

    public Query(@NonNull String input, long timestampMillis, @NonNull Bundle extras) {
        this.mInput = input;
        this.mTimestampMillis = timestampMillis;
        this.mExtras = extras != null ? extras : new Bundle();
    }

    public Query(@NonNull String input, long timestampMillis) {
        this(input, timestampMillis, new Bundle());
    }

    private Query(Parcel parcel) {
        this.mInput = parcel.readString();
        this.mTimestampMillis = parcel.readLong();
        this.mExtras = parcel.readBundle();
    }

    @NonNull
    public String getInput() {
        return this.mInput;
    }

    @Deprecated
    @NonNull
    public long getTimestamp() {
        return this.mTimestampMillis;
    }

    public long getTimestampMillis() {
        return this.mTimestampMillis;
    }

    @NonNull
    public Bundle getExtras() {
        if (this.mExtras == null) {
            return new Bundle();
        }
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mInput);
        dest.writeLong(this.mTimestampMillis);
        dest.writeBundle(this.mExtras);
    }
}

