/*
 * Decompiled with CFR 0.152.
 */
package android.app.ondeviceintelligence;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ondeviceintelligence.DownloadCallback;
import android.app.ondeviceintelligence.Feature;
import android.app.ondeviceintelligence.FeatureDetails;
import android.app.ondeviceintelligence.IDownloadCallback;
import android.app.ondeviceintelligence.IFeatureCallback;
import android.app.ondeviceintelligence.IFeatureDetailsCallback;
import android.app.ondeviceintelligence.IListFeaturesCallback;
import android.app.ondeviceintelligence.IOnDeviceIntelligenceManager;
import android.app.ondeviceintelligence.IProcessingSignal;
import android.app.ondeviceintelligence.IResponseCallback;
import android.app.ondeviceintelligence.IStreamingResponseCallback;
import android.app.ondeviceintelligence.ITokenInfoCallback;
import android.app.ondeviceintelligence.InferenceInfo;
import android.app.ondeviceintelligence.OnDeviceIntelligenceException;
import android.app.ondeviceintelligence.ProcessingCallback;
import android.app.ondeviceintelligence.ProcessingSignal;
import android.app.ondeviceintelligence.StreamingProcessingCallback;
import android.app.ondeviceintelligence.TokenInfo;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.OutcomeReceiver;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.infra.AndroidFuture;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.LongConsumer;

@SystemApi
@FlaggedApi(value="android.app.ondeviceintelligence.flags.enable_on_device_intelligence")
public class OnDeviceIntelligenceManager {
    public static final String API_VERSION_BUNDLE_KEY = "ApiVersionBundleKey";
    public static final String AUGMENT_REQUEST_CONTENT_BUNDLE_KEY = "AugmentRequestContentBundleKey";
    private static final String TAG = "OnDeviceIntelligence";
    private final Context mContext;
    private final IOnDeviceIntelligenceManager mService;
    public static final int REQUEST_TYPE_INFERENCE = 0;
    public static final int REQUEST_TYPE_PREPARE = 1;
    public static final int REQUEST_TYPE_EMBEDDINGS = 2;

    public OnDeviceIntelligenceManager(Context context, IOnDeviceIntelligenceManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void getVersion(@NonNull Executor callbackExecutor, @NonNull LongConsumer versionConsumer) {
        try {
            RemoteCallback callback = new RemoteCallback(result -> {
                if (result == null) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> versionConsumer.accept(0L)));
                }
                long version = result.getLong(API_VERSION_BUNDLE_KEY);
                Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> versionConsumer.accept(version)));
            });
            this.mService.getVersion(callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public String getRemoteServicePackageName() {
        String result;
        try {
            result = this.mService.getRemoteServicePackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void getFeature(int featureId, final @NonNull Executor callbackExecutor, final @NonNull OutcomeReceiver<Feature, OnDeviceIntelligenceException> featureReceiver) {
        try {
            IFeatureCallback.Stub callback = new IFeatureCallback.Stub(this){

                @Override
                public void onSuccess(Feature result) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> featureReceiver.onResult(result)));
                }

                @Override
                public void onFailure(int errorCode, String errorMessage, PersistableBundle errorParams) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> featureReceiver.onError(new OnDeviceIntelligenceException(errorCode, errorMessage, errorParams))));
                }
            };
            this.mService.getFeature(featureId, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void listFeatures(final @NonNull Executor callbackExecutor, final @NonNull OutcomeReceiver<List<Feature>, OnDeviceIntelligenceException> featureListReceiver) {
        try {
            IListFeaturesCallback.Stub callback = new IListFeaturesCallback.Stub(this){

                @Override
                public void onSuccess(List<Feature> result) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> featureListReceiver.onResult(result)));
                }

                @Override
                public void onFailure(int errorCode, String errorMessage, PersistableBundle errorParams) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> featureListReceiver.onError(new OnDeviceIntelligenceException(errorCode, errorMessage, errorParams))));
                }
            };
            this.mService.listFeatures(callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void getFeatureDetails(@NonNull Feature feature, final @NonNull Executor callbackExecutor, final @NonNull OutcomeReceiver<FeatureDetails, OnDeviceIntelligenceException> featureDetailsReceiver) {
        try {
            IFeatureDetailsCallback.Stub callback = new IFeatureDetailsCallback.Stub(this){

                @Override
                public void onSuccess(FeatureDetails result) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> featureDetailsReceiver.onResult(result)));
                }

                @Override
                public void onFailure(int errorCode, String errorMessage, PersistableBundle errorParams) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> featureDetailsReceiver.onError(new OnDeviceIntelligenceException(errorCode, errorMessage, errorParams))));
                }
            };
            this.mService.getFeatureDetails(feature, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void requestFeatureDownload(@NonNull Feature feature, @Nullable CancellationSignal cancellationSignal, final @NonNull Executor callbackExecutor, final @NonNull DownloadCallback callback) {
        try {
            IDownloadCallback.Stub downloadCallback = new IDownloadCallback.Stub(this){

                @Override
                public void onDownloadStarted(long bytesToDownload) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> callback.onDownloadStarted(bytesToDownload)));
                }

                @Override
                public void onDownloadProgress(long bytesDownloaded) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> callback.onDownloadProgress(bytesDownloaded)));
                }

                @Override
                public void onDownloadFailed(int failureStatus, String errorMessage, PersistableBundle errorParams) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> callback.onDownloadFailed(failureStatus, errorMessage, errorParams)));
                }

                @Override
                public void onDownloadCompleted(PersistableBundle downloadParams) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> callback.onDownloadCompleted(downloadParams)));
                }
            };
            this.mService.requestFeatureDownload(feature, OnDeviceIntelligenceManager.configureRemoteCancellationFuture(cancellationSignal, callbackExecutor), downloadCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void requestTokenInfo(@NonNull Feature feature, @NonNull @InferenceParams Bundle request, @Nullable CancellationSignal cancellationSignal, final @NonNull Executor callbackExecutor, final @NonNull OutcomeReceiver<TokenInfo, OnDeviceIntelligenceException> outcomeReceiver) {
        try {
            ITokenInfoCallback.Stub callback = new ITokenInfoCallback.Stub(this){

                @Override
                public void onSuccess(TokenInfo tokenInfo) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> outcomeReceiver.onResult(tokenInfo)));
                }

                @Override
                public void onFailure(int errorCode, String errorMessage, PersistableBundle errorParams) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> outcomeReceiver.onError(new OnDeviceIntelligenceException(errorCode, errorMessage, errorParams))));
                }
            };
            this.mService.requestTokenInfo(feature, request, OnDeviceIntelligenceManager.configureRemoteCancellationFuture(cancellationSignal, callbackExecutor), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void processRequest(@NonNull Feature feature, @NonNull @InferenceParams Bundle request, int requestType, @Nullable CancellationSignal cancellationSignal, @Nullable ProcessingSignal processingSignal, final @NonNull Executor callbackExecutor, final @NonNull ProcessingCallback processingCallback) {
        try {
            IResponseCallback.Stub callback = new IResponseCallback.Stub(this){

                @Override
                public void onSuccess(@InferenceParams Bundle result) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> processingCallback.onResult(result)));
                }

                @Override
                public void onFailure(int errorCode, String errorMessage, PersistableBundle errorParams) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> processingCallback.onError(new OnDeviceIntelligenceException(errorCode, errorMessage, errorParams))));
                }

                @Override
                public void onDataAugmentRequest(@NonNull @InferenceParams Bundle request, @NonNull RemoteCallback contentCallback) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> processingCallback.onDataAugmentRequest(request, (Bundle result) -> {
                        Bundle bundle = new Bundle();
                        bundle.putParcelable(OnDeviceIntelligenceManager.AUGMENT_REQUEST_CONTENT_BUNDLE_KEY, (Parcelable)result);
                        callbackExecutor.execute(() -> contentCallback.sendResult(bundle));
                    })));
                }
            };
            this.mService.processRequest(feature, request, requestType, OnDeviceIntelligenceManager.configureRemoteCancellationFuture(cancellationSignal, callbackExecutor), OnDeviceIntelligenceManager.configureRemoteProcessingSignalFuture(processingSignal, callbackExecutor), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void processRequestStreaming(@NonNull Feature feature, @NonNull @InferenceParams Bundle request, int requestType, @Nullable CancellationSignal cancellationSignal, @Nullable ProcessingSignal processingSignal, final @NonNull Executor callbackExecutor, final @NonNull StreamingProcessingCallback streamingProcessingCallback) {
        try {
            IStreamingResponseCallback.Stub callback = new IStreamingResponseCallback.Stub(this){

                @Override
                public void onNewContent(@InferenceParams Bundle result) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> streamingProcessingCallback.onPartialResult(result)));
                }

                @Override
                public void onSuccess(@InferenceParams Bundle result) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> streamingProcessingCallback.onResult(result)));
                }

                @Override
                public void onFailure(int errorCode, String errorMessage, PersistableBundle errorParams) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> streamingProcessingCallback.onError(new OnDeviceIntelligenceException(errorCode, errorMessage, errorParams))));
                }

                @Override
                public void onDataAugmentRequest(@NonNull @InferenceParams Bundle content, @NonNull RemoteCallback contentCallback) {
                    Binder.withCleanCallingIdentity(() -> callbackExecutor.execute(() -> streamingProcessingCallback.onDataAugmentRequest(content, (Bundle contentResponse) -> {
                        Bundle bundle = new Bundle();
                        bundle.putParcelable(OnDeviceIntelligenceManager.AUGMENT_REQUEST_CONTENT_BUNDLE_KEY, (Parcelable)contentResponse);
                        callbackExecutor.execute(() -> contentCallback.sendResult(bundle));
                    })));
                }
            };
            this.mService.processRequestStreaming(feature, request, requestType, OnDeviceIntelligenceManager.configureRemoteCancellationFuture(cancellationSignal, callbackExecutor), OnDeviceIntelligenceManager.configureRemoteProcessingSignalFuture(processingSignal, callbackExecutor), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DUMP")
    @FlaggedApi(value="android.app.ondeviceintelligence.flags.enable_on_device_intelligence_module")
    @NonNull
    public List<InferenceInfo> getLatestInferenceInfo(long startTimeEpochMillis) {
        try {
            return this.mService.getLatestInferenceInfo(startTimeEpochMillis);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    private static AndroidFuture<IBinder> configureRemoteCancellationFuture(@Nullable CancellationSignal cancellationSignal, @NonNull Executor callbackExecutor) {
        if (cancellationSignal == null) {
            return null;
        }
        AndroidFuture<IBinder> cancellationFuture = new AndroidFuture<IBinder>();
        cancellationFuture.whenCompleteAsync((cancellationTransport, error) -> {
            if (error != null || cancellationTransport == null) {
                Log.e(TAG, "Unable to receive the remote cancellation signal.", error);
            } else {
                cancellationSignal.setRemote(ICancellationSignal.Stub.asInterface(cancellationTransport));
            }
        }, callbackExecutor);
        return cancellationFuture;
    }

    @Nullable
    private static AndroidFuture<IBinder> configureRemoteProcessingSignalFuture(ProcessingSignal processingSignal, Executor executor) {
        if (processingSignal == null) {
            return null;
        }
        AndroidFuture<IBinder> processingSignalFuture = new AndroidFuture<IBinder>();
        processingSignalFuture.whenCompleteAsync((transport, error) -> {
            if (error != null || transport == null) {
                Log.e(TAG, "Unable to receive the remote processing signal.", error);
            } else {
                processingSignal.setRemote(IProcessingSignal.Stub.asInterface(transport));
            }
        }, executor);
        return processingSignalFuture;
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD})
    public static @interface ResponseParams {
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.TYPE_USE})
    public static @interface InferenceParams {
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD})
    public static @interface StateParams {
    }

    @Target(value={ElementType.TYPE_USE, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestType {
    }
}

