/*
 * Decompiled with CFR 0.152.
 */
package android.app.jank;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.jank.AppJankStats;
import android.app.jank.JankDataProcessor;
import android.app.jank.StateTracker;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.AttachedSurfaceControl;
import android.view.Choreographer;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@FlaggedApi(value="android.app.jank.detailed_app_jank_metrics_api")
public class JankTracker {
    private static final boolean DEBUG = false;
    private static final String DEBUG_KEY = "JANKTRACKER";
    private static final int REGISTRATION_DELAY_MS = 1000;
    private StateTracker mStateTracker;
    private JankDataProcessor mJankDataProcessor;
    private HandlerThread mHandlerThread = new HandlerThread("AppJankTracker");
    private Handler mHandler = null;
    private SurfaceControl.OnJankDataListenerRegistration mJankDataListenerRegistration;
    private AttachedSurfaceControl mSurfaceControl;
    private String mActivityName;
    private int mAppUid;
    private View mDecorView;
    private boolean mTrackingEnabled = false;
    private boolean mListenersRegistered = false;
    @FlaggedApi(value="com.android.window.flags.jank_api")
    private final SurfaceControl.OnJankDataListener mJankDataListener = new SurfaceControl.OnJankDataListener(){

        @Override
        public void onJankDataAvailable(@com.android.layoutlib.androidx.annotation.NonNull List<SurfaceControl.JankData> jankData) {
            if (JankTracker.this.mJankDataProcessor == null) {
                return;
            }
            JankTracker.this.mJankDataProcessor.processJankData(jankData, JankTracker.this.mActivityName, JankTracker.this.mAppUid);
        }
    };
    private final ViewTreeObserver.OnWindowAttachListener mOnWindowAttachListener = new ViewTreeObserver.OnWindowAttachListener(){

        @Override
        public void onWindowAttached() {
            JankTracker.this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    JankTracker.this.mDecorView.getViewTreeObserver().removeOnWindowAttachListener(JankTracker.this.mOnWindowAttachListener);
                    JankTracker.this.initializeJankTrackingComponents();
                }
            }, 1000L);
        }

        @Override
        public void onWindowDetached() {
        }
    };

    public JankTracker(Choreographer choreographer, View decorView) {
        this.mStateTracker = new StateTracker(choreographer);
        this.mJankDataProcessor = new JankDataProcessor(this.mStateTracker);
        this.mDecorView = decorView;
        this.mHandlerThread.start();
        this.registerWindowListeners();
    }

    public JankTracker(View decorView) {
        this.mDecorView = decorView;
        this.mHandlerThread.start();
        this.registerWindowListeners();
    }

    public void mergeAppJankStats(final AppJankStats appJankStats) {
        if (appJankStats.getUid() != this.mAppUid) {
            return;
        }
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (JankTracker.this.mJankDataProcessor == null) {
                    return;
                }
                JankTracker.this.mJankDataProcessor.mergeJankStats(appJankStats, JankTracker.this.mActivityName);
            }
        });
    }

    public void setActivityName(@NonNull String activityName) {
        this.mActivityName = activityName;
    }

    public void setAppUid(int uid) {
        this.mAppUid = uid;
    }

    public void addUiState(String widgetCategory, String widgetId, String widgetState) {
        if (!this.shouldTrack()) {
            return;
        }
        this.mStateTracker.putState(widgetCategory, widgetId, widgetState);
    }

    public void removeUiState(String widgetCategory, String widgetId, String widgetState) {
        if (!this.shouldTrack()) {
            return;
        }
        this.mStateTracker.removeState(widgetCategory, widgetId, widgetState);
    }

    public void updateUiState(String widgetCategory, String widgetId, String currentState, String nextState) {
        if (!this.shouldTrack()) {
            return;
        }
        this.mStateTracker.updateState(widgetCategory, widgetId, currentState, nextState);
    }

    public void enableAppJankTracking() {
        this.addActivityToStateTracking();
        this.mTrackingEnabled = true;
        this.registerForJankData();
    }

    public void disableAppJankTracking() {
        this.mTrackingEnabled = false;
        this.removeActivityFromStateTracking();
        this.unregisterForJankData();
    }

    @VisibleForTesting
    public void getAllUiStates(@NonNull ArrayList<StateTracker.StateData> stateDataList) {
        if (this.mStateTracker == null) {
            return;
        }
        this.mStateTracker.retrieveAllStates(stateDataList);
    }

    @VisibleForTesting
    public HashMap<String, JankDataProcessor.PendingJankStat> getPendingJankStats() {
        if (this.mJankDataProcessor == null) {
            return new HashMap<String, JankDataProcessor.PendingJankStat>();
        }
        return this.mJankDataProcessor.getPendingJankStats();
    }

    @VisibleForTesting
    public void forceListenerRegistration() {
        this.addActivityToStateTracking();
        this.mSurfaceControl = this.mDecorView.getRootSurfaceControl();
        this.registerJankDataListener();
        this.mListenersRegistered = true;
    }

    private void unregisterForJankData() {
        if (this.mJankDataListenerRegistration == null) {
            return;
        }
        if (Flags.jankApi()) {
            this.mJankDataListenerRegistration.release();
        }
        this.mJankDataListenerRegistration = null;
        this.mListenersRegistered = false;
    }

    private void registerForJankData() {
        if (this.mDecorView == null) {
            return;
        }
        this.mSurfaceControl = this.mDecorView.getRootSurfaceControl();
        if (this.mSurfaceControl == null || this.mListenersRegistered) {
            return;
        }
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                JankTracker.this.registerJankDataListener();
            }
        }, 1000L);
    }

    @VisibleForTesting
    public boolean shouldTrack() {
        return this.mTrackingEnabled && this.mListenersRegistered;
    }

    private void registerWindowListeners() {
        if (this.mDecorView == null) {
            return;
        }
        this.mDecorView.getViewTreeObserver().addOnWindowAttachListener(this.mOnWindowAttachListener);
    }

    private void registerJankDataListener() {
        if (this.mSurfaceControl == null) {
            return;
        }
        if (Flags.jankApi()) {
            this.mJankDataListenerRegistration = this.mSurfaceControl.registerOnJankDataListener(this.mHandlerThread.getThreadExecutor(), this.mJankDataListener);
            if (this.mJankDataListenerRegistration == SurfaceControl.OnJankDataListenerRegistration.NONE) {
                return;
            }
            this.mListenersRegistered = true;
        }
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.mHandlerThread.getLooper());
        }
        return this.mHandler;
    }

    private void addActivityToStateTracking() {
        if (this.mStateTracker == null) {
            return;
        }
        this.mStateTracker.putState("unspecified", this.mActivityName, "unspecified");
    }

    private void removeActivityFromStateTracking() {
        if (this.mStateTracker == null) {
            return;
        }
        this.mStateTracker.removeState("unspecified", this.mActivityName, "unspecified");
    }

    private void initializeJankTrackingComponents() {
        ViewRootImpl viewRoot = this.mDecorView.getViewRootImpl();
        if (viewRoot == null || viewRoot.getChoreographer() == null) {
            return;
        }
        if (this.mStateTracker == null) {
            this.mStateTracker = new StateTracker(viewRoot.getChoreographer());
        }
        if (this.mJankDataProcessor == null) {
            this.mJankDataProcessor = new JankDataProcessor(this.mStateTracker);
        }
        this.addActivityToStateTracking();
        this.registerForJankData();
    }
}

