/*
 * Decompiled with CFR 0.152.
 */
package android.app.blob;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.List;

public class LeaseInfo
implements Parcelable {
    private final String mPackageName;
    private final long mExpiryTimeMillis;
    private final int mDescriptionResId;
    private final CharSequence mDescription;
    @NonNull
    public static final Parcelable.Creator<LeaseInfo> CREATOR = new Parcelable.Creator<LeaseInfo>(){

        @Override
        @NonNull
        public LeaseInfo createFromParcel(Parcel source) {
            return new LeaseInfo(source);
        }

        @NonNull
        public LeaseInfo[] newArray(int size) {
            return new LeaseInfo[size];
        }
    };

    public LeaseInfo(@NonNull String packageName, long expiryTimeMs, int descriptionResId, @Nullable CharSequence description) {
        this.mPackageName = packageName;
        this.mExpiryTimeMillis = expiryTimeMs;
        this.mDescriptionResId = descriptionResId;
        this.mDescription = description;
    }

    private LeaseInfo(Parcel in) {
        this.mPackageName = in.readString();
        this.mExpiryTimeMillis = in.readLong();
        this.mDescriptionResId = in.readInt();
        this.mDescription = in.readCharSequence();
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    public long getExpiryTimeMillis() {
        return this.mExpiryTimeMillis;
    }

    public int getDescriptionResId() {
        return this.mDescriptionResId;
    }

    @Nullable
    public CharSequence getDescription() {
        return this.mDescription;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mPackageName);
        dest.writeLong(this.mExpiryTimeMillis);
        dest.writeInt(this.mDescriptionResId);
        dest.writeCharSequence(this.mDescription);
    }

    public String toString() {
        return "LeaseInfo {package: " + this.mPackageName + ",expiryMs: " + this.mExpiryTimeMillis + ",descriptionResId: " + this.mDescriptionResId + ",description: " + this.mDescription + ",}";
    }

    private String toShortString() {
        return this.mPackageName;
    }

    static String toShortString(List<LeaseInfo> leaseInfos) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int size = leaseInfos.size();
        for (int i = 0; i < size; ++i) {
            sb.append(leaseInfos.get(i).toShortString());
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

