/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.observer;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.observer.ObserverSpecCreator;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="ObserverSpecCreator")
public class ObserverSpec
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<ObserverSpec> CREATOR = new ObserverSpecCreator();
    @SafeParcelable.Field(id=1)
    final List<String> mFilterSchemas;
    @Nullable
    private volatile Set<String> mFilterSchemasCached;

    @SafeParcelable.Constructor
    public ObserverSpec(@SafeParcelable.Param(id=1) @NonNull List<String> filterSchemas) {
        this.mFilterSchemas = Objects.requireNonNull(filterSchemas);
    }

    @NonNull
    public Set<String> getFilterSchemas() {
        if (this.mFilterSchemasCached == null) {
            this.mFilterSchemasCached = this.mFilterSchemas == null ? Collections.emptySet() : Collections.unmodifiableSet(new ArraySet<String>(this.mFilterSchemas));
        }
        return this.mFilterSchemasCached;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        ObserverSpecCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private ArrayList<String> mFilterSchemas = new ArrayList();
        private boolean mBuilt = false;

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterSchemas(String ... schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            return this.addFilterSchemas(Arrays.asList(schemas));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterSchemas(@NonNull Collection<String> schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            this.mFilterSchemas.addAll(schemas);
            return this;
        }

        @NonNull
        public ObserverSpec build() {
            this.mBuilt = true;
            return new ObserverSpec(this.mFilterSchemas);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mFilterSchemas = new ArrayList<String>(this.mFilterSchemas);
                this.mBuilt = false;
            }
        }
    }
}

