/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appsearch.StorageInfoCreator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;

@SafeParcelable.Class(creator="StorageInfoCreator")
public class StorageInfo
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<StorageInfo> CREATOR = new StorageInfoCreator();
    @SafeParcelable.Field(id=1, getter="getSizeBytes")
    private long mSizeBytes;
    @SafeParcelable.Field(id=2, getter="getAliveDocumentsCount")
    private int mAliveDocumentsCount;
    @SafeParcelable.Field(id=3, getter="getAliveNamespacesCount")
    private int mAliveNamespacesCount;
    @SafeParcelable.Field(id=4, getter="getBlobsSizeBytes")
    private long mBlobsSizeBytes;
    @SafeParcelable.Field(id=5, getter="getBlobsCount")
    private int mBlobsCount;

    @SafeParcelable.Constructor
    StorageInfo(@SafeParcelable.Param(id=1) long sizeBytes, @SafeParcelable.Param(id=2) int aliveDocumentsCount, @SafeParcelable.Param(id=3) int aliveNamespacesCount, @SafeParcelable.Param(id=4) long blobsSizeBytes, @SafeParcelable.Param(id=5) int blobsCount) {
        this.mSizeBytes = sizeBytes;
        this.mAliveDocumentsCount = aliveDocumentsCount;
        this.mAliveNamespacesCount = aliveNamespacesCount;
        this.mBlobsSizeBytes = blobsSizeBytes;
        this.mBlobsCount = blobsCount;
    }

    public long getSizeBytes() {
        return this.mSizeBytes;
    }

    public int getAliveDocumentsCount() {
        return this.mAliveDocumentsCount;
    }

    public int getAliveNamespacesCount() {
        return this.mAliveNamespacesCount;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public long getBlobsSizeBytes() {
        return this.mBlobsSizeBytes;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public int getBlobsCount() {
        return this.mBlobsCount;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        StorageInfoCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private long mSizeBytes;
        private int mAliveDocumentsCount;
        private int mAliveNamespacesCount;
        private long mBlobsSizeBytes;
        private int mBlobsCount;

        @CanIgnoreReturnValue
        @NonNull
        public Builder setSizeBytes(long sizeBytes) {
            this.mSizeBytes = sizeBytes;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setAliveDocumentsCount(int aliveDocumentsCount) {
            this.mAliveDocumentsCount = aliveDocumentsCount;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setAliveNamespacesCount(int aliveNamespacesCount) {
            this.mAliveNamespacesCount = aliveNamespacesCount;
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
        @NonNull
        public Builder setBlobsSizeBytes(long blobsSizeBytes) {
            this.mBlobsSizeBytes = blobsSizeBytes;
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
        @NonNull
        public Builder setBlobsCount(int blobsCount) {
            this.mBlobsCount = blobsCount;
            return this;
        }

        @NonNull
        public StorageInfo build() {
            return new StorageInfo(this.mSizeBytes, this.mAliveDocumentsCount, this.mAliveNamespacesCount, this.mBlobsSizeBytes, this.mBlobsCount);
        }
    }
}

