/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.NonNull;
import android.app.appsearch.AppSearchBatchResult;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.BatchResultCallback;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.aidl.AppSearchBatchResultParcel;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.IAppSearchBatchResultCallback;
import android.app.appsearch.exceptions.AppSearchException;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.GenericDocumentParcel;
import android.util.Log;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class SearchSessionUtil {
    private static final String TAG = "AppSearchSessionUtil";

    private SearchSessionUtil() {
    }

    public static void sendSystemErrorToCallback(@NonNull AppSearchResult<?> failedResult, @NonNull BatchResultCallback<?, ?> callback) {
        Preconditions.checkArgument(!failedResult.isSuccess());
        AppSearchException throwable = new AppSearchException(failedResult.getResultCode(), failedResult.getErrorMessage());
        callback.onSystemError(throwable);
    }

    public static <T> void safeExecute(@NonNull Executor executor, @NonNull Consumer<AppSearchResult<T>> errorCallback, @NonNull Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Failed to schedule runnable", e);
            errorCallback.accept(AppSearchResult.throwableToFailedResult(e));
        }
    }

    public static void safeExecute(@NonNull Executor executor, @NonNull BatchResultCallback<?, ?> errorCallback, @NonNull Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Failed to schedule runnable", e);
            errorCallback.onSystemError(e);
        }
    }

    public static IAppSearchBatchResultCallback createGetDocumentCallback(final @NonNull Executor executor, final @NonNull BatchResultCallback<String, GenericDocument> callback) {
        return new IAppSearchBatchResultCallback.Stub(){

            @Override
            public void onResult(AppSearchBatchResultParcel resultParcel) {
                SearchSessionUtil.safeExecute(executor, callback, () -> {
                    AppSearchBatchResult result = resultParcel.getResult();
                    AppSearchBatchResult.Builder<String, GenericDocument> documentResultBuilder = new AppSearchBatchResult.Builder<String, GenericDocument>();
                    for (Map.Entry entry : result.getSuccesses().entrySet()) {
                        GenericDocument document;
                        try {
                            GenericDocumentParcel genericDocumentParcel = (GenericDocumentParcel)entry.getValue();
                            if (genericDocumentParcel == null) {
                                documentResultBuilder.setFailure(entry.getKey(), 2, "Received null GenericDocumentParcel in getByDocumentId API");
                                continue;
                            }
                            document = new GenericDocument(genericDocumentParcel);
                        }
                        catch (RuntimeException e) {
                            documentResultBuilder.setFailure(entry.getKey(), 2, e.getMessage());
                            continue;
                        }
                        documentResultBuilder.setSuccess(entry.getKey(), document);
                    }
                    for (Map.Entry<String, Object> entry : result.getFailures().entrySet()) {
                        documentResultBuilder.setFailure(entry.getKey(), ((AppSearchResult)entry.getValue()).getResultCode(), ((AppSearchResult)entry.getValue()).getErrorMessage());
                    }
                    callback.onResult(documentResultBuilder.build());
                });
            }

            @Override
            public void onSystemError(AppSearchResultParcel result) {
                SearchSessionUtil.safeExecute(executor, callback, () -> SearchSessionUtil.sendSystemErrorToCallback(result.getResult(), callback));
            }
        };
    }
}

