/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.BatchResultCallback;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.GetByDocumentIdRequest;
import android.app.appsearch.GetSchemaResponse;
import android.app.appsearch.OpenBlobForReadResponse;
import android.app.appsearch.ReadOnlyGlobalSearchSession;
import android.app.appsearch.ReportSystemUsageRequest;
import android.app.appsearch.ReportUsageRequest;
import android.app.appsearch.SearchResults;
import android.app.appsearch.SearchSessionUtil;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.aidl.AppSearchAttributionSource;
import android.app.appsearch.aidl.AppSearchResultCallback;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.IAppSearchObserverProxy;
import android.app.appsearch.aidl.PersistToDiskAidlRequest;
import android.app.appsearch.aidl.RegisterObserverCallbackAidlRequest;
import android.app.appsearch.aidl.ReportUsageAidlRequest;
import android.app.appsearch.aidl.UnregisterObserverCallbackAidlRequest;
import android.app.appsearch.exceptions.AppSearchException;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.observer.DocumentChangeInfo;
import android.app.appsearch.observer.ObserverCallback;
import android.app.appsearch.observer.ObserverSpec;
import android.app.appsearch.observer.SchemaChangeInfo;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class GlobalSearchSession
extends ReadOnlyGlobalSearchSession
implements Closeable {
    private static final String TAG = "AppSearchGlobalSearchSe";
    @GuardedBy(value={"mObserverCallbacksLocked"})
    private final Map<String, Map<ObserverCallback, IAppSearchObserverProxy>> mObserverCallbacksLocked = new ArrayMap<String, Map<ObserverCallback, IAppSearchObserverProxy>>();
    private boolean mIsMutated = false;
    private boolean mIsClosed = false;

    static void createGlobalSearchSession(@NonNull IAppSearchManager service, @NonNull UserHandle userHandle, @NonNull AppSearchAttributionSource attributionSource, @NonNull Executor executor, @NonNull Consumer<AppSearchResult<GlobalSearchSession>> callback) {
        GlobalSearchSession globalSearchSession = new GlobalSearchSession(service, userHandle, attributionSource);
        globalSearchSession.initialize(executor, result -> {
            if (result.isSuccess()) {
                callback.accept(AppSearchResult.newSuccessfulResult(globalSearchSession));
            } else {
                callback.accept(AppSearchResult.newFailedResult(result));
            }
        });
    }

    private GlobalSearchSession(@NonNull IAppSearchManager service, @NonNull UserHandle userHandle, @NonNull AppSearchAttributionSource callerAttributionSource) {
        super(service, userHandle, callerAttributionSource, false);
    }

    @Override
    public void getByDocumentId(@NonNull String packageName, @NonNull String databaseName, @NonNull GetByDocumentIdRequest request, @NonNull Executor executor, @NonNull BatchResultCallback<String, GenericDocument> callback) {
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        super.getByDocumentId(packageName, databaseName, request, executor, callback);
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public void openBlobForRead(@NonNull Set<AppSearchBlobHandle> handles, @NonNull Executor executor, @NonNull Consumer<AppSearchResult<OpenBlobForReadResponse>> callback) {
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        super.openBlobForRead(handles, executor, callback);
    }

    @Override
    @NonNull
    public SearchResults search(@NonNull String queryExpression, @NonNull SearchSpec searchSpec) {
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        return super.search(queryExpression, searchSpec);
    }

    @Override
    public void getSchema(@NonNull String packageName, @NonNull String databaseName, @NonNull Executor executor, @NonNull Consumer<AppSearchResult<GetSchemaResponse>> callback) {
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        super.getSchema(packageName, databaseName, executor, callback);
    }

    public void reportSystemUsage(@NonNull ReportSystemUsageRequest request, final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        try {
            this.mService.reportUsage(new ReportUsageAidlRequest(this.mCallerAttributionSource, request.getPackageName(), request.getDatabaseName(), new ReportUsageRequest(request.getNamespace(), request.getDocumentId(), request.getUsageTimestampMillis()), true, this.mUserHandle, SystemClock.elapsedRealtime()), new AppSearchResultCallback<Void>(this){

                @Override
                public void onResult(@NonNull AppSearchResult<Void> result) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(result));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObserverCallback(@NonNull String targetPackageName, @NonNull ObserverSpec spec, final @NonNull Executor executor, final @NonNull ObserverCallback observer) throws AppSearchException {
        Objects.requireNonNull(targetPackageName);
        Objects.requireNonNull(spec);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(observer);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        Map<String, Map<ObserverCallback, IAppSearchObserverProxy>> map = this.mObserverCallbacksLocked;
        synchronized (map) {
            AppSearchResultParcel resultParcel;
            IAppSearchObserverProxy stub = null;
            Map<ObserverCallback, IAppSearchObserverProxy> observersForPackage = this.mObserverCallbacksLocked.get(targetPackageName);
            if (observersForPackage != null) {
                stub = observersForPackage.get(observer);
            }
            if (stub == null) {
                stub = new IAppSearchObserverProxy.Stub(this){

                    @Override
                    public void onSchemaChanged(@NonNull String packageName, @NonNull String databaseName, @NonNull List<String> changedSchemaNames) {
                        SearchSessionUtil.safeExecute(executor, this::suppressingErrorCallback, () -> {
                            SchemaChangeInfo changeInfo = new SchemaChangeInfo(packageName, databaseName, new ArraySet<String>(changedSchemaNames));
                            observer.onSchemaChanged(changeInfo);
                        });
                    }

                    @Override
                    public void onDocumentChanged(@NonNull String packageName, @NonNull String databaseName, @NonNull String namespace, @NonNull String schemaName, @NonNull List<String> changedDocumentIds) {
                        SearchSessionUtil.safeExecute(executor, this::suppressingErrorCallback, () -> {
                            DocumentChangeInfo changeInfo = new DocumentChangeInfo(packageName, databaseName, namespace, schemaName, new ArraySet<String>(changedDocumentIds));
                            observer.onDocumentChanged(changeInfo);
                        });
                    }

                    private void suppressingErrorCallback(@NonNull AppSearchResult<?> unused) {
                    }
                };
            }
            try {
                resultParcel = this.mService.registerObserverCallback(new RegisterObserverCallbackAidlRequest(this.mCallerAttributionSource, targetPackageName, spec, this.mUserHandle, SystemClock.elapsedRealtime()), stub);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            AppSearchResult result = resultParcel.getResult();
            if (!result.isSuccess()) {
                throw new AppSearchException(result.getResultCode(), result.getErrorMessage());
            }
            if (observersForPackage == null) {
                observersForPackage = new ArrayMap<ObserverCallback, IAppSearchObserverProxy>();
                this.mObserverCallbacksLocked.put(targetPackageName, observersForPackage);
            }
            observersForPackage.put(observer, stub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObserverCallback(@NonNull String targetPackageName, @NonNull ObserverCallback observer) throws AppSearchException {
        Objects.requireNonNull(targetPackageName);
        Objects.requireNonNull(observer);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        Map<String, Map<ObserverCallback, IAppSearchObserverProxy>> map = this.mObserverCallbacksLocked;
        synchronized (map) {
            AppSearchResultParcel resultParcel;
            Map<ObserverCallback, IAppSearchObserverProxy> observersForPackage = this.mObserverCallbacksLocked.get(targetPackageName);
            if (observersForPackage == null) {
                return;
            }
            IAppSearchObserverProxy stub = observersForPackage.get(observer);
            if (stub == null) {
                return;
            }
            try {
                resultParcel = this.mService.unregisterObserverCallback(new UnregisterObserverCallbackAidlRequest(this.mCallerAttributionSource, targetPackageName, this.mUserHandle, SystemClock.elapsedRealtime()), stub);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            AppSearchResult result = resultParcel.getResult();
            if (!result.isSuccess()) {
                throw new AppSearchException(result.getResultCode(), result.getErrorMessage());
            }
            observersForPackage.remove(observer);
            if (observersForPackage.isEmpty()) {
                this.mObserverCallbacksLocked.remove(targetPackageName);
            }
        }
    }

    @Override
    public void close() {
        if (this.mIsMutated && !this.mIsClosed) {
            try {
                this.mService.persistToDisk(new PersistToDiskAidlRequest(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime()));
                this.mIsClosed = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to close the GlobalSearchSession", e);
            }
        }
    }
}

