/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.util.ArrayMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AppSearchBatchResult<KeyType, ValueType> {
    private final @NonNull Map<KeyType, @Nullable ValueType> mSuccesses;
    private final @NonNull Map<KeyType, AppSearchResult<ValueType>> mFailures;
    private final @NonNull Map<KeyType, AppSearchResult<ValueType>> mAll;

    AppSearchBatchResult(@NonNull Map<KeyType, @Nullable ValueType> successes, @NonNull Map<KeyType, AppSearchResult<ValueType>> failures, @NonNull Map<KeyType, AppSearchResult<ValueType>> all) {
        this.mSuccesses = Objects.requireNonNull(successes);
        this.mFailures = Objects.requireNonNull(failures);
        this.mAll = Objects.requireNonNull(all);
    }

    public boolean isSuccess() {
        return this.mFailures.isEmpty();
    }

    public @NonNull Map<KeyType, ValueType> getSuccesses() {
        return Collections.unmodifiableMap(this.mSuccesses);
    }

    public @NonNull Map<KeyType, AppSearchResult<ValueType>> getFailures() {
        return Collections.unmodifiableMap(this.mFailures);
    }

    public @NonNull Map<KeyType, AppSearchResult<ValueType>> getAll() {
        return Collections.unmodifiableMap(this.mAll);
    }

    public void checkSuccess() {
        if (!this.isSuccess()) {
            throw new IllegalStateException("AppSearchBatchResult has failures: " + this);
        }
    }

    public @NonNull String toString() {
        return "{\n  successes: " + this.mSuccesses + "\n  failures: " + this.mFailures + "\n}";
    }

    public static class Builder<KeyType, ValueType> {
        private ArrayMap<KeyType, @Nullable ValueType> mSuccesses = new ArrayMap();
        private ArrayMap<KeyType, AppSearchResult<ValueType>> mFailures = new ArrayMap();
        private ArrayMap<KeyType, AppSearchResult<ValueType>> mAll = new ArrayMap();
        private boolean mBuilt = false;

        public Builder() {
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        public Builder(@NonNull AppSearchBatchResult<KeyType, ValueType> appSearchBatchResult) {
            this.mSuccesses.putAll(appSearchBatchResult.mSuccesses);
            this.mFailures.putAll(appSearchBatchResult.mFailures);
            this.mAll.putAll(appSearchBatchResult.mAll);
        }

        @CanIgnoreReturnValue
        public @NonNull Builder<KeyType, ValueType> setSuccess(@NonNull KeyType key, @Nullable ValueType value) {
            Objects.requireNonNull(key);
            this.resetIfBuilt();
            return this.setResult(key, AppSearchResult.newSuccessfulResult(value));
        }

        @CanIgnoreReturnValue
        public @NonNull Builder<KeyType, ValueType> setFailure(@NonNull KeyType key, int resultCode, @Nullable String errorMessage) {
            Objects.requireNonNull(key);
            this.resetIfBuilt();
            return this.setResult(key, AppSearchResult.newFailedResult(resultCode, errorMessage));
        }

        @CanIgnoreReturnValue
        public @NonNull Builder<KeyType, ValueType> setResult(@NonNull KeyType key, @NonNull AppSearchResult<ValueType> result) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(result);
            this.resetIfBuilt();
            if (result.isSuccess()) {
                this.mSuccesses.put(key, result.getResultValue());
                this.mFailures.remove(key);
            } else {
                this.mFailures.put(key, result);
                this.mSuccesses.remove(key);
            }
            this.mAll.put(key, result);
            return this;
        }

        public @NonNull AppSearchBatchResult<KeyType, ValueType> build() {
            this.mBuilt = true;
            return new AppSearchBatchResult<KeyType, ValueType>(this.mSuccesses, this.mFailures, this.mAll);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mSuccesses = new ArrayMap<KeyType, ValueType>(this.mSuccesses);
                this.mFailures = new ArrayMap<KeyType, AppSearchResult<ValueType>>(this.mFailures);
                this.mAll = new ArrayMap<KeyType, AppSearchResult<ValueType>>(this.mAll);
                this.mBuilt = false;
            }
        }
    }
}

