/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.Nullable;
import android.app.appsearch.GenericDocument;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.MathUtils;
import com.android.layoutlib.androidx.annotation.GuardedBy;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Objects;

public class GenericDocumentWrapper
implements Parcelable {
    @Nullable
    @GuardedBy(value="mLock")
    private GenericDocument mGenericDocument;
    @GuardedBy(value="mLock")
    @Nullable
    private Parcel mParcel;
    @GuardedBy(value="mLock")
    @Nullable
    private Integer mDataSize;
    private final Object mLock = new Object();
    public static final Parcelable.Creator<GenericDocumentWrapper> CREATOR = new Parcelable.Creator<GenericDocumentWrapper>(){

        @Override
        public GenericDocumentWrapper createFromParcel(Parcel in) {
            int length = in.readInt();
            int offset = in.dataPosition();
            in.setDataPosition(MathUtils.addOrThrow(offset, length));
            Parcel p = Parcel.obtain();
            p.appendFrom(in, offset, length);
            p.setDataPosition(0);
            return new GenericDocumentWrapper(p);
        }

        public GenericDocumentWrapper[] newArray(int size) {
            return new GenericDocumentWrapper[size];
        }
    };

    public GenericDocumentWrapper(@NonNull GenericDocument genericDocument) {
        this.mGenericDocument = Objects.requireNonNull(genericDocument);
        this.mParcel = null;
        this.mDataSize = null;
    }

    public GenericDocumentWrapper(@NonNull Parcel parcel) {
        this.mGenericDocument = null;
        this.mParcel = Objects.requireNonNull(parcel);
        this.mDataSize = this.mParcel.dataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public GenericDocument getValue() {
        this.unparcel();
        Object object = this.mLock;
        synchronized (object) {
            return Objects.requireNonNull(this.mGenericDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unparcel() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mGenericDocument != null) {
                return;
            }
            byte[] dataBlob = Objects.requireNonNull(Objects.requireNonNull(this.mParcel).readBlob());
            Parcel unmarshallParcel = Parcel.obtain();
            try {
                unmarshallParcel.unmarshall(dataBlob, 0, dataBlob.length);
                unmarshallParcel.setDataPosition(0);
                this.mGenericDocument = GenericDocument.createFromParcel(unmarshallParcel);
                this.mParcel = null;
            }
            finally {
                unmarshallParcel.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDataSize() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDataSize != null) {
                return this.mDataSize;
            }
            Parcel tempParcel = Parcel.obtain();
            this.writeToParcel(tempParcel, 0);
            this.mDataSize = tempParcel.dataSize();
            tempParcel.recycle();
            return this.mDataSize;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mGenericDocument != null) {
                byte[] bytes;
                int lengthPos = dest.dataPosition();
                dest.writeInt(-1);
                Parcel tempParcel = Parcel.obtain();
                try {
                    this.mGenericDocument.writeToParcel(tempParcel, flags);
                    bytes = tempParcel.marshall();
                }
                finally {
                    tempParcel.recycle();
                }
                int startPos = dest.dataPosition();
                dest.writeBlob(bytes);
                int endPos = dest.dataPosition();
                dest.setDataPosition(lengthPos);
                dest.writeInt(endPos - startPos);
                dest.setDataPosition(endPos);
            } else {
                Parcel originalParcel = Objects.requireNonNull(this.mParcel);
                dest.writeInt(originalParcel.dataSize());
                dest.appendFrom(originalParcel, 0, originalParcel.dataSize());
            }
        }
    }
}

