/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="android.permission.flags.app_function_access_api_enabled")
public class AppFunctionUriGrant
implements Parcelable {
    private static final int ALLOWED_MODE_FLAG_MASK = 131;
    @NonNull
    public static final Parcelable.Creator<AppFunctionUriGrant> CREATOR = new Parcelable.Creator<AppFunctionUriGrant>(){

        @Override
        public AppFunctionUriGrant createFromParcel(Parcel parcel) {
            Uri uri = Objects.requireNonNull(Uri.CREATOR.createFromParcel(parcel));
            int modeFlags = parcel.readInt();
            return new AppFunctionUriGrant(uri, modeFlags);
        }

        public AppFunctionUriGrant[] newArray(int size) {
            return new AppFunctionUriGrant[size];
        }
    };
    @NonNull
    private final Uri mUri;
    private final int mModeFlags;

    public AppFunctionUriGrant(@NonNull Uri uri, int modeFlags) {
        this.mUri = Objects.requireNonNull(uri);
        if ((modeFlags & 0xFFFFFF7C) != 0) {
            throw new IllegalArgumentException("Contains invalid flags: Allowed flags are FLAG_GRANT_READ_URI_PERMISSION, FLAG_GRANT_WRITE_URI_PERMISSION and FLAG_GRANT_PREFIX_URI_PERMISSION");
        }
        if (!Intent.isAccessUriMode(modeFlags)) {
            throw new IllegalArgumentException("Must set either FLAG_GRANT_READ_URI_PERMISSION or FLAG_GRANT_WRITE_URI_PERMISSION to specify the access mode");
        }
        this.mModeFlags = modeFlags;
    }

    @NonNull
    public Uri getUri() {
        return this.mUri;
    }

    public int getModeFlags() {
        return this.mModeFlags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppFunctionUriGrant that = (AppFunctionUriGrant)o;
        return this.mModeFlags == that.mModeFlags && this.mUri.equals(that.mUri);
    }

    public int hashCode() {
        return Objects.hash(this.mUri, this.mModeFlags);
    }

    @NonNull
    public String toString() {
        return "AppFunctionGrantUri(uri=" + this.mUri.toString() + ",modeFlags" + this.mModeFlags + ")";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Uri.writeToParcel(dest, this.mUri);
        dest.writeInt(this.mModeFlags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GrantUriMode {
    }
}

