/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
public class AppFunctionException
extends Exception
implements Parcelable {
    public static final int ERROR_DENIED = 1000;
    public static final int ERROR_INVALID_ARGUMENT = 1001;
    public static final int ERROR_DISABLED = 1002;
    public static final int ERROR_FUNCTION_NOT_FOUND = 1003;
    public static final int ERROR_SYSTEM_ERROR = 2000;
    public static final int ERROR_CANCELLED = 2001;
    public static final int ERROR_ENTERPRISE_POLICY_DISALLOWED = 2002;
    public static final int ERROR_APP_UNKNOWN_ERROR = 3000;
    public static final int ERROR_CATEGORY_UNKNOWN = 0;
    public static final int ERROR_CATEGORY_REQUEST_ERROR = 1;
    public static final int ERROR_CATEGORY_SYSTEM = 2;
    public static final int ERROR_CATEGORY_APP = 3;
    private final int mErrorCode;
    @Nullable
    private final String mErrorMessage;
    @NonNull
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<AppFunctionException> CREATOR = new Parcelable.Creator<AppFunctionException>(){

        @Override
        public AppFunctionException createFromParcel(Parcel in) {
            return new AppFunctionException(in);
        }

        public AppFunctionException[] newArray(int size) {
            return new AppFunctionException[size];
        }
    };

    public AppFunctionException(int errorCode, @Nullable String errorMessage) {
        this(errorCode, errorMessage, Bundle.EMPTY);
    }

    public AppFunctionException(int errorCode, @Nullable String errorMessage, @NonNull Bundle extras) {
        super(errorMessage);
        this.mErrorCode = errorCode;
        this.mErrorMessage = errorMessage;
        this.mExtras = Objects.requireNonNull(extras);
    }

    private AppFunctionException(@NonNull Parcel in) {
        this.mErrorCode = in.readInt();
        this.mErrorMessage = in.readString8();
        this.mExtras = Objects.requireNonNull(in.readBundle(this.getClass().getClassLoader()));
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Nullable
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public int getErrorCategory() {
        if (this.mErrorCode >= 1000 && this.mErrorCode < 2000) {
            return 1;
        }
        if (this.mErrorCode >= 2000 && this.mErrorCode < 3000) {
            return 2;
        }
        if (this.mErrorCode >= 3000 && this.mErrorCode < 4000) {
            return 3;
        }
        return 0;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mErrorCode);
        dest.writeString8(this.mErrorMessage);
        dest.writeBundle(this.mExtras);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCategory {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

