/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="android.permission.flags.app_function_access_api_enabled")
public class AppFunctionAttribution
implements Parcelable {
    @NonNull
    private static final String TAG = "AppFunctionAttribution";
    @NonNull
    public static final Parcelable.Creator<AppFunctionAttribution> CREATOR = new Parcelable.Creator<AppFunctionAttribution>(){

        @Override
        public AppFunctionAttribution createFromParcel(Parcel parcel) {
            return new AppFunctionAttribution(parcel);
        }

        public AppFunctionAttribution[] newArray(int size) {
            return new AppFunctionAttribution[0];
        }
    };
    public static final int INTERACTION_TYPE_OTHER = 0;
    public static final int INTERACTION_TYPE_USER_QUERY = 1;
    public static final int INTERACTION_TYPE_USER_SCHEDULED = 2;
    private final int mInteractionType;
    @Nullable
    private final String mCustomInteractionType;
    @Nullable
    private final String mThreadId;
    @Nullable
    private final Uri mInteractionUri;

    private AppFunctionAttribution(int interactionType, @Nullable String customInteractionType, @Nullable String threadId, @Nullable Uri interactionUri) {
        this.mInteractionType = interactionType;
        if (interactionType == 0 && customInteractionType == null) {
            throw new IllegalArgumentException("Must set customInteractionType when interactionType=INTERACTION_TYPE_OTHER");
        }
        if (customInteractionType != null && interactionType != 0) {
            throw new IllegalArgumentException("customInteractionType is only allowed when interactionType=INTERACTION_TYPE_OTHER");
        }
        this.mCustomInteractionType = customInteractionType;
        this.mThreadId = threadId;
        this.mInteractionUri = interactionUri;
    }

    private AppFunctionAttribution(@NonNull Parcel in) {
        this.mInteractionType = in.readInt();
        this.mCustomInteractionType = in.readString8();
        this.mThreadId = in.readString8();
        this.mInteractionUri = in.readTypedObject(Uri.CREATOR);
    }

    public int getInteractionType() {
        return this.mInteractionType;
    }

    @Nullable
    public String getCustomInteractionType() {
        return this.mCustomInteractionType;
    }

    @Nullable
    public String getThreadId() {
        return this.mThreadId;
    }

    @Nullable
    public Uri getInteractionUri() {
        return this.mInteractionUri;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mInteractionType);
        dest.writeString8(this.mCustomInteractionType);
        dest.writeString8(this.mThreadId);
        dest.writeTypedObject(this.mInteractionUri, flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppFunctionAttribution that = (AppFunctionAttribution)o;
        return this.mInteractionType == that.mInteractionType && Objects.equals(this.mCustomInteractionType, that.mCustomInteractionType) && Objects.equals(this.mThreadId, that.mThreadId) && Objects.equals(this.mInteractionUri, that.mInteractionUri);
    }

    public int hashCode() {
        return Objects.hash(this.mInteractionType, this.mCustomInteractionType, this.mThreadId, this.mInteractionUri);
    }

    public String toString() {
        return "AppFunctionAttribution(interactionType=" + this.mInteractionType + ",customInteractionType=" + this.mCustomInteractionType + ",threadId=" + this.mThreadId + ",interactionUri=" + this.mInteractionUri + ")";
    }

    public static class Builder {
        private final int mInteractionType;
        @Nullable
        private String mCustomInteractionType;
        @Nullable
        private String mThreadId;
        @Nullable
        private Uri mInteractionUri;

        public Builder(int interactionType) {
            this.mInteractionType = interactionType;
        }

        @NonNull
        public Builder setCustomInteractionType(@NonNull String customInteractionType) {
            if (this.mInteractionType != 0) {
                throw new IllegalArgumentException("Cannot set customInteractionType because the interaction type is not INTERACTION_TYPE_OTHER");
            }
            this.mCustomInteractionType = Objects.requireNonNull(customInteractionType);
            return this;
        }

        @NonNull
        public Builder setThreadId(@Nullable String threadId) {
            this.mThreadId = threadId;
            return this;
        }

        @NonNull
        public Builder setInteractionUri(@Nullable Uri interactionUri) {
            this.mInteractionUri = interactionUri;
            return this;
        }

        @NonNull
        public AppFunctionAttribution build() {
            if (this.mInteractionType == 0 && this.mCustomInteractionType == null) {
                throw new IllegalArgumentException("Must set customInteractionType since interactionType=INTERACTION_TYPE_OTHER");
            }
            return new AppFunctionAttribution(this.mInteractionType, this.mCustomInteractionType, this.mThreadId, this.mInteractionUri);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InteractionType {
    }
}

