/*
 * Decompiled with CFR 0.152.
 */
package android.app.ambientcontext;

import android.app.ambientcontext.AmbientContextEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IAmbientContextObserver
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ambientcontext.IAmbientContextObserver";

    public void onEvents(List<AmbientContextEvent> var1) throws RemoteException;

    public void onRegistrationComplete(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAmbientContextObserver {
        static final int TRANSACTION_onEvents = 1;
        static final int TRANSACTION_onRegistrationComplete = 2;

        public Stub() {
            this.attachInterface(this, IAmbientContextObserver.DESCRIPTOR);
        }

        public static IAmbientContextObserver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAmbientContextObserver.DESCRIPTOR);
            if (iin != null && iin instanceof IAmbientContextObserver) {
                return (IAmbientContextObserver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEvents";
                }
                case 2: {
                    return "onRegistrationComplete";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAmbientContextObserver.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ArrayList<AmbientContextEvent> _arg0 = data.createTypedArrayList(AmbientContextEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onEvents(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRegistrationComplete(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IAmbientContextObserver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAmbientContextObserver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvents(List<AmbientContextEvent> events) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAmbientContextObserver.DESCRIPTOR);
                    _data.writeTypedList(events, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistrationComplete(int statusCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAmbientContextObserver.DESCRIPTOR);
                    _data.writeInt(statusCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAmbientContextObserver {
        @Override
        public void onEvents(List<AmbientContextEvent> events) throws RemoteException {
        }

        @Override
        public void onRegistrationComplete(int statusCode) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

